/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.players;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.audio.AudioSpec;
import quicktime.app.display.QTDrawable;
import quicktime.app.players.Playable;
import quicktime.app.players.QTPlayerEventHandler;
import quicktime.app.time.TaskThread;
import quicktime.app.time.Tasking;
import quicktime.qd.QDDimension;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeBase;
import quicktime.std.image.Matrix;
import quicktime.std.movies.MovieController;

public class QTPlayer
extends Tasking
implements QTDrawable,
Playable,
AudioSpec {
    MovieController controller;
    private TaskThread tt;
    private boolean setControllerVisibleFlag = false;
    private boolean reserveSize = true;
    private QTPlayerEventHandler eventHandler;
    private boolean redrawRequired = false;

    public QTPlayer(MovieController movieController) throws StdQTException {
        this.controller = movieController;
    }

    public void addedTo(Object object) {
        if (this.eventHandler == null) {
            this.eventHandler = QTPlayerEventHandler.make(this, object);
        }
        if (this.eventHandler != null) {
            this.eventHandler.addedTo();
        }
    }

    public void removedFrom(Object object) {
        if (this.eventHandler != null) {
            this.eventHandler.removedFrom();
        }
        this.eventHandler = null;
    }

    public MovieController getMovieController() {
        return this.controller;
    }

    public Dimension getInitialSize() throws QTException {
        QDDimension qDDimension = this.getOriginalSize();
        return new Dimension(qDDimension.getWidth(), qDDimension.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        QDDimension qDDimension = this.controller.getRequiredSize();
        QDRect qDRect = this.controller.getMovie().getNaturalBoundsRect();
        return new QDDimension(qDRect.getWidth() + qDDimension.getWidth(), qDRect.getHeight() + qDDimension.getHeight());
    }

    public Matrix getMatrix() throws StdQTException {
        return this.controller.getMovie().getMatrix();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.controller.getMovie().setMatrix(matrix);
        this.controller.movieChanged();
        this.controller.idle();
    }

    public QDGraphics getGWorld() throws StdQTException {
        return this.controller.getPort();
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws QDException, StdQTException {
        if (this.getGWorld().equals(qDGraphics)) {
            return;
        }
        this.controller.setPort(qDGraphics);
        if (!QDGraphics.scratch.equals(qDGraphics)) {
            this.startTasking();
            this.redrawRequired = true;
            this.controller.getMovie().setActive(true);
        } else {
            this.setRate(0.0f);
            this.stopTasking();
            this.controller.getMovie().setActive(false);
        }
    }

    public final void redraw(Region region) throws QTException {
        if (region != null) {
            try {
                this.controller.invalidate(this.getGWorld(), region);
                this.controller.idle();
            }
            catch (StdQTException stdQTException) {
                this.controller.draw();
            }
        } else {
            this.controller.draw();
        }
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws QTException {
        QDDimension qDDimension = this.controller.getRequiredSize();
        if (qDRect.getHeight() < qDDimension.getHeight() || qDRect.getWidth() < qDDimension.getWidth()) {
            if (this.controller.getVisible()) {
                this.controller.setVisible(false);
                this.setControllerVisibleFlag = true;
            }
            qDRect.setHeight(qDRect.getHeight() + qDDimension.getHeight());
            qDRect.setWidth(qDRect.getWidth() + qDDimension.getWidth());
        } else {
            if (this.setControllerVisibleFlag) {
                this.controller.setVisible(true);
                this.setControllerVisibleFlag = false;
            }
            if (!this.reserveSize && !this.controller.getVisible()) {
                qDRect.setHeight(qDRect.getHeight() + qDDimension.getHeight());
                qDRect.setWidth(qDRect.getWidth() + qDDimension.getWidth());
            }
        }
        this.controller.setBounds(qDRect);
        if (this.redrawRequired) {
            this.redrawRequired = false;
            if (this.controller.getVisible()) {
                this.redraw(null);
            }
        }
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws StdQTException {
        return this.controller.getVisible() ? this.controller.getBounds() : (this.reserveSize ? this.controller.getBounds() : this.controller.getMovie().getBounds());
    }

    public final void task() throws QTException {
        this.controller.idle();
    }

    public void setClip(Region region) throws QTException {
        this.controller.setClip(region);
    }

    public Region getClip() throws QTException {
        return this.controller.getClip();
    }

    public void setTime(int n) throws StdQTException {
        this.controller.getMovie().setTimeValue(n);
        this.controller.movieChanged();
    }

    public int getTime() throws StdQTException {
        return this.controller.getMovie().getTime();
    }

    public int getDuration() throws StdQTException {
        return this.controller.getMovie().getDuration();
    }

    public TimeBase getTimeBase() throws QTException {
        return this.controller.getMovie().getTimeBase();
    }

    public void setRate(float f) throws StdQTException {
        if (f != 0.0f) {
            this.controller.prerollAndPlay(f);
        } else {
            this.controller.play(f);
        }
    }

    public float getRate() throws StdQTException {
        return this.controller.getMovie().getRate();
    }

    public int getScale() throws QTException {
        return this.controller.getMovie().getTimeScale();
    }

    public float getVolume() throws QTException {
        float f = this.controller.getVolume();
        return Math.abs(f);
    }

    public void setVolume(float f) throws QTException {
        float f2 = Math.abs(f);
        if (this.isMuted()) {
            this.controller.setVolume(f2 * -1.0f);
        } else {
            this.controller.setVolume(f2);
        }
    }

    public boolean isMuted() throws QTException {
        return this.controller.getVolume() < 0.0f;
    }

    public void setMuted(boolean bl) throws QTException {
        float f = Math.abs(this.controller.getVolume());
        if (bl) {
            this.controller.setVolume(f * -1.0f);
        } else {
            this.controller.setVolume(f);
        }
    }

    public void setControllerVisible(boolean bl) throws QTException {
        this.controller.setVisible(bl);
        if (this.setControllerVisibleFlag && !bl) {
            this.setControllerVisibleFlag = false;
        }
    }

    public boolean isControllerVisible() throws QTException {
        return this.controller.getVisible();
    }

    public void setControllerSizeReserved(boolean bl) throws QTException {
        this.reserveSize = bl;
        this.setDisplayBounds(this.getDisplayBounds());
    }

    public boolean isControllerSizeReserved() {
        return this.reserveSize;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

