/*
 * Decompiled with CFR 0.152.
 */
package quicktime.jdirect;

import com.apple.mrj.jdirect.Linker;
import com.apple.mrj.macos.carbon.CarbonLock;
import com.apple.mrj.macos.toolbox.Toolbox;
import quicktime.QTSession;
import quicktime.jdirect.JDirectLinker;

public final class QTNative {
    public static final Object globalsLock = QTNative._getLock();
    private static Object _lock;

    private QTNative() {
    }

    public static Object linkNativeMethods(Class clazz) {
        if (QTSession.isCurrentOS(2)) {
            JDirectLinker.linkNativeMethods(clazz);
            return null;
        }
        if (QTSession.isCurrentOS(4)) {
            if (QTSession.getJavaVersion() >= 65540) {
                return new quicktime.internal.jdirect.Linker(clazz);
            }
            return new Linker(clazz);
        }
        return null;
    }

    static Object loadQT() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJavaNative");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"QuickTimeLib");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object loadQTS() {
        if (QTSession.isCurrentOS(2)) {
            return null;
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"QTStreamLib");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object loadIL() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJavaNative");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"InterfaceLib");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object loadPL() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJava");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"AppleJava");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object loadVR() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJava");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"QuickTimeVRLib");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object load3D() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJava");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"QuickDraw\u2122 3D");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    static Object loadSL() {
        if (QTSession.isCurrentOS(2)) {
            return JDirectLinker.loadLibrary("QTJava");
        }
        if (QTSession.isCurrentOS(1)) {
            return com.apple.mrj.jdirect.JDirectLinker.loadLibrary((String)"SoundLib");
        }
        if (QTSession.isCurrentOS(4)) {
            return null;
        }
        throw new UnsatisfiedLinkError("Unknown OS");
    }

    private static Object _getLock() {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() < 65540) {
            _lock = CarbonLock.getInstance();
        } else if (QTSession.isCurrentOS(1)) {
            _lock = Toolbox.LOCK;
        } else if (_lock == null) {
            _lock = new Object();
        }
        return _lock;
    }
}

