/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.WinJNIDrawingSurface;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.NativeGraphics;
import quicktime.qd.NativeGraphicsException;
import quicktime.qd.QDGraphics;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.Win32DrawingSurface;

final class WinNativeGraphics
extends NativeGraphics
implements QuickTimeLib {
    private static Object linkage;
    private static Vector hWndVector;
    private static final boolean debug = false;
    int hWnd = 0;
    static /* synthetic */ Class class$quicktime$qd$WinNativeGraphics;

    private static final void _destroyPorts() {
        Enumeration enumeration = hWndVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            WinNativeGraphics.DestroyPortAssociation(WinNativeGraphics.GetNativeWindowPort((Integer)e));
        }
        hWndVector.removeAllElements();
    }

    WinNativeGraphics(int n) {
        super((Object)null);
        this.hWnd = n;
        this.createAssociation();
    }

    WinNativeGraphics(WinJNIDrawingSurface winJNIDrawingSurface) {
        super(winJNIDrawingSurface);
        if (QTSession.getJavaVersion() >= 65540) {
            this.jnidrawingsurfaceinfo.lock();
            this.hWnd = this.jnidrawingsurfaceinfo.getHWnd();
            this.jnidrawingsurfaceinfo.unlock();
        }
        this.createAssociation();
    }

    WinNativeGraphics(DrawingSurfaceInfo drawingSurfaceInfo) {
        super(drawingSurfaceInfo);
        Win32DrawingSurface win32DrawingSurface = (Win32DrawingSurface)this.dsi.getSurface();
        this.dsi.lock();
        this.hWnd = win32DrawingSurface.getHWnd();
        this.dsi.unlock();
        this.createAssociation();
    }

    private void createAssociation() {
        int n;
        boolean bl = false;
        for (n = 0; n < hWndVector.size(); ++n) {
            if ((Integer)hWndVector.elementAt(n) != this.hWnd) continue;
            bl = true;
            break;
        }
        if (!bl) {
            n = WinNativeGraphics.CreatePortAssociation(this.hWnd, 0, 2);
            if (n == 0) {
                throw new QTRuntimeException("No Port for HWnd");
            }
            hWndVector.addElement(new Integer(this.hWnd));
        }
    }

    public final QDGraphics getGWorld() throws NativeGraphicsException {
        return QDGraphics.fromNativeGraphics(this);
    }

    private void removeContext() {
        if (this.hWnd != 0) {
            if (hWndVector.isEmpty()) {
                this.hWnd = 0;
                return;
            }
            for (int i = 0; i < hWndVector.size(); ++i) {
                if ((Integer)hWndVector.elementAt(i) != this.hWnd) continue;
                hWndVector.removeElementAt(i);
                WinNativeGraphics.DestroyPortAssociation(WinNativeGraphics.GetNativeWindowPort(this.hWnd));
                break;
            }
            this.hWnd = 0;
        }
    }

    int _getWindow() throws NativeGraphicsException {
        return 0;
    }

    protected void finalize() throws Throwable {
        this.removeContext();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "[vector=" + hWndVector + ",hWnd=" + this.hWnd + "]";
    }

    private static native void DestroyPortAssociation(int var0);

    private static native int GetNativeWindowPort(int var0);

    private static native int CreatePortAssociation(int var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$WinNativeGraphics == null ? (class$quicktime$qd$WinNativeGraphics = WinNativeGraphics.class$("quicktime.qd.WinNativeGraphics")) : class$quicktime$qd$WinNativeGraphics);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        hWndVector = new Vector();
    }
}

