/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import com.apple.mrj.jdirect.CompletionRoutineNotifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.MethodClosure;
import quicktime.sound.SICompletion;
import quicktime.sound.SPB;
import quicktime.sound.SndChannel;
import quicktime.sound.SoundCallBack;

final class SoundRunner {
    private static int activeCallbacks = 0;
    private static Thread idleThread;
    private static int whichThread;
    private Thread runnerThread;
    private SoundMethodClosure mMethodClosure;
    private SInterruptClosure mInterruptClosure;
    private SPB soundParamBlock;
    private SICompletion completion;
    private SndChannel sndChan;
    private SoundCallBack callback;
    private boolean notified = false;
    private boolean completionDone = false;

    SoundRunner(SPB sPB, SICompletion sICompletion) {
        this.soundParamBlock = sPB;
        this.completion = sICompletion;
    }

    SoundRunner(SoundCallBack soundCallBack) {
        this.callback = soundCallBack;
    }

    final void setSndChannel(SndChannel sndChannel) {
        this.sndChan = sndChannel;
    }

    private void siCompletion(int n) {
        this.doNotify();
    }

    private void sndCallBack(int n, int n2) {
        this.doNotify();
    }

    private synchronized void doWait() {
        try {
            if (this.notified) {
                return;
            }
            this.wait();
            this.notified = true;
        }
        catch (InterruptedException interruptedException) {
            this.notified = false;
        }
    }

    private synchronized void doNotify() {
        this.notified = true;
        this.notifyAll();
    }

    final void cleanup() {
        this.completionDone = true;
        if (QTSession.isCurrentOS(1) && --activeCallbacks < 1) {
            idleThread = null;
            activeCallbacks = 0;
        }
        if (!this.notified) {
            this.doNotify();
        }
        this.mInterruptClosure = null;
        this.mMethodClosure = null;
        this.runnerThread = null;
    }

    final int getClosure() {
        this.setUpThread();
        if (this.mInterruptClosure != null) {
            return this.mInterruptClosure.fetchPointer();
        }
        if (this.mMethodClosure != null) {
            return this.mMethodClosure.getClosure();
        }
        throw new QTRuntimeException("No Method Closure object created");
    }

    private void setUpThread() {
        if (this.runnerThread != null) {
            return;
        }
        if (QTSession.isCurrentOS(1)) {
            this.mInterruptClosure = this.soundParamBlock != null ? new SInterruptClosure(192, this) : new SInterruptClosure(960, this);
            ++activeCallbacks;
            if (idleThread == null) {
                idleThread = new Thread(new MRJIdler());
                idleThread.start();
            }
        } else {
            SoundMethodClosure soundMethodClosure = this.mMethodClosure = this.soundParamBlock != null ? new SoundMethodClosure(this, "siCompletion", "(I)V", 192) : new SoundMethodClosure(this, "sndCallBack", "(II)V", 960);
        }
        if (QTSession.getJavaVersion() == 65537) {
            Thread thread;
            if (this.soundParamBlock != null) {
                Thread thread2 = new Thread((Runnable)new CompletionRunner(), "Sound Completion Thread:" + Integer.toString(++whichThread));
                thread = thread2;
            } else {
                Thread thread3 = new Thread((Runnable)new SndCallbackRunner(), "SndChannel CallBack Thread:" + Integer.toString(++whichThread));
                thread = thread3;
            }
            this.runnerThread = thread;
        } else {
            class QTJPrivelegedAction {
                QTJPrivelegedAction() {
                }

                Object doPrivelegedAction() {
                    return AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ QTJPrivelegedAction this$1;
                        {
                            this.this$1 = qTJPrivelegedAction;
                        }

                        public Object run() {
                            return SoundRunner.access$100(QTJPrivelegedAction.access$000(this.this$1)) != null ? new Thread((Runnable)QTJPrivelegedAction.access$000(this.this$1).new CompletionRunner(), "Sound Completion Thread:" + Integer.toString(SoundRunner.access$204())) : new Thread((Runnable)QTJPrivelegedAction.access$000(this.this$1).new SndCallbackRunner(), "SndChannel CallBack Thread:" + Integer.toString(SoundRunner.access$204()));
                        }
                    });
                }

                static /* synthetic */ SoundRunner access$000(QTJPrivelegedAction qTJPrivelegedAction) {
                    return qTJPrivelegedAction.SoundRunner.this;
                }
            }
            this.runnerThread = (Thread)new QTJPrivelegedAction().doPrivelegedAction();
        }
        this.runnerThread.setPriority(10);
        this.notified = false;
        this.completionDone = false;
        this.runnerThread.start();
    }

    static /* synthetic */ int access$204() {
        return ++whichThread;
    }

    static class MRJIdler
    implements Runnable {
        MRJIdler() {
        }

        public void run() {
            try {
                while (activeCallbacks >= 1) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            idleThread = null;
        }
    }

    static class SInterruptClosure
    extends CompletionRoutineNotifier {
        SInterruptClosure(int n, Object object) {
            super(n, object);
        }

        int fetchPointer() {
            return this.getPointer();
        }
    }

    static class SoundMethodClosure
    extends MethodClosure {
        SoundMethodClosure(Object object, String string, String string2, int n) {
            super(object, string, string2, n);
        }

        int getClosure() {
            return this.closure;
        }
    }

    class SndCallbackRunner
    implements Runnable {
        SndCallbackRunner() {
        }

        public void run() {
            while (true) {
                SoundRunner.this.doWait();
                if (!SoundRunner.this.notified || SoundRunner.this.completionDone) break;
                SoundRunner.this.callback.execute(SoundRunner.this.sndChan);
                SoundRunner.this.notified = false;
            }
            SoundRunner.this.cleanup();
        }
    }

    class CompletionRunner
    implements Runnable {
        CompletionRunner() {
        }

        public void run() {
            while (true) {
                SoundRunner.this.doWait();
                if (!SoundRunner.this.notified || SoundRunner.this.completionDone) break;
                SoundRunner.this.completion.execute(SoundRunner.this.soundParamBlock);
                SoundRunner.this.notified = false;
            }
            SoundRunner.this.cleanup();
        }
    }
}

