/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.ColorTable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.comp.Component;
import quicktime.std.movies.ActionFilter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MoviesDispatcher;
import quicktime.util.QTUtils;
import quicktime.util.StringHandle;

public class MovieController
extends Component
implements QuickTimeLib {
    private static Object linkage;
    private static final boolean isMacOS;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    private int currentPort = 0;
    static Hashtable mcHashtable;
    private static int currentSessionID;
    private Movie movieRef = null;
    private MoviesDispatcher uppRef = null;
    private int cWidth;
    private int cHeight;
    private long lastFlush;
    private long deltaTime = 50L;
    private long msecs = 0L;
    private boolean debug = false;
    static /* synthetic */ Class class$quicktime$std$movies$MovieController;

    public MovieController(Movie movie) throws QTException {
        this(movie, 0);
    }

    public MovieController(Movie movie, int n) throws QTException {
        super(MovieController.allocate(movie, n), null);
        if (QTSession.isCurrentOS(4)) {
            this.setDragEnabled(false);
        }
        this.currentPort = QTObject.ID(QDGraphics.scratch);
        MovieController.SetGWorld(this.currentPort, 0);
        this.initControllerSize();
        this.movieRef = movie;
        if (currentSessionID != this.sessionAllocated) {
            mcHashtable.clear();
            currentSessionID = this.sessionAllocated;
        }
        Vector<Movie> vector = new Vector<Movie>();
        vector.addElement(this.movieRef);
        mcHashtable.put(new Integer(this._ID()), vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MovieController(int n, Movie movie, QDGraphics qDGraphics, QDPoint qDPoint) throws QTException {
        super(1886151033, n);
        int n2 = 0;
        if (!QTSession.isCurrentOS(4) && qDGraphics == null) {
            throw new StdQTException(-50);
        }
        Vector<Movie> vector = QTNative.globalsLock;
        synchronized (vector) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
            }
            this.currentPort = QTObject.ID(qDGraphics);
            MovieController.SetGWorld(this.currentPort, 0);
            n2 = QTSession.isCurrentOS(4) ? MovieController.MCNewAttachedController(this._ID(), QTObject.ID(movie), 0, qDPoint.getPoint()) : MovieController.MCNewAttachedController(this._ID(), QTObject.ID(movie), QTObject.ID(qDGraphics), qDPoint.getPoint());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n2);
        this.initControllerSize();
        if (QTSession.isCurrentOS(4)) {
            this.setDragEnabled(false);
        }
        this.movieRef = movie;
        if (currentSessionID != this.sessionAllocated) {
            mcHashtable.clear();
            currentSessionID = this.sessionAllocated;
        }
        vector = new Vector<Movie>();
        vector.addElement(this.movieRef);
        mcHashtable.put(new Integer(this._ID()), vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(Movie movie, int n) throws StdQTException, QDException {
        QDRect qDRect = movie.getBounds();
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
            }
            n2 = MovieController.NewMovieController(QTObject.ID(movie), qDRect.getRect(), n | 1);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return n2;
    }

    MovieController(int n, Object object) {
        super(n, object);
        if (object == null) {
            throw new QTRuntimeException("Wrong use of Constructor");
        }
        try {
            if (QTSession.isCurrentOS(4)) {
                this.setDragEnabled(false);
            }
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException.getMessage());
        }
    }

    protected static final Object mm(int n, Object object) {
        return new Movie(n, object);
    }

    protected void _dispose() throws QTException {
        Object v = mcHashtable.remove(new Integer(this._ID()));
        if (v != null) {
            ((Vector)v).removeAllElements();
        }
    }

    private void initControllerSize() throws StdQTException {
        QDRect qDRect = this.getMovie().getBounds();
        QDRect qDRect2 = this.getBounds();
        this.cWidth = qDRect2.getWidth() - qDRect.getWidth();
        this.cHeight = qDRect2.getHeight() - qDRect.getHeight();
    }

    public final QDDimension getRequiredSize() {
        return new QDDimension(this.cWidth, this.cHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void idle() throws QTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isInitialized()) {
                long l;
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    MovieController.GetGWorld(savedPort, savedDevice);
                }
                MovieController.SetGWorld(this.currentPort, 0);
                QDGraphics qDGraphics = this.getPort();
                Region region = qDGraphics.getVisClipRgn();
                n = MovieController.MCIdle(this._ID());
                if (QTSession.getJavaVersion() == 65539 && QTSession.isCurrentOS(4) && (l = System.currentTimeMillis()) - this.lastFlush > this.deltaTime) {
                    MovieController.QDFlushPortBuffer(this.currentPort, QTObject.ID(region));
                    this.lastFlush = System.currentTimeMillis();
                }
                if (this.debug) {
                    System.out.println("idle:" + (System.currentTimeMillis() - this.msecs) + "msecs");
                    this.msecs = System.currentTimeMillis();
                }
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    MovieController.SetGWorld(savedPort[0], savedDevice[0]);
                }
            }
        }
        if (n < 0) {
            StdQTException.checkError(MovieController.GetMoviesError());
        }
    }

    public final void setActionFilter(ActionFilter actionFilter) throws StdQTException {
        this.setActionFilter(actionFilter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setActionFilter(ActionFilter actionFilter, boolean bl) throws StdQTException {
        if (actionFilter == null) {
            this.removeActionFilter();
            return;
        }
        if (this.uppRef != null) {
            this.removeActionFilter();
        }
        this.uppRef = new MoviesDispatcher(this, actionFilter, bl);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetActionFilterWithRefCon(this._ID(), this.uppRef.ID(), 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeActionFilter() throws StdQTException {
        if (this.uppRef != null) {
            this.uppRef.cleanupMethodClosure();
        }
        this.uppRef = null;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetActionFilterWithRefCon(this._ID(), 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMovie(Movie movie, QDGraphics qDGraphics, QDPoint qDPoint) throws StdQTException {
        StdQTException.checkError(MovieController.MCRemoveMovie(this._ID()));
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(4)) {
                StdQTException.checkError(MovieController.MCSetMovie(this._ID(), QTObject.ID(movie), 0, qDPoint.getPoint()));
                this.setPort(qDGraphics);
            } else {
                if (movie != null && qDGraphics == null) {
                    throw new StdQTException(-50);
                }
                StdQTException.checkError(MovieController.MCSetMovie(this._ID(), QTObject.ID(movie), QTObject.ID(qDGraphics), qDPoint.getPoint()));
            }
        }
        object = mcHashtable.get(new Integer(this._ID()));
        if (this.movieRef != null && object != null) {
            ((Vector)object).removeElement(this.movieRef);
        }
        this.movieRef = movie;
        if (this.movieRef != null && object != null) {
            ((Vector)object).addElement(this.movieRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Movie getMovie() throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCGetIndMovie(this._ID(), (short)0);
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return new Movie(n, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovie() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCRemoveMovie(this._ID()));
        }
        this.movieRef = null;
        object = mcHashtable.get(new Integer(this._ID()));
        if (this.movieRef != null && object != null) {
            ((Vector)object).removeElement(this.movieRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw() throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
            }
            MovieController.SetGWorld(this.currentPort, 0);
            n = QTSession.isCurrentOS(4) ? MovieController.MCDraw(this._ID(), 0) : MovieController.MCDraw(this._ID(), this.currentPort);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean click(QDPoint qDPoint, int n) throws StdQTException {
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
                MovieController.SetGWorld(MovieController.MCGetControllerPort(this._ID()), 0);
            }
            n2 = QTSession.isCurrentOS(4) ? MovieController.MCClick(this._ID(), 0, qDPoint.getPoint(), MovieController.TickCount(), QTUtils.convertEventModifier(n)) : MovieController.MCClick(this._ID(), this.currentPort, qDPoint.getPoint(), MovieController.TickCount(), QTUtils.convertEventModifier(n));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        if (n2 < 0) {
            StdQTException.checkError(n2);
        }
        return n2 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean key(int n, int n2) throws StdQTException {
        int n3 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
            }
            MovieController.SetGWorld(this.currentPort, 0);
            n3 = MovieController.MCKey(this._ID(), (byte)QTUtils.convertKeyValue(n), QTUtils.convertEventModifier(n2));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        if (n3 < 0) {
            StdQTException.checkError(n3);
        }
        return n3 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, int[] nArray) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCDoAction(this._ID(), s, nArray);
        }
        StdQTException.checkError(n);
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, int n) throws StdQTException {
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n2 = MovieController.MCDoAction(this._ID(), s, n);
        }
        StdQTException.checkError(n2);
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, short[] sArray) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCDoAction(this._ID(), s, sArray);
        }
        StdQTException.checkError(n);
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, short s2) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCDoAction(this._ID(), s, s2);
        }
        StdQTException.checkError(n);
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, byte[] byArray) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCDoAction(this._ID(), s, byArray);
        }
        StdQTException.checkError(n);
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doAction(short s, byte by) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCDoAction(this._ID(), s, by);
        }
        StdQTException.checkError(n);
        return n != 0;
    }

    public final void activate() throws StdQTException {
        this.doAction((short)3, 0);
    }

    public final void deactivate() throws StdQTException {
        this.doAction((short)4, 0);
    }

    public final void play(float f) throws StdQTException {
        this.doAction((short)8, QTUtils.X2Fix(f));
    }

    public final void goToTime(TimeRecord timeRecord) throws StdQTException {
        this.doAction((short)12, QTObject.ID(timeRecord));
    }

    public final void setVolume(float f) throws StdQTException {
        this.doAction((short)14, QTUtils.X2ShortFix(f));
    }

    public final float getVolume() throws StdQTException {
        short[] sArray = new short[1];
        this.doAction((short)15, sArray);
        return QTUtils.ShortFix2X(sArray[0]);
    }

    public final void step(int n) throws StdQTException {
        this.doAction((short)18, (short)n);
    }

    public final void setLooping(boolean bl) throws StdQTException {
        this.doAction((short)21, (byte)(bl ? 1 : 0));
    }

    public final boolean getLooping() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)22, byArray);
        return byArray[0] == 1;
    }

    public final void setLoopIsPalindrome(boolean bl) throws StdQTException {
        this.doAction((short)23, (byte)(bl ? 1 : 0));
    }

    public final boolean getLoopIsPalindrome() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)22, byArray);
        return byArray[0] == 1;
    }

    public final void setGrowBoxBounds(QDRect qDRect) throws StdQTException {
        this.doAction((short)25, qDRect.getRect());
    }

    public final void setSelectionBegin(TimeRecord timeRecord) throws StdQTException {
        this.doAction((short)29, QTObject.ID(timeRecord));
    }

    public final void setSelectionDuration(TimeRecord timeRecord) throws StdQTException {
        this.doAction((short)30, QTObject.ID(timeRecord));
    }

    public final void setKeysEnabled(boolean bl) throws StdQTException {
        this.doAction((short)32, (byte)(bl ? 1 : 0));
    }

    public final boolean getKeysEnabled() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)33, byArray);
        return byArray[0] == 1;
    }

    public final void setPlaySelection(boolean bl) throws StdQTException {
        this.doAction((short)34, (byte)(bl ? 1 : 0));
    }

    public final boolean getPlaySelection() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)35, byArray);
        return byArray[0] == 1;
    }

    public final void setUseBadge(boolean bl) throws StdQTException {
        this.doAction((short)36, (byte)(bl ? 1 : 0));
    }

    public final boolean getUseBadge() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)37, byArray);
        return byArray[0] == 1;
    }

    public final void setFlags(int n) throws StdQTException {
        this.doAction((short)38, n);
    }

    public final int getFlags() throws StdQTException {
        int[] nArray = new int[1];
        this.doAction((short)39, nArray);
        return nArray[0];
    }

    public final void setPlayEveryFrame(boolean bl) throws StdQTException {
        this.doAction((short)40, (byte)(bl ? 1 : 0));
    }

    public final boolean getPlayEveryFrame() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)41, byArray);
        return byArray[0] == 1;
    }

    public final float getPlayRate() throws StdQTException {
        int[] nArray = new int[1];
        this.doAction((short)42, nArray);
        return QTUtils.Fix2X(nArray[0]);
    }

    public final void suspend() throws StdQTException {
        this.doAction((short)46, 0);
    }

    public final void resume() throws StdQTException {
        this.doAction((short)47, 0);
    }

    public final void setControllerKeysEnabled(boolean bl) throws StdQTException {
        this.doAction((short)48, (byte)(bl ? 1 : 0));
    }

    public final QDRect getTimeSliderRect() throws StdQTException {
        QDRect qDRect = new QDRect();
        this.doAction((short)49, qDRect.getRect());
        return qDRect;
    }

    public final boolean getDragEnabled() throws StdQTException {
        byte[] byArray = new byte[1];
        this.doAction((short)51, byArray);
        return byArray[0] == 1;
    }

    public final void setDragEnabled(boolean bl) throws StdQTException {
        this.doAction((short)52, (byte)(bl ? 1 : 0));
    }

    public final TimeRecord getSelectionBegin() throws QTException {
        TimeRecord timeRecord = new TimeRecord();
        this.doAction((short)53, QTObject.ID(timeRecord));
        return timeRecord;
    }

    public final TimeRecord getSelectionDuration() throws QTException {
        TimeRecord timeRecord = new TimeRecord();
        this.doAction((short)54, QTObject.ID(timeRecord));
        return timeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prerollAndPlay(float f) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.GetGWorld(savedPort, savedDevice);
            }
            MovieController.SetGWorld(this.currentPort, 0);
            this.doAction((short)55, QTUtils.X2Fix(f));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                MovieController.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public final boolean getCursorSettingEnabled() throws StdQTException {
        int[] nArray = new int[1];
        this.doAction((short)56, nArray);
        return nArray[0] == 1;
    }

    public final void setCursorSettingEnabled(boolean bl) throws StdQTException {
        this.doAction((short)57, (byte)(bl ? 1 : 0));
    }

    public final void setColorTable(ColorTable colorTable) throws StdQTException {
        this.doAction((short)58, QTObject.ID(colorTable));
    }

    public final void controllerSizeChanged() throws StdQTException {
        this.doAction((short)26, 0);
    }

    public final void badgeClick(boolean bl) throws StdQTException {
        this.doAction((short)44, (byte)(bl ? 1 : 0));
    }

    public final void movieEdited() throws StdQTException {
        this.doAction((short)50, 0);
    }

    public final void forceTimeTableUpdate() throws StdQTException {
        this.doAction((short)61, 0);
    }

    public final void linkToURL(String string) throws QTException {
        Object object;
        if (string.startsWith("file:") && (object = System.getSecurityManager()) != null) {
            ((SecurityManager)object).checkRead(string);
        }
        object = new StringHandle(string, 1);
        this.doAction((short)59, QTObject.ID((QTObject)object));
    }

    public final boolean clickAndHoldPoint(QDPoint qDPoint) throws StdQTException {
        return this.doAction((short)67, qDPoint.getPoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAttached(boolean bl) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = MovieController.MCSetControllerAttached(this._ID(), (byte)(bl ? 1 : 0));
            StdQTException.checkError(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAttached() throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCIsControllerAttached(this._ID());
        }
        if (n < 0) {
            StdQTException.checkError(n);
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBounds(QDRect qDRect) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetControllerBoundsRect(this._ID(), qDRect.getRect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QDRect getBounds() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QDRect qDRect = new QDRect();
            StdQTException.checkError(MovieController.MCGetControllerBoundsRect(this._ID(), qDRect.getRect()));
            return qDRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPort(QDGraphics qDGraphics) throws StdQTException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetControllerPort(this._ID(), QTObject.ID(qDGraphics)));
        }
        this.currentPort = QTObject.ID(qDGraphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QDGraphics getPort() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            return QDGraphics.fromMovieController(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVisible(boolean bl) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetVisible(this._ID(), (byte)(bl ? 1 : 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getVisible() throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCGetVisible(this._ID());
        }
        if (n < 0) {
            StdQTException.checkError(n);
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Region getBoundsRgn() throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            return Region.fromMovieControllerBounds(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Region getWindowRgn(QDGraphics qDGraphics) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            return Region.fromMovieControllerWindow(this, qDGraphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void movieChanged() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = MovieController.MCGetIndMovie(this._ID(), (short)0);
            StdQTException.checkError(MovieController.MCMovieChanged(this._ID(), n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDuration(int n) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetDuration(this._ID(), n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCurrentTime() throws StdQTException {
        int[] nArray = new int[1];
        int n = 0;
        boolean bl = false;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCGetCurrentTime(this._ID(), nArray);
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTimeScale() throws StdQTException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            MovieController.MCGetCurrentTime(this._ID(), nArray);
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate(QDGraphics qDGraphics, boolean bl) throws StdQTException, QDException {
        if (!QTSession.isCurrentOS(4) && qDGraphics == null) {
            throw new StdQTException(-50);
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = MovieController.MCActivate(this._ID(), QTObject.ID(qDGraphics), (byte)(bl ? 1 : 0));
            StdQTException.checkError(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableEditing(boolean bl) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCEnableEditing(this._ID(), (byte)(bl ? 1 : 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEditingEnabled() throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCIsEditingEnabled(this._ID());
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Movie copy() throws QTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCCopy(this._ID());
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return new Movie(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Movie cut() throws QTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = MovieController.MCCut(this._ID());
        }
        StdQTException.checkError(MovieController.GetMoviesError());
        return new Movie(n, null);
    }

    public final void paste() throws StdQTException {
        this.paste(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paste(Movie movie) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCPaste(this._ID(), QTObject.ID(movie)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCClear(this._ID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void undo() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCUndo(this._ID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void position(QDRect qDRect, QDRect qDRect2, int n) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCPositionController(this._ID(), qDRect.getRect(), qDRect2.getRect(), n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void position(QDRect qDRect, int n) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCPositionController(this._ID(), qDRect.getRect(), null, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getControllerInfo() throws StdQTException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCGetControllerInfo(this._ID(), nArray));
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClip(Region region) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetClip(this._ID(), QTObject.ID(region), 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Region getClip() throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            return Region.fromMovieControllerClip(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMovieClip(Region region) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCSetClip(this._ID(), 0, QTObject.ID(region)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Region drawBadge(Region region, boolean bl) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            return Region.fromMovieControllerBadge(this, region, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean inController(QDPoint qDPoint) throws StdQTException {
        byte[] byArray = new byte[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(MovieController.MCPtInController(this._ID(), qDPoint.getPoint(), byArray));
        }
        return byArray[0] == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate(QDGraphics qDGraphics, Region region) throws StdQTException, QDException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = MovieController.MCInvalidate(this._ID(), QTObject.ID(qDGraphics), QTObject.ID(region));
            StdQTException.checkError(n);
        }
    }

    private static native void QDFlushPortBuffer(int var0, int var1);

    private static native int MCNewAttachedController(int var0, int var1, int var2, int var3);

    private static native int NewMovieController(int var0, byte[] var1, int var2);

    private static native short GetMoviesError();

    private static native int MCIdle(int var0);

    private static native int MCSetActionFilterWithRefCon(int var0, int var1, int var2);

    private static native int MCRemoveMovie(int var0);

    private static native int MCSetMovie(int var0, int var1, int var2, int var3);

    private static native int MCGetIndMovie(int var0, short var1);

    private static native int MCGetControllerPort(int var0);

    private static native int MCClick(int var0, int var1, int var2, int var3, int var4);

    private static native int TickCount();

    private static native int MCKey(int var0, byte var1, int var2);

    private static native int MCDoAction(int var0, short var1, int[] var2);

    private static native int MCDoAction(int var0, short var1, int var2);

    private static native int MCDoAction(int var0, short var1, short[] var2);

    private static native int MCDoAction(int var0, short var1, short var2);

    private static native int MCDoAction(int var0, short var1, byte var2);

    private static native int MCDoAction(int var0, short var1, byte[] var2);

    private static native int MCSetControllerAttached(int var0, byte var1);

    private static native int MCIsControllerAttached(int var0);

    private static native int MCSetControllerBoundsRect(int var0, byte[] var1);

    private static native int MCGetControllerBoundsRect(int var0, byte[] var1);

    private static native int MCSetControllerPort(int var0, int var1);

    private static native int MCSetVisible(int var0, byte var1);

    private static native int MCGetVisible(int var0);

    private static native int MCMovieChanged(int var0, int var1);

    private static native int MCSetDuration(int var0, int var1);

    private static native int MCGetCurrentTime(int var0, int[] var1);

    private static native int MCActivate(int var0, int var1, byte var2);

    private static native int MCEnableEditing(int var0, byte var1);

    private static native int MCIsEditingEnabled(int var0);

    private static native int MCCopy(int var0);

    private static native int MCCut(int var0);

    private static native int MCPaste(int var0, int var1);

    private static native int MCClear(int var0);

    private static native int MCUndo(int var0);

    private static native int MCPositionController(int var0, byte[] var1, byte[] var2, int var3);

    private static native int MCGetControllerInfo(int var0, int[] var1);

    private static native int MCSetClip(int var0, int var1, int var2);

    private static native int MCPtInController(int var0, int var1, byte[] var2);

    private static native int MCInvalidate(int var0, int var1, int var2);

    private static native int MCDraw(int var0, int var1);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$movies$MovieController == null ? (class$quicktime$std$movies$MovieController = MovieController.class$("quicktime.std.movies.MovieController")) : class$quicktime$std$movies$MovieController);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        isMacOS = QTSession.isCurrentOS(1);
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
        mcHashtable = new Hashtable();
    }
}

