/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.QTException;
import quicktime.std.music.NoteRequestInfo;
import quicktime.std.music.ToneDescription;

public final class NoteRequest
extends NoteRequestInfo
implements Cloneable {
    public static final int kNativeSize = 84;

    public NoteRequest() {
        super(84, null);
    }

    public NoteRequest(ToneDescription toneDescription) {
        this();
        this.setToneDescription(toneDescription);
    }

    public NoteRequest(ToneDescription toneDescription, int n) {
        this();
        this.setToneDescription(toneDescription);
        this.setPolyphony(n);
    }

    public NoteRequest(int n, int n2) throws QTException {
        this();
        this.setToneDescription(new ToneDescription(n));
        this.setPolyphony(n2);
    }

    private NoteRequest(byte[] byArray) {
        super(byArray);
    }

    public void setToneDescription(ToneDescription toneDescription) {
        byte[] byArray = toneDescription.getBytes();
        this.setBytesAt(8, byArray.length, byArray, 0);
    }

    public ToneDescription getToneDescription() {
        ToneDescription toneDescription = new ToneDescription();
        this.getBytesAt(8, toneDescription.getBytes().length, toneDescription.getBytes(), 0);
        return toneDescription;
    }

    public String toString() {
        return this.getClass().getName() + "[flags=" + this.getFlags() + ",poly=" + this.getPolyphony() + ",typPoly=" + this.getTypicalPolyphony() + "," + this.getToneDescription() + "]";
    }

    public Object clone() {
        return new NoteRequest(this.getBytes());
    }
}

