/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.qtcomponents;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.util.QTByteObject;

public final class TimeCodeTime
extends QTByteObject
implements Cloneable {
    private static final int kNativeSize = 4;
    static final long serialVersionUID = -6484583375141374076L;

    public TimeCodeTime(int n, int n2, int n3, int n4) {
        this();
        this.setHours(n);
        this.setMinutes(n2);
        this.setSeconds(n3);
        this.setFrames(n4);
    }

    public TimeCodeTime() {
        super(4);
    }

    public TimeCodeTime(int n) {
        this();
        this.setHours((n & 0xFF000000) >>> 24);
        this.setMinutes((n & 0xFF0000) >>> 16);
        this.setSeconds((n & 0xFF00) >>> 8);
        this.setFrames(n & 0xFF);
    }

    private TimeCodeTime(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[4];
        objectInputStream.read(this.getBytes());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getBytes());
    }

    public int toCounter() {
        int n = this.getHours();
        int n2 = this.getMinutes();
        int n3 = this.getSeconds();
        int n4 = this.getFrames();
        return (0xFF & n) << 24 | (0xFF & n2) << 16 | (0xFF & n3) << 8 | 0xFF & n4;
    }

    public int getHours() {
        return this.getByteAt(0);
    }

    public void setHours(int n) {
        this.setByteAt(0, (byte)n);
    }

    public int getMinutes() {
        return this.getByteAt(1);
    }

    public void setMinutes(int n) {
        this.setByteAt(1, (byte)n);
    }

    public int getSeconds() {
        return this.getByteAt(2);
    }

    public void setSeconds(int n) {
        this.setByteAt(2, (byte)n);
    }

    public int getFrames() {
        return this.getByteAt(3);
    }

    public void setFrames(int n) {
        this.setByteAt(3, (byte)n);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() + ":" + this.getFrames() + "]";
    }

    public Object clone() {
        return new TimeCodeTime(this.getBytes());
    }
}

