/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.qtcomponents;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.QDColor;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.movies.media.DataRef;
import quicktime.std.qtcomponents.XMLCharDataProc;
import quicktime.std.qtcomponents.XMLCommentProc;
import quicktime.std.qtcomponents.XMLDispatcher;
import quicktime.std.qtcomponents.XMLDoc;
import quicktime.std.qtcomponents.XMLEndDocProc;
import quicktime.std.qtcomponents.XMLEndElementProc;
import quicktime.std.qtcomponents.XMLPreprocessorProc;
import quicktime.std.qtcomponents.XMLStartDocProc;
import quicktime.std.qtcomponents.XMLStartElementProc;
import quicktime.util.QTUtils;

public final class XMLParser
extends Component
implements QuickTimeLib {
    private static Object linkage;
    private XMLDispatcher startDocUPP;
    private XMLDispatcher endDocUPP;
    private XMLDispatcher startElementUPP;
    private XMLDispatcher endElementUPP;
    private XMLDispatcher commentUPP;
    private XMLDispatcher charDataUPP;
    private XMLDispatcher preprocessorUPP;
    static /* synthetic */ Class class$quicktime$std$qtcomponents$XMLParser;

    public XMLParser() throws QTException {
        super(1885434483, 2020437024);
    }

    public XMLDoc parse(DataRef dataRef, boolean bl, boolean bl2) throws StdQTException, QTException {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        int[] nArray = new int[]{0};
        short s = XMLParser.XMLParseDataRef(this._ID(), QTObject.ID(dataRef), dataRef.getType(), n, nArray);
        StdQTException.checkError(s);
        return new XMLDoc(nArray[0], this);
    }

    public XMLDoc parse(QTFile qTFile, boolean bl, boolean bl2) throws StdQTException, QTException {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        int[] nArray = new int[]{0};
        short s = XMLParser.XMLParseFile(this._ID(), qTFile.getFSSpec(true, 256), n, nArray);
        StdQTException.checkError(s);
        return new XMLDoc(nArray[0], this);
    }

    public void eventParse(DataRef dataRef, boolean bl, boolean bl2) throws StdQTException, QTException {
        int n = 4;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        short s = XMLParser.XMLParseDataRef(this._ID(), QTObject.ID(dataRef), dataRef.getType(), n, null);
        StdQTException.checkError(s);
    }

    public void eventParse(QTFile qTFile, boolean bl, boolean bl2) throws StdQTException, QTException {
        int n = 4;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        short s = XMLParser.XMLParseFile(this._ID(), qTFile.getFSSpec(true, 256), n, null);
        StdQTException.checkError(s);
    }

    public int addElement(String string, int n, int n2, int n3) throws StdQTException {
        int[] nArray = new int[]{n2};
        short s = XMLParser.XMLParseAddElement(this._ID(), QTUtils.String2CString(string), n, nArray, n3);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public int addAttribute(int n, int n2, String string, int n3) throws StdQTException {
        if (n == 0) {
            throw new StdQTException(-50);
        }
        int[] nArray = new int[]{n3};
        short s = XMLParser.XMLParseAddAttribute(this._ID(), n, n2, QTUtils.String2CString(string), nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public void addAttributeValueKind(int n, int n2, int n3, byte[] byArray) throws StdQTException {
        if (n == 0) {
            throw new StdQTException(-50);
        }
        if (n2 == 0) {
            throw new StdQTException(-50);
        }
        short s = XMLParser.XMLParseAddAttributeValueKind(this._ID(), n, n2, n3, byArray);
        StdQTException.checkError(s);
    }

    public void addAttributeValueKind(int n, int n2, String string) throws StdQTException {
        this.addAttributeValueKind(n, n2, 0, QTUtils.String2CString(string));
    }

    public void addAttributeValueKind(int n, int n2, int n3) throws StdQTException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n4 = 0;
        while (n4 < 4) {
            byArray[n4] = (byte)(n3 & 0xFF);
            ++n4;
            n3 >>= 8;
        }
        this.addAttributeValueKind(n, n2, 1, byArray);
    }

    public void addAttributeValueKind(int n, int n2, float f) throws StdQTException {
        int n3 = (int)f;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n4 = 0;
        while (n4 < 4) {
            byArray[n4] = (byte)(n3 & 0xFF);
            ++n4;
            n3 >>= 8;
        }
        this.addAttributeValueKind(n, n2, 2, byArray);
    }

    public void addAttributeValueKind(int n, int n2, boolean bl) throws StdQTException {
        byte[] byArray = new byte[]{(byte)(bl ? 1 : 0)};
        this.addAttributeValueKind(n, n2, 4, byArray);
    }

    public void addAttributeValueKind(int n, int n2, byte by) throws StdQTException {
        byte[] byArray = new byte[]{(byte)(by != 0 ? 1 : 0)};
        this.addAttributeValueKind(n, n2, 8, byArray);
    }

    public void addAttributeValueKind(int n, int n2, QDColor qDColor) throws StdQTException {
        this.addAttributeValueKind(n, n2, 16, qDColor.getRGBColor());
    }

    public void addAttributeValueKind(int n, int n2, String[] stringArray, boolean bl) throws StdQTException {
        int n3;
        int n4 = stringArray.length;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            n5 += stringArray[i].length();
            ++n5;
        }
        byte[] byArray = new byte[++n5];
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n5 = stringArray[n3].length();
            for (int i = 0; i < n5; ++i) {
                byArray[n6++] = (byte)stringArray[n3].charAt(i);
            }
            byArray[n6++] = 0;
        }
        byArray[n6] = 0;
        n3 = bl ? 64 : 32;
        this.addAttributeValueKind(n, n2, n3, byArray);
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, int n4, byte[] byArray) throws StdQTException {
        if (n == 0) {
            throw new StdQTException(-50);
        }
        int[] nArray = new int[]{n3};
        short s = XMLParser.XMLParseAddAttributeAndValue(this._ID(), n, n2, QTUtils.String2CString(string), nArray, n4, byArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, String string2) throws StdQTException {
        return this.addAttributeAndValue(n, n2, string, n3, 0, QTUtils.String2CString(string2));
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, int n4) throws StdQTException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n5 = 0;
        while (n5 < 4) {
            byArray[n5] = (byte)(n4 & 0xFF);
            ++n5;
            n4 >>= 8;
        }
        return this.addAttributeAndValue(n, n2, string, n3, 1, byArray);
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, float f) throws StdQTException {
        int n4 = (int)f;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n5 = 0;
        while (n5 < 4) {
            byArray[n5] = (byte)(n4 & 0xFF);
            ++n5;
            n4 >>= 8;
        }
        return this.addAttributeAndValue(n, n2, string, n3, 2, byArray);
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, boolean bl) throws StdQTException {
        byte[] byArray = new byte[]{(byte)(bl ? 1 : 0)};
        return this.addAttributeAndValue(n, n2, string, n3, 4, byArray);
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, byte by) throws StdQTException {
        byte[] byArray = new byte[]{(byte)(by != 0 ? 1 : 0)};
        return this.addAttributeAndValue(n, n2, string, n3, 8, byArray);
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, QDColor qDColor) throws StdQTException {
        return this.addAttributeAndValue(n, n2, string, n3, 16, qDColor.getRGBColor());
    }

    public int addAttributeAndValue(int n, int n2, String string, int n3, String[] stringArray, boolean bl) throws StdQTException {
        int n4;
        int n5 = stringArray.length;
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n6 += stringArray[i].length();
            ++n6;
        }
        byte[] byArray = new byte[++n6];
        int n7 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            n6 = stringArray[n4].length();
            for (int i = 0; i < n6; ++i) {
                byArray[n7++] = (byte)stringArray[n4].charAt(i);
            }
            byArray[n7++] = 0;
        }
        byArray[n7] = 0;
        n4 = bl ? 64 : 32;
        return this.addAttributeAndValue(n, n2, string, n3, n4, byArray);
    }

    public void addNameSpace(int n, String string) throws StdQTException {
        if (n == 0) {
            throw new StdQTException(-50);
        }
        int[] nArray = new int[]{n};
        short s = XMLParser.XMLParseAddNameSpace(this._ID(), QTUtils.String2CString(string), nArray);
        StdQTException.checkError(s);
    }

    public int addNameSpace(String string) throws StdQTException {
        int[] nArray = new int[]{0};
        short s = XMLParser.XMLParseAddNameSpace(this._ID(), QTUtils.String2CString(string), nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public void setOffsetAndLimit(int n, int n2) throws StdQTException {
        short s = XMLParser.XMLParseSetOffsetAndLimit(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void setStartDocumentHandler(XMLStartDocProc xMLStartDocProc) throws StdQTException {
        if (xMLStartDocProc == null) {
            this.removeStartDocumentHandler();
            return;
        }
        if (this.startDocUPP != null) {
            this.removeStartDocumentHandler();
        }
        this.startDocUPP = new XMLDispatcher(xMLStartDocProc);
        short s = XMLParser.XMLParseSetStartDocumentHandler(this._ID(), this.startDocUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeStartDocumentHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetStartDocumentHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.startDocUPP != null) {
            this.startDocUPP.cleanup();
            this.startDocUPP = null;
        }
    }

    public void setEndDocumentHandler(XMLEndDocProc xMLEndDocProc) throws StdQTException {
        if (xMLEndDocProc == null) {
            this.removeEndDocumentHandler();
            return;
        }
        if (this.endDocUPP != null) {
            this.removeEndDocumentHandler();
        }
        this.endDocUPP = new XMLDispatcher(xMLEndDocProc);
        short s = XMLParser.XMLParseSetEndDocumentHandler(this._ID(), this.endDocUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeEndDocumentHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetEndDocumentHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.endDocUPP != null) {
            this.endDocUPP.cleanup();
            this.endDocUPP = null;
        }
    }

    public void setStartElementHandler(XMLStartElementProc xMLStartElementProc) throws StdQTException {
        if (xMLStartElementProc == null) {
            this.removeStartElementHandler();
            return;
        }
        if (this.startElementUPP != null) {
            this.removeStartElementHandler();
        }
        this.startElementUPP = new XMLDispatcher(xMLStartElementProc);
        short s = XMLParser.XMLParseSetStartElementHandler(this._ID(), this.startElementUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeStartElementHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetStartElementHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.startElementUPP != null) {
            this.startElementUPP.cleanup();
            this.startElementUPP = null;
        }
    }

    public void setEndElementHandler(XMLEndElementProc xMLEndElementProc) throws StdQTException {
        if (xMLEndElementProc == null) {
            this.removeEndElementHandler();
            return;
        }
        if (this.endElementUPP != null) {
            this.removeEndElementHandler();
        }
        this.endElementUPP = new XMLDispatcher(xMLEndElementProc);
        short s = XMLParser.XMLParseSetEndElementHandler(this._ID(), this.endElementUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeEndElementHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetEndElementHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.endElementUPP != null) {
            this.endElementUPP.cleanup();
            this.endElementUPP = null;
        }
    }

    public void setCommentHandler(XMLCommentProc xMLCommentProc) throws StdQTException {
        if (xMLCommentProc == null) {
            this.removeCommentHandler();
            return;
        }
        if (this.commentUPP != null) {
            this.removeCommentHandler();
        }
        this.commentUPP = new XMLDispatcher(xMLCommentProc);
        short s = XMLParser.XMLParseSetCommentHandler(this._ID(), this.commentUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeCommentHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetCommentHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.commentUPP != null) {
            this.commentUPP.cleanup();
            this.commentUPP = null;
        }
    }

    public void setCharDataHandler(XMLCharDataProc xMLCharDataProc) throws StdQTException {
        if (xMLCharDataProc == null) {
            this.removeCharDataHandler();
            return;
        }
        if (this.charDataUPP != null) {
            this.removeCharDataHandler();
        }
        this.charDataUPP = new XMLDispatcher(xMLCharDataProc);
        short s = XMLParser.XMLParseSetCharDataHandler(this._ID(), this.charDataUPP.ID());
        StdQTException.checkError(s);
    }

    public void removeCharDataHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetCharDataHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.charDataUPP != null) {
            this.charDataUPP.cleanup();
            this.charDataUPP = null;
        }
    }

    public void setPreprocessorHandler(XMLPreprocessorProc xMLPreprocessorProc) throws StdQTException {
        if (xMLPreprocessorProc == null) {
            this.removePreprocessorHandler();
            return;
        }
        if (this.preprocessorUPP != null) {
            this.removePreprocessorHandler();
        }
        this.preprocessorUPP = new XMLDispatcher(xMLPreprocessorProc);
        short s = XMLParser.XMLParseSetPreprocessInstructionHandler(this._ID(), this.preprocessorUPP.ID());
        StdQTException.checkError(s);
    }

    public void removePreprocessorHandler() throws StdQTException {
        short s = XMLParser.XMLParseSetPreprocessInstructionHandler(this._ID(), 0);
        StdQTException.checkError(s);
        if (this.preprocessorUPP != null) {
            this.preprocessorUPP.cleanup();
            this.preprocessorUPP = null;
        }
    }

    public int getParseErrorLine() throws StdQTException {
        int[] nArray = new int[]{0};
        short s = XMLParser.XMLParseGetDetailedParseError(this._ID(), nArray, null);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public String getParseErrorDescription() throws StdQTException {
        byte[] byArray = new byte[256];
        short s = XMLParser.XMLParseGetDetailedParseError(this._ID(), null, byArray);
        StdQTException.checkError(s);
        return QTUtils.PString2String(byArray, 0);
    }

    private static native short XMLParseDataRef(int var0, int var1, int var2, int var3, int[] var4);

    private static native short XMLParseFile(int var0, byte[] var1, int var2, int[] var3);

    private static native short XMLParseGetDetailedParseError(int var0, int[] var1, byte[] var2);

    private static native short XMLParseAddElement(int var0, byte[] var1, int var2, int[] var3, int var4);

    private static native short XMLParseAddAttribute(int var0, int var1, int var2, byte[] var3, int[] var4);

    private static native short XMLParseAddAttributeAndValue(int var0, int var1, int var2, byte[] var3, int[] var4, int var5, byte[] var6);

    private static native short XMLParseAddAttributeValueKind(int var0, int var1, int var2, int var3, byte[] var4);

    private static native short XMLParseAddNameSpace(int var0, byte[] var1, int[] var2);

    private static native short XMLParseSetOffsetAndLimit(int var0, int var1, int var2);

    private static native short XMLParseSetStartDocumentHandler(int var0, int var1);

    private static native short XMLParseSetEndDocumentHandler(int var0, int var1);

    private static native short XMLParseSetStartElementHandler(int var0, int var1);

    private static native short XMLParseSetEndElementHandler(int var0, int var1);

    private static native short XMLParseSetCharDataHandler(int var0, int var1);

    private static native short XMLParseSetPreprocessInstructionHandler(int var0, int var1);

    private static native short XMLParseSetCommentHandler(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$qtcomponents$XMLParser == null ? (class$quicktime$std$qtcomponents$XMLParser = XMLParser.class$("quicktime.std.qtcomponents.XMLParser")) : class$quicktime$std$qtcomponents$XMLParser);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

