/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.util.Random;

public class WobbleStroke
implements Stroke {
    private float detail = 2.0f;
    private float amplitude = 2.0f;
    private static final float FLATNESS = 1.0f;
    private Random rand;
    private float basicStrokeWidth;
    private long seed;

    public WobbleStroke(float f, float f2, float f3) {
        this.detail = f;
        this.amplitude = f2;
        this.basicStrokeWidth = f3;
        this.rand = new Random();
        this.seed = System.nanoTime();
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        this.rand.setSeed(this.seed);
        GeneralPath generalPath = new GeneralPath();
        shape = new BasicStroke(this.basicStrokeWidth).createStrokedShape(shape);
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        float f7 = 0.0f;
        while (!flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = this.randomize(fArray[0]);
                    f2 = f4 = this.randomize(fArray[1]);
                    generalPath.moveTo(f, f2);
                    f7 = 0.0f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    f5 = this.randomize(fArray[0]);
                    f6 = this.randomize(fArray[1]);
                    float f8 = f5 - f3;
                    float f9 = f6 - f4;
                    float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                    if (f10 >= f7) {
                        float f11 = 1.0f / f10;
                        while (f10 >= f7) {
                            float f12 = f3 + f7 * f8 * f11;
                            float f13 = f4 + f7 * f9 * f11;
                            generalPath.lineTo(this.randomize(f12), this.randomize(f13));
                            f7 += this.detail;
                        }
                    }
                    f7 -= f10;
                    f3 = f5;
                    f4 = f6;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }

    private float randomize(float f) {
        float f2 = 2.0f * (this.amplitude * (this.rand.nextFloat() - 0.5f));
        return f + f2;
    }
}

