/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import com.jhlabs.math.FFT;
import java.awt.image.BufferedImage;

public class LensBlurFilter
extends AbstractBufferedImageOp {
    private float radius = 10.0f;
    private float bloom = 2.0f;
    private float bloomThreshold = 192.0f;
    private float angle = 0.0f;
    private int sides = 5;

    public void setRadius(float f) {
        this.radius = f;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setSides(int n) {
        this.sides = n;
    }

    public int getSides() {
        return this.sides;
    }

    public void setBloom(float f) {
        this.bloom = f;
    }

    public float getBloom() {
        return this.bloom;
    }

    public void setBloomThreshold(float f) {
        this.bloomThreshold = f;
    }

    public float getBloomThreshold() {
        return this.bloomThreshold;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        int n3;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = 1;
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = (int)Math.ceil(this.radius);
        int n11 = n3 = 128;
        n3 = n10 < 32 ? Math.min(128, n4 + 2 * n10) : Math.min(256, n4 + 2 * n10);
        int n12 = n11 = n10 < 32 ? Math.min(128, n5 + 2 * n10) : Math.min(256, n5 + 2 * n10);
        if (bufferedImage2 == null) {
            bufferedImage2 = new BufferedImage(n4, n5, 2);
        }
        while (n6 < n11) {
            n6 *= 2;
            ++n8;
        }
        while (n7 < n3) {
            n7 *= 2;
            ++n9;
        }
        int n13 = n7;
        int n14 = n6;
        n3 = n13;
        n11 = n14;
        FFT fFT = new FFT(Math.max(n8, n9));
        int[] nArray = new int[n13 * n14];
        float[][] fArray = new float[2][n13 * n14];
        float[][] fArray2 = new float[2][n13 * n14];
        float[][] fArray3 = new float[2][n13 * n14];
        double d = Math.PI / (double)this.sides;
        double d2 = 1.0 / Math.cos(d);
        double d3 = this.radius * this.radius;
        double d4 = Math.toRadians(this.angle);
        float f = 0.0f;
        int n15 = 0;
        for (n2 = 0; n2 < n14; ++n2) {
            for (n = 0; n < n13; ++n) {
                double d5;
                double d6 = (float)n - (float)n13 / 2.0f;
                double d7 = (float)n2 - (float)n14 / 2.0f;
                double d8 = d6 * d6 + d7 * d7;
                double d9 = d5 = d8 < d3 ? 1.0 : 0.0;
                if (d5 != 0.0) {
                    d8 = Math.sqrt(d8);
                    if (this.sides != 0) {
                        double d10 = Math.atan2(d7, d6) + d4;
                        d10 = ImageMath.mod(d10, d * 2.0) - d;
                        d5 = Math.cos(d10) * d2;
                    } else {
                        d5 = 1.0;
                    }
                    d5 = d5 * d8 < (double)this.radius ? 1.0 : 0.0;
                }
                f += (float)d5;
                fArray[0][n15] = (float)d5;
                fArray[1][n15] = 0.0f;
                ++n15;
            }
        }
        n15 = 0;
        for (n2 = 0; n2 < n14; ++n2) {
            for (n = 0; n < n13; ++n) {
                float[] fArray4 = fArray[0];
                int n16 = n15++;
                fArray4[n16] = fArray4[n16] / f;
            }
        }
        fFT.transform2D(fArray[0], fArray[1], n13, n14, true);
        for (n2 = -n10; n2 < n5; n2 += n11 - 2 * n10) {
            for (n = -n10; n < n4; n += n3 - 2 * n10) {
                int n17;
                int n18;
                int n19;
                int n20 = n;
                int n21 = n2;
                int n22 = n3;
                int n23 = n11;
                int n24 = 0;
                int n25 = 0;
                if (n20 < 0) {
                    n22 += n20;
                    n24 -= n20;
                    n20 = 0;
                }
                if (n21 < 0) {
                    n23 += n21;
                    n25 -= n21;
                    n21 = 0;
                }
                if (n20 + n22 > n4) {
                    n22 = n4 - n20;
                }
                if (n21 + n23 > n5) {
                    n23 = n5 - n21;
                }
                bufferedImage.getRGB(n20, n21, n22, n23, nArray, n25 * n13 + n24, n13);
                n15 = 0;
                for (n19 = 0; n19 < n14; ++n19) {
                    n18 = n19 + n2;
                    int n26 = n18 < 0 ? n25 : (n18 > n5 ? n25 + n23 - 1 : n19);
                    n26 *= n13;
                    for (n17 = 0; n17 < n13; ++n17) {
                        int n27 = n17 + n;
                        int n28 = n27 < 0 ? n24 : (n27 > n4 ? n24 + n22 - 1 : n17);
                        fArray3[0][n15] = nArray[n28 += n26] >> 24 & 0xFF;
                        float f2 = nArray[n28] >> 16 & 0xFF;
                        float f3 = nArray[n28] >> 8 & 0xFF;
                        float f4 = nArray[n28] & 0xFF;
                        if (f2 > this.bloomThreshold) {
                            f2 *= this.bloom;
                        }
                        if (f3 > this.bloomThreshold) {
                            f3 *= this.bloom;
                        }
                        if (f4 > this.bloomThreshold) {
                            f4 *= this.bloom;
                        }
                        fArray3[1][n15] = f2;
                        fArray2[0][n15] = f3;
                        fArray2[1][n15] = f4;
                        ++n15;
                        ++n28;
                    }
                }
                fFT.transform2D(fArray3[0], fArray3[1], n7, n6, true);
                fFT.transform2D(fArray2[0], fArray2[1], n7, n6, true);
                n15 = 0;
                for (n19 = 0; n19 < n14; ++n19) {
                    for (n18 = 0; n18 < n13; ++n18) {
                        float f5 = fArray3[0][n15];
                        float f6 = fArray3[1][n15];
                        float f7 = fArray[0][n15];
                        float f8 = fArray[1][n15];
                        fArray3[0][n15] = f5 * f7 - f6 * f8;
                        fArray3[1][n15] = f5 * f8 + f6 * f7;
                        f5 = fArray2[0][n15];
                        f6 = fArray2[1][n15];
                        fArray2[0][n15] = f5 * f7 - f6 * f8;
                        fArray2[1][n15] = f5 * f8 + f6 * f7;
                        ++n15;
                    }
                }
                fFT.transform2D(fArray3[0], fArray3[1], n7, n6, false);
                fFT.transform2D(fArray2[0], fArray2[1], n7, n6, false);
                n19 = n13 >> 1;
                n18 = n14 >> 1;
                int n29 = 0;
                for (n17 = 0; n17 < n13; ++n17) {
                    int n30 = n17 ^ n19;
                    int n31 = n30 * n7;
                    for (int i = 0; i < n13; ++i) {
                        int n32 = n31 + (i ^ n18);
                        int n33 = (int)fArray3[0][n32];
                        int n34 = (int)fArray3[1][n32];
                        int n35 = (int)fArray2[0][n32];
                        int n36 = (int)fArray2[1][n32];
                        if (n34 > 255) {
                            n34 = 255;
                        }
                        if (n35 > 255) {
                            n35 = 255;
                        }
                        if (n36 > 255) {
                            n36 = 255;
                        }
                        int n37 = n33 << 24 | n34 << 16 | n35 << 8 | n36;
                        nArray[n29++] = n37;
                    }
                }
                n20 = n + n10;
                n21 = n2 + n10;
                n22 = n3 - 2 * n10;
                n23 = n11 - 2 * n10;
                if (n20 + n22 > n4) {
                    n22 = n4 - n20;
                }
                if (n21 + n23 > n5) {
                    n23 = n5 - n21;
                }
                bufferedImage2.setRGB(n20, n21, n22, n23, nArray, n10 * n13 + n10, n13);
            }
        }
        return bufferedImage2;
    }

    public String toString() {
        return "Blur/Lens Blur...";
    }
}

