/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.tips.TipLoader;
import org.jdesktop.swingx.tips.TipOfTheDayModel;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.utils.AppPreferences;

public class TipsOfTheDay {
    private static Preferences tipPrefs = AppPreferences.getMainUserNode();
    private static int nextTip = -1;
    private static final String NEXT_TIP_NR_KEY = "next_tip_nr";

    private TipsOfTheDay() {
    }

    public static void showTips(JFrame jFrame, boolean bl) {
        try {
            if (nextTip == -1) {
                nextTip = tipPrefs.getInt(NEXT_TIP_NR_KEY, 0);
            }
            TipOfTheDayModel tipOfTheDayModel = TipsOfTheDay.loadModel();
            int n = tipOfTheDayModel.getTipCount();
            if (nextTip < 0) {
                nextTip = 0;
            }
            if (nextTip > n - 1) {
                nextTip = n - 1;
            }
            JXTipOfTheDay jXTipOfTheDay = new JXTipOfTheDay(tipOfTheDayModel);
            jXTipOfTheDay.setCurrentTip(nextTip);
            jXTipOfTheDay.showDialog((Component)jFrame, tipPrefs, bl);
            int n2 = jXTipOfTheDay.getCurrentTip();
            nextTip = n2 < n - 1 ? n2 + 1 : 0;
        }
        catch (IOException iOException) {
            ExceptionHandler.showExceptionDialog(iOException);
        }
    }

    private static TipOfTheDayModel loadModel() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = PixelitorWindow.class.getResourceAsStream("tips.properties");
        properties.load(inputStream);
        TipOfTheDayModel tipOfTheDayModel = TipLoader.load(properties);
        inputStream.close();
        return tipOfTheDayModel;
    }

    public static void saveNextTipNr() {
        tipPrefs.putInt(NEXT_TIP_NR_KEY, nextTip);
    }
}

