/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.automate;

import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pixelitor.Composition;
import pixelitor.PixelitorWindow;
import pixelitor.automate.Automate;
import pixelitor.automate.OpenSaveDirsPanel;
import pixelitor.filters.comp.CompositionUtils;
import pixelitor.utils.CompositionAction;
import pixelitor.utils.IntTextField;
import pixelitor.utils.ValidatedDialog;
import pixelitor.utils.ValidatedForm;

public class BatchResize {
    private BatchResize() {
    }

    public static void runBatchResize() {
        BatchResizePanel batchResizePanel = new BatchResizePanel();
        ValidatedDialog validatedDialog = new ValidatedDialog(batchResizePanel, (Frame)PixelitorWindow.getInstance(), "Batch Resize");
        validatedDialog.setVisible(true);
        if (!validatedDialog.isOkPressed()) {
            return;
        }
        batchResizePanel.saveValues();
        final int n = batchResizePanel.getWidthValue();
        final int n2 = batchResizePanel.getHeightValue();
        CompositionAction compositionAction = new CompositionAction(){

            @Override
            public void process(Composition composition) {
                CompositionUtils.resize(composition, n, n2, true);
            }
        };
        Automate.processEachFile(compositionAction, true, "Batch Resize...");
    }

    static class BatchResizePanel
    extends ValidatedForm {
        private String errorMessage;
        private OpenSaveDirsPanel openSaveDirsPanel = new OpenSaveDirsPanel(false);
        private IntTextField withTextField;
        private IntTextField heightTextField;

        BatchResizePanel() {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Max Width:"));
            this.withTextField = new IntTextField(5);
            this.withTextField.setText("300");
            jPanel.add(this.withTextField);
            jPanel.add(new JLabel("Max Height:"));
            this.heightTextField = new IntTextField(5);
            this.heightTextField.setText("300");
            jPanel.add(this.heightTextField);
            this.setLayout(new BoxLayout(this, 1));
            this.add(jPanel);
            this.add(this.openSaveDirsPanel);
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public boolean validateData() {
            if (!this.openSaveDirsPanel.validateData()) {
                this.errorMessage = this.openSaveDirsPanel.getErrorMessage();
                return false;
            }
            if (this.withTextField.getText().trim().isEmpty()) {
                this.errorMessage = "The 'width' field is empty";
                return false;
            }
            if (this.heightTextField.getText().trim().isEmpty()) {
                this.errorMessage = "The 'height' field is empty";
                return false;
            }
            return true;
        }

        public void saveValues() {
            this.openSaveDirsPanel.saveValues();
        }

        public int getWidthValue() {
            return this.withTextField.getIntValue();
        }

        public int getHeightValue() {
            return this.heightTextField.getIntValue();
        }
    }
}

