/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.automate;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.io.File;
import pixelitor.automate.DirectoryChooser;
import pixelitor.automate.OutputFormatSelector;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OutputFormat;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.ValidatedForm;

class OpenSaveDirsPanel
extends ValidatedForm {
    private DirectoryChooser inputChooser = new DirectoryChooser(OpenSaveManager.getLastOpenDir().getAbsolutePath(), "Select Input Directory");
    private DirectoryChooser outputChooser = new DirectoryChooser(OpenSaveManager.getLastSaveDir().getAbsolutePath(), "Select Output Directory");
    private boolean allowToBeTheSame;
    private String errMessage;
    private OutputFormatSelector outputFormatSelector;

    OpenSaveDirsPanel(boolean bl) {
        this.allowToBeTheSame = bl;
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)this, "Input Directory:", 0, 0);
        GridBagHelper.addControl(this, this.inputChooser.getDirTF());
        GridBagHelper.addNextControl(this, this.inputChooser.getButton());
        GridBagHelper.addLabel((Container)this, "Output Directory:", 0, 1);
        GridBagHelper.addControl(this, this.outputChooser.getDirTF());
        GridBagHelper.addNextControl(this, this.outputChooser.getButton());
        GridBagHelper.addLabel((Container)this, "Output Format:", 0, 2);
        this.outputFormatSelector = new OutputFormatSelector();
        GridBagHelper.addControlNoFill(this, this.outputFormatSelector.getFormatCombo());
    }

    private OutputFormat getSelectedFormat() {
        return this.outputFormatSelector.getSelectedFormat();
    }

    @Override
    public String getErrorMessage() {
        return this.errMessage;
    }

    @Override
    public boolean validateData() {
        File file = this.inputChooser.getSelectedDir();
        File file2 = this.outputChooser.getSelectedDir();
        if (!file.exists()) {
            this.errMessage = "The selected input directory " + file.getAbsolutePath() + " does not exist.";
            return false;
        }
        if (!file2.exists()) {
            this.errMessage = "The selected output directory " + file.getAbsolutePath() + " does not exist.";
            return false;
        }
        if (this.allowToBeTheSame) {
            return true;
        }
        if (file.equals(file2)) {
            this.errMessage = "The input and output directories must be different";
            return false;
        }
        return true;
    }

    public void saveValues() {
        File file;
        File file2 = this.inputChooser.getSelectedDir();
        if (file2 != null) {
            OpenSaveManager.setLastOpenDir(file2);
        }
        if ((file = this.outputChooser.getSelectedDir()) != null) {
            OpenSaveManager.setLastSaveDir(file);
        }
        OutputFormat.setLastOutputFormat(this.getSelectedFormat());
    }
}

