/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import javax.swing.AbstractAction;
import javax.swing.Action;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.ChannelMixerAdjustments;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.SliderSpinner;

public class ChannelMixer
extends FilterWithParametrizedGUI {
    private static final int MIN_PERCENT = -200;
    private static final int MAX_PERCENT = 200;
    private RangeParam rpRedFromRed = new RangeParam("<html><b><font color=red>Red</font></b> from <font color=red>red</font> (%):</html>", -200, 200, 100, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpRedFromGreen = new RangeParam("<html><b><font color=red>Red</font></b> from <font color=green>green</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpRedFromBlue = new RangeParam("<html><b><font color=red>Red</font></b> from <font color=blue>blue</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpGreenFromRed = new RangeParam("<html><b><font color=green>Green</font></b> from <font color=red>red</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpGreenFromGreen = new RangeParam("<html><b><font color=green>Green</font></b> from <font color=green>green</font> (%):</html>", -200, 200, 100, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpGreenFromBlue = new RangeParam("<html><b><font color=green>Green</font></b> from <font color=blue>blue</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpBlueFromRed = new RangeParam("<html><b><font color=blue>Blue</font></b> from <font color=red>red</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpBlueFromGreen = new RangeParam("<html><b><font color=blue>Blue</font></b> from <font color=green>green</font> (%):</html>", -200, 200, 0, true, SliderSpinner.TextPosition.NONE);
    private RangeParam rpBlueFromBlue = new RangeParam("<html><b><font color=blue>Blue</font></b> from <font color=blue>blue</font> (%):</html>", -200, 200, 100, true, SliderSpinner.TextPosition.NONE);
    private ActionListener normalizeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.normalizeChannel(ChannelMixer.this.rpRedFromRed, ChannelMixer.this.rpRedFromGreen, ChannelMixer.this.rpRedFromBlue);
            ChannelMixer.normalizeChannel(ChannelMixer.this.rpGreenFromRed, ChannelMixer.this.rpGreenFromGreen, ChannelMixer.this.rpGreenFromBlue);
            ChannelMixer.normalizeChannel(ChannelMixer.this.rpBlueFromRed, ChannelMixer.this.rpBlueFromGreen, ChannelMixer.this.rpBlueFromBlue);
            ChannelMixer.this.paramSet.endPresetAdjusting(false);
        }
    };
    private Action switchRedGreen = new AbstractAction("switch red-green"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(0);
            ChannelMixer.this.rpRedFromGreen.setValue(100);
            ChannelMixer.this.rpRedFromBlue.setValue(0);
            ChannelMixer.this.rpGreenFromRed.setValue(100);
            ChannelMixer.this.rpGreenFromGreen.setValue(0);
            ChannelMixer.this.rpGreenFromBlue.setValue(0);
            ChannelMixer.this.rpBlueFromRed.setValue(0);
            ChannelMixer.this.rpBlueFromGreen.setValue(0);
            ChannelMixer.this.rpBlueFromBlue.setValue(100);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action switchRedBlue = new AbstractAction("switch red-blue"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(0);
            ChannelMixer.this.rpRedFromGreen.setValue(0);
            ChannelMixer.this.rpRedFromBlue.setValue(100);
            ChannelMixer.this.rpGreenFromRed.setValue(0);
            ChannelMixer.this.rpGreenFromGreen.setValue(100);
            ChannelMixer.this.rpGreenFromBlue.setValue(0);
            ChannelMixer.this.rpBlueFromRed.setValue(100);
            ChannelMixer.this.rpBlueFromGreen.setValue(0);
            ChannelMixer.this.rpBlueFromBlue.setValue(0);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action switchGreenBlue = new AbstractAction("switch green-blue"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(100);
            ChannelMixer.this.rpRedFromGreen.setValue(0);
            ChannelMixer.this.rpRedFromBlue.setValue(0);
            ChannelMixer.this.rpGreenFromRed.setValue(0);
            ChannelMixer.this.rpGreenFromGreen.setValue(0);
            ChannelMixer.this.rpGreenFromBlue.setValue(100);
            ChannelMixer.this.rpBlueFromRed.setValue(0);
            ChannelMixer.this.rpBlueFromGreen.setValue(100);
            ChannelMixer.this.rpBlueFromBlue.setValue(0);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action shiftRGBR = new AbstractAction("R -> G -> B -> R"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(0);
            ChannelMixer.this.rpRedFromGreen.setValue(0);
            ChannelMixer.this.rpRedFromBlue.setValue(100);
            ChannelMixer.this.rpGreenFromRed.setValue(100);
            ChannelMixer.this.rpGreenFromGreen.setValue(0);
            ChannelMixer.this.rpGreenFromBlue.setValue(0);
            ChannelMixer.this.rpBlueFromRed.setValue(0);
            ChannelMixer.this.rpBlueFromGreen.setValue(100);
            ChannelMixer.this.rpBlueFromBlue.setValue(0);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action shiftRBGR = new AbstractAction("R -> B -> G -> R"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(0);
            ChannelMixer.this.rpRedFromGreen.setValue(100);
            ChannelMixer.this.rpRedFromBlue.setValue(0);
            ChannelMixer.this.rpGreenFromRed.setValue(0);
            ChannelMixer.this.rpGreenFromGreen.setValue(0);
            ChannelMixer.this.rpGreenFromBlue.setValue(100);
            ChannelMixer.this.rpBlueFromRed.setValue(100);
            ChannelMixer.this.rpBlueFromGreen.setValue(0);
            ChannelMixer.this.rpBlueFromBlue.setValue(0);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action averageBW = new AbstractAction("average BW"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(33);
            ChannelMixer.this.rpRedFromGreen.setValue(33);
            ChannelMixer.this.rpRedFromBlue.setValue(33);
            ChannelMixer.this.rpGreenFromRed.setValue(33);
            ChannelMixer.this.rpGreenFromGreen.setValue(33);
            ChannelMixer.this.rpGreenFromBlue.setValue(33);
            ChannelMixer.this.rpBlueFromRed.setValue(33);
            ChannelMixer.this.rpBlueFromGreen.setValue(33);
            ChannelMixer.this.rpBlueFromBlue.setValue(33);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action luminosityBW = new AbstractAction("luminosity BW"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(22);
            ChannelMixer.this.rpRedFromGreen.setValue(71);
            ChannelMixer.this.rpRedFromBlue.setValue(7);
            ChannelMixer.this.rpGreenFromRed.setValue(22);
            ChannelMixer.this.rpGreenFromGreen.setValue(71);
            ChannelMixer.this.rpGreenFromBlue.setValue(7);
            ChannelMixer.this.rpBlueFromRed.setValue(22);
            ChannelMixer.this.rpBlueFromGreen.setValue(71);
            ChannelMixer.this.rpBlueFromBlue.setValue(7);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action sepia = new AbstractAction("sepia"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChannelMixer.this.paramSet.startPresetAdjusting();
            ChannelMixer.this.rpRedFromRed.setValue(39);
            ChannelMixer.this.rpRedFromGreen.setValue(77);
            ChannelMixer.this.rpRedFromBlue.setValue(19);
            ChannelMixer.this.rpGreenFromRed.setValue(35);
            ChannelMixer.this.rpGreenFromGreen.setValue(69);
            ChannelMixer.this.rpGreenFromBlue.setValue(17);
            ChannelMixer.this.rpBlueFromRed.setValue(27);
            ChannelMixer.this.rpBlueFromGreen.setValue(53);
            ChannelMixer.this.rpBlueFromBlue.setValue(13);
            ChannelMixer.this.paramSet.endPresetAdjusting(true);
        }
    };
    private Action[] actions = new Action[]{this.switchRedGreen, this.switchRedBlue, this.switchGreenBlue, this.shiftRGBR, this.shiftRBGR, this.averageBW, this.luminosityBW, this.sepia};

    public ChannelMixer() {
        super("Channel Mixer");
        ActionParam actionParam = new ActionParam("Normalize", this.normalizeAction);
        GUIParam[] gUIParamArray = new GUIParam[]{this.rpRedFromRed, this.rpRedFromGreen, this.rpRedFromBlue, this.rpGreenFromRed, this.rpGreenFromGreen, this.rpGreenFromBlue, this.rpBlueFromRed, this.rpBlueFromGreen, this.rpBlueFromBlue, actionParam};
        this.paramSet = new ParamSet(gUIParamArray);
    }

    private static void normalizeChannel(RangeParam rangeParam, RangeParam rangeParam2, RangeParam rangeParam3) {
        int n;
        int n2;
        int n3 = rangeParam.getValue();
        int n4 = n3 + (n2 = rangeParam2.getValue()) + (n = rangeParam3.getValue()) - 100;
        if (n4 != 0) {
            rangeParam.setValue(n3 - n4 / 3);
            rangeParam2.setValue(n2 - n4 / 3);
            rangeParam3.setValue(n - n4 / 3);
        }
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f = this.rpRedFromRed.getValueAsPercentage();
        float f2 = this.rpRedFromGreen.getValueAsPercentage();
        float f3 = this.rpRedFromBlue.getValueAsPercentage();
        float f4 = this.rpGreenFromRed.getValueAsPercentage();
        float f5 = this.rpGreenFromGreen.getValueAsPercentage();
        float f6 = this.rpGreenFromBlue.getValueAsPercentage();
        float f7 = this.rpBlueFromRed.getValueAsPercentage();
        float f8 = this.rpBlueFromGreen.getValueAsPercentage();
        float f9 = this.rpBlueFromBlue.getValueAsPercentage();
        if (f == 1.0f && f2 == 0.0f && f3 == 0.0f && f4 == 0.0f && f5 == 1.0f && f6 == 0.0f && f7 == 0.0f && f8 == 0.0f && f9 == 1.0f) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        boolean bl = ImageUtils.hasPackedIntArray(bufferedImage);
        if (bl) {
            DataBufferInt dataBufferInt;
            int[] nArray;
            DataBufferInt dataBufferInt2 = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int[] nArray2 = dataBufferInt2.getData();
            int n = nArray2.length;
            if (n != (nArray = (dataBufferInt = (DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData()).length) {
                throw new IllegalArgumentException("src and dest are not the same size");
            }
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                int n3 = n2 & 0xFF000000;
                int n4 = n2 >>> 16 & 0xFF;
                int n5 = n2 >>> 8 & 0xFF;
                int n6 = n2 & 0xFF;
                int n7 = (int)(f * (float)n4 + f2 * (float)n5 + f3 * (float)n6);
                int n8 = (int)(f4 * (float)n4 + f5 * (float)n5 + f6 * (float)n6);
                int n9 = (int)(f7 * (float)n4 + f8 * (float)n5 + f9 * (float)n6);
                n7 = ImageUtils.limitTo8Bits(n7);
                n8 = ImageUtils.limitTo8Bits(n8);
                n9 = ImageUtils.limitTo8Bits(n9);
                nArray[i] = n3 | n7 << 16 | n8 << 8 | n9;
            }
        } else {
            BandCombineOp bandCombineOp = new BandCombineOp(new float[][]{{f, f2, f3}, {f4, f5, f6}, {f7, f8, f9}}, null);
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            bandCombineOp.filter(writableRaster, writableRaster2);
        }
        return bufferedImage2;
    }

    @Override
    public AdjustPanel getAdjustPanel() {
        return new ChannelMixerAdjustments((FilterWithParametrizedGUI)this, this.actions);
    }
}

