/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class Starburst
extends FilterWithParametrizedGUI {
    private RangeParam numberOfRaysParam = new RangeParam("Number of Rays", 2, 100, 10);
    private ImagePositionParam centerParam = new ImagePositionParam("Center");
    private ColorParam bgColorParam = new ColorParam("Backround Color:", Color.WHITE, false, false);
    private ColorParam fgColorParam = new ColorParam("Rays Color:", Color.BLACK, false, false);
    private BooleanParam randomColorsParam = new BooleanParam("Use Random Colors for Rays", false, true);

    public Starburst() {
        super("Starburst ");
        this.paramSet = new ParamSet(this.numberOfRaysParam, this.bgColorParam, this.fgColorParam, this.randomColorsParam, this.centerParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.bgColorParam.getColor());
        graphics2D.fillRect(0, 0, n, n2);
        float f = (float)n * this.centerParam.getRelativeX();
        float f2 = (float)n2 * this.centerParam.getRelativeY();
        graphics2D.setColor(this.fgColorParam.getColor());
        int n3 = this.numberOfRaysParam.getValue();
        boolean bl = this.randomColorsParam.getValue();
        double d = 180.0 / (double)n3;
        double d2 = 360.0 / (double)n3;
        double d3 = 0.0;
        for (int i = 0; i < n3; ++i) {
            Point2D.Float float_ = Starburst.intersectRectangleWithRay(f, f2, n, n2, d3);
            Point2D.Float float_2 = Starburst.intersectRectangleWithRay(f, f2, n, n2, d3 + d);
            if (float_ != null && float_2 != null) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(f, f2);
                double d4 = float_.getX();
                double d5 = float_.getY();
                double d6 = float_2.getX();
                double d7 = float_2.getY();
                generalPath.lineTo(d4, d5);
                if (d4 != d6 && d5 != d7) {
                    int n4;
                    int n5;
                    if (d4 == (double)n || d6 == (double)n) {
                        n5 = n;
                    } else if (d4 == 0.0 || d6 == 0.0) {
                        n5 = 0;
                    } else {
                        throw new IllegalStateException();
                    }
                    if (d5 == (double)n2 || d7 == (double)n2) {
                        n4 = n2;
                    } else if (d5 == 0.0 || d7 == 0.0) {
                        n4 = 0;
                    } else {
                        throw new IllegalStateException();
                    }
                    generalPath.lineTo(n5, n4);
                }
                generalPath.lineTo(d6, d7);
                generalPath.closePath();
                if (bl) {
                    graphics2D.setColor(ImageUtils.getRandomColor(false));
                }
                graphics2D.fill(generalPath);
            }
            d3 += d2;
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static Point2D.Float intersectRectangleWithRay(float f, float f2, int n, int n2, double d) {
        int n3;
        double d2 = Math.toRadians(d);
        if (d == 0.0) {
            if (f2 >= 0.0f && f2 <= (float)n2) {
                return new Point2D.Float(n, f2);
            }
            return null;
        }
        if (d == 180.0) {
            if (f2 >= 0.0f && f2 <= (float)n2) {
                return new Point2D.Float(0.0f, f2);
            }
            return null;
        }
        if (d > 0.0 && d < 180.0) {
            n3 = (int)((double)f + (double)f2 / Math.tan(d2));
            if (n3 >= 0 && n3 <= n) {
                return new Point2D.Float(n3, 0.0f);
            }
        } else {
            n3 = (int)((double)f - (double)((float)n2 - f2) / Math.tan(d2));
            if (n3 >= 0 && n3 <= n) {
                return new Point2D.Float(n3, n2);
            }
        }
        if ((d >= 0.0 && d < 90.0 || d > 270.0 && d <= 360.0) && (n3 = (int)((double)f2 - Math.tan(d2) * (double)((float)n - f))) >= 0 && n3 <= n2) {
            return new Point2D.Float(n, n3);
        }
        if (d > 90.0 && d < 270.0 && (n3 = (int)((double)f2 + Math.tan(d2 + Math.PI) * (double)f)) >= 0 && n3 <= n2) {
            return new Point2D.Float(0.0f, n3);
        }
        return null;
    }
}

