/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.GlowFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHGlow
extends FilterWithSOParametrizedGUI {
    private RangeParam amount = new RangeParam("Amount", 0, 100, 0);
    private RangeParam softness = new RangeParam("Softness", 0, 100, 20);
    private GlowFilter filter;

    public JHGlow() {
        super("Glow");
        this.paramSet = new ParamSet(this.amount, this.softness, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        float f = this.amount.getValueAsPercentage();
        if (f == 0.0f) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        if (this.filter == null) {
            this.filter = new GlowFilter();
        }
        this.filter.setAmount(f);
        this.filter.setRadius(this.softness.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

