/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.PolarFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;

public class JHPolarCoordinates
extends FilterWithParametrizedGUI {
    private ImagePositionParam center = new ImagePositionParam("Center");
    private static IntChoiceParam.Value[] gridTypeChoices = new IntChoiceParam.Value[]{new IntChoiceParam.Value("Rectangular to Polar ", 0), new IntChoiceParam.Value("Polar to Rectangular", 1), new IntChoiceParam.Value("Invert in Circle", 2)};
    private IntChoiceParam type = new IntChoiceParam("Type", gridTypeChoices);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private PolarFilter filter;

    public JHPolarCoordinates() {
        super("Polar Coordinates");
        this.paramSet = new ParamSet(this.center, this.type, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new PolarFilter();
        }
        this.filter.setType(this.type.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setRelativeCentreX(this.center.getRelativeX());
        this.filter.setRelativeCentreY(this.center.getRelativeY());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

