/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;

public class LayerOrderChangeEdit
extends PixelitorEdit {
    private int oldLayerIndex;
    private int newLayerIndex;

    public LayerOrderChangeEdit(Composition composition, int n, int n2) {
        super(composition, "Layer Order Change");
        composition.setDirty(true);
        this.oldLayerIndex = n;
        this.newLayerIndex = n2;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.comp.swapLayers(this.newLayerIndex, this.oldLayerIndex, true);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.comp.swapLayers(this.oldLayerIndex, this.newLayerIndex, true);
        History.postEdit(this);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

