/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.Layer;

public class LayerRenameEdit
extends PixelitorEdit {
    private Layer layer;
    private String nameBefore;
    private String nameAfter;

    public LayerRenameEdit(Layer layer, String string, String string2) {
        super(layer.getComposition(), "Rename Layer to " + string2);
        this.layer = layer;
        this.nameBefore = string;
        this.nameAfter = string2;
        layer.getComposition().setDirty(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.layer.setName(this.nameBefore, false);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.layer.setName(this.nameAfter, false);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

