/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerButtonLayout;
import pixelitor.layers.LayerButtonUI;
import pixelitor.layers.LayerNameEditor;
import pixelitor.utils.IconUtils;

public class LayerButton
extends JToggleButton {
    private final Layer layer;
    private static final Icon eyeIcon = IconUtils.loadIcon("eye_open.png");
    private static final Icon noEyeIcon = IconUtils.loadIcon("eye_closed.png");
    private static final String uiClassID = "LayerButtonUI";
    private JToggleButton visibilityButton;
    private boolean userInteraction = true;

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(new LayerButtonUI());
    }

    public void setUI(LayerButtonUI layerButtonUI) {
        super.setUI(layerButtonUI);
    }

    public LayerButton(final Layer layer) {
        this.layer = layer;
        this.setLayout(new LayerButtonLayout(5, 5));
        this.visibilityButton = new JCheckBox(noEyeIcon);
        this.visibilityButton.setRolloverIcon(noEyeIcon);
        this.visibilityButton.setSelected(true);
        this.visibilityButton.setToolTipText("Layer visibility");
        this.visibilityButton.setSelectedIcon(eyeIcon);
        this.add((Component)this.visibilityButton, "VISIBILITY_BUTTON");
        final LayerNameEditor layerNameEditor = new LayerNameEditor(layer);
        this.add((Component)layerNameEditor, "NAME_EDITOR");
        this.addPropertyChangeListener("name", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                layerNameEditor.setText(LayerButton.this.getName());
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (LayerButton.this.isSelected()) {
                    layer.makeActive(LayerButton.this.userInteraction);
                }
            }
        });
        this.visibilityButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                layer.setVisible(LayerButton.this.visibilityButton.isSelected(), true);
            }
        });
    }

    @Override
    public String toString() {
        return "LayerButton{name='" + this.layer.getName() + '\'' + '}';
    }

    public void setOpenEye(boolean bl) {
        this.visibilityButton.setSelected(bl);
    }

    public void setUserInteraction(boolean bl) {
        this.userInteraction = bl;
    }
}

