/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.filters.gui.RangeParam;
import pixelitor.layers.ImageLayer;
import pixelitor.tools.BrushType;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.Symmetry;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolAffectedArea;
import pixelitor.tools.brushes.Brush;
import pixelitor.utils.ImageSwitchListener;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.SliderSpinner;

public abstract class AbstractBrushTool
extends Tool
implements ImageSwitchListener {
    boolean respectSelection = true;
    private JComboBox typeSelector;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    Graphics2D g;
    private RangeParam brushRadiusParam = new RangeParam("Radius", 1, 100, 10);
    private Composition comp;
    private int diameter;
    private EnumComboBoxModel<Symmetry> symmetryModel = new EnumComboBoxModel<Symmetry>(Symmetry.class);
    private Brush brush = BrushType.IDEAL.getBrush();
    private int previousMouseX = 0;
    private int previousMouseY = 0;
    private boolean firstMouseDown = true;

    AbstractBrushTool(char c, String string, String string2, String string3) {
        super(c, string, string2, string3, Cursor.getPredefinedCursor(0), true, true, false);
        AppLogic.addImageChangeListener(this);
    }

    @Override
    void initSettingsPanel() {
        this.toolSettingsPanel.add(new JLabel("Type:"));
        this.typeSelector = new JComboBox<BrushType>(BrushType.values());
        this.toolSettingsPanel.add(this.typeSelector);
        this.typeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrushType brushType = (BrushType)((Object)AbstractBrushTool.this.typeSelector.getSelectedItem());
                AbstractBrushTool.this.brush = brushType.getBrush();
            }
        });
        SliderSpinner sliderSpinner = new SliderSpinner(this.brushRadiusParam, false, SliderSpinner.TextPosition.WEST);
        this.toolSettingsPanel.add(sliderSpinner);
        this.toolSettingsPanel.add(new JLabel("Mirror:"));
        JComboBox<Symmetry> jComboBox = new JComboBox<Symmetry>(this.symmetryModel);
        this.toolSettingsPanel.add(jComboBox);
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        Color color;
        boolean bl = !this.firstMouseDown && mouseEvent.isShiftDown();
        int n = mouseEvent.getButton();
        if (n == 3) {
            color = FgBgColorSelector.getBG();
        } else if (n == 2) {
            Color color2 = FgBgColorSelector.getFG();
            Color color3 = FgBgColorSelector.getBG();
            color = mouseEvent.isControlDown() ? ImageUtils.getHSBAverageColor(color2, color3) : ImageUtils.getRGBAverageColor(color2, color3);
        } else {
            color = FgBgColorSelector.getFG();
        }
        int n2 = this.userDrag.getStartX();
        int n3 = this.userDrag.getStartY();
        this.drawTo(imageComponent.getComp(), color, n2, n3, bl);
        this.firstMouseDown = false;
        if (bl) {
            this.updateMinMaxCoordinates(n2, n3);
        } else {
            this.minX = n2;
            this.minY = n3;
            this.maxX = n2;
            this.maxY = n3;
        }
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        int n = this.userDrag.getEndX();
        int n2 = this.userDrag.getEndY();
        this.drawTo(imageComponent.getComp(), null, n, n2, false);
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.finishBrushStroke(imageComponent.getComp());
    }

    private void updateMinMaxCoordinates(int n, int n2) {
        if (n > this.maxX) {
            this.maxX = n;
        } else if (n < this.minX) {
            this.minX = n;
        }
        if (n2 > this.maxY) {
            this.maxY = n2;
        } else if (n2 < this.minY) {
            this.minY = n2;
        }
    }

    abstract BufferedImage getFullUntouchedImage(Composition var1);

    abstract void mergeTmpLayer(Composition var1);

    void finishBrushStroke(Composition composition) {
        ToolAffectedArea toolAffectedArea = new ToolAffectedArea(composition, this.getRectangleAffectedByBrush(), false);
        this.saveSubImageForUndo(this.getFullUntouchedImage(composition), toolAffectedArea);
        this.mergeTmpLayer(composition);
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = null;
        composition.imageChanged(false, true);
    }

    public void drawBrushStrokeProgrammatically(Composition composition, Point point, Point point2) {
        int n = point.x;
        int n2 = point.y;
        int n3 = point2.x;
        int n4 = point2.y;
        Color color = FgBgColorSelector.getFG();
        this.drawTo(composition, color, n, n2, false);
        this.drawTo(composition, color, n3, n4, false);
        this.finishBrushStroke(composition);
    }

    abstract void initDrawingGraphics(ImageLayer var1);

    private void drawTo(Composition composition, Paint paint, int n, int n2, boolean bl) {
        this.setupDrawingDiameter();
        Symmetry symmetry = (Symmetry)((Object)this.symmetryModel.getSelectedItem());
        if (this.g == null) {
            this.comp = composition;
            ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
            this.initDrawingGraphics(imageLayer);
            this.setupGraphics(this.g, paint);
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (bl) {
                symmetry.drawLine(this, this.previousMouseX, this.previousMouseY, n, n2);
            } else {
                symmetry.drawPoint(this, n, n2);
            }
        } else {
            symmetry.drawLine(this, this.previousMouseX, this.previousMouseY, n, n2);
        }
        this.previousMouseX = n;
        this.previousMouseY = n2;
    }

    private void setupDrawingDiameter() {
        this.diameter = this.brushRadiusParam.getValue() * 2;
    }

    public void drawPoint(int n, int n2) {
        this.updateMinMaxCoordinates(n, n2);
        int n3 = this.diameter / 2;
        int n4 = n - n3;
        int n5 = n2 - n3;
        this.brush.drawPoint(this.g, n4, n5, this.diameter);
        this.comp.updateRegion(n4, n5, n4 + this.diameter + 1, n5 + this.diameter + 1, 0);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.updateMinMaxCoordinates(n3, n4);
        this.brush.drawLine(this.g, n, n2, n3, n4, this.diameter);
        this.comp.updateRegion(n, n2, n3, n4, this.diameter);
    }

    protected abstract void setupGraphics(Graphics2D var1, Paint var2);

    @Override
    protected void toolStarted() {
        super.toolStarted();
        this.resetState();
    }

    @Override
    public void noOpenImageAnymore() {
    }

    @Override
    public void newImageOpened() {
        this.resetState();
    }

    @Override
    public void activeCompositionHasChanged(Composition composition) {
        this.resetState();
    }

    private void resetState() {
        this.firstMouseDown = true;
        this.respectSelection = true;
    }

    private Rectangle getRectangleAffectedByBrush() {
        int n = this.brushRadiusParam.getValue();
        int n2 = 2 * n;
        int n3 = 4 * n;
        int n4 = this.minX - n2;
        int n5 = this.minY - n2;
        int n6 = this.maxX - this.minX + n3;
        int n7 = this.maxY - this.minY + n3;
        Rectangle rectangle = new Rectangle(n4, n5, n6, n7);
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Composition composition, Shape shape) {
        this.comp = composition;
        this.setupDrawingDiameter();
        try {
            this.respectSelection = false;
            ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
            this.initDrawingGraphics(imageLayer);
            this.setupGraphics(this.g, FgBgColorSelector.getFG());
            int n = 0;
            int n2 = 0;
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
            float[] fArray = new float[2];
            while (!flatteningPathIterator.isDone()) {
                int n3 = flatteningPathIterator.currentSegment(fArray);
                int n4 = (int)fArray[0];
                int n5 = (int)fArray[1];
                this.updateMinMaxCoordinates(n4, n5);
                if (n3 == 0) {
                    n = n4;
                    n2 = n5;
                    this.previousMouseX = n4;
                    this.previousMouseY = n5;
                } else if (n3 == 1) {
                    this.drawLine(this.previousMouseX, this.previousMouseY, n4, n5);
                    this.previousMouseX = n4;
                    this.previousMouseY = n5;
                } else if (n3 == 4) {
                    this.drawLine(this.previousMouseX, this.previousMouseY, n, n2);
                } else {
                    throw new IllegalArgumentException("type = " + n3);
                }
                flatteningPathIterator.next();
            }
            this.finishBrushStroke(composition);
        }
        finally {
            this.resetState();
        }
    }

    public void increaseBrushSize() {
        this.brushRadiusParam.increaseValue();
    }

    public void decreaseBrushSize() {
        this.brushRadiusParam.decreaseValue();
    }
}

