/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.gradientpaints;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import pixelitor.tools.UserDrag;

public class SpiralGradientPaint
implements Paint {
    private boolean clockwise;
    private UserDrag userDrag;
    private Color startColor;
    private Color endColor;
    private MultipleGradientPaint.CycleMethod cycleMethod;

    public SpiralGradientPaint(boolean bl, UserDrag userDrag, Color color, Color color2, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.clockwise = bl;
        this.userDrag = userDrag;
        this.startColor = color;
        this.endColor = color2;
        this.cycleMethod = cycleMethod;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new SpiralGradientPaintContext(this.clockwise, this.userDrag, this.startColor, this.endColor, colorModel, this.cycleMethod);
    }

    @Override
    public int getTransparency() {
        int n;
        int n2 = this.startColor.getAlpha();
        return (n2 & (n = this.endColor.getAlpha())) == 255 ? 1 : 3;
    }

    static class SpiralGradientPaintContext
    implements PaintContext {
        private boolean clockwise;
        private UserDrag userDrag;
        private MultipleGradientPaint.CycleMethod cycleMethod;
        private int startAlpha;
        private int startRed;
        private int startGreen;
        private int startBlue;
        private int endAlpha;
        private int endRed;
        private int endGreen;
        private int endBlue;
        private ColorModel cm;
        private double drawAngle;
        private double drawDistance;

        private SpiralGradientPaintContext(boolean bl, UserDrag userDrag, Color color, Color color2, ColorModel colorModel, MultipleGradientPaint.CycleMethod cycleMethod) {
            this.clockwise = bl;
            this.userDrag = userDrag;
            this.cycleMethod = cycleMethod;
            this.startAlpha = color.getAlpha();
            this.startRed = color.getRed();
            this.startGreen = color.getGreen();
            this.startBlue = color.getBlue();
            this.endAlpha = color2.getAlpha();
            this.endRed = color2.getRed();
            this.endGreen = color2.getGreen();
            this.endBlue = color2.getBlue();
            this.cm = colorModel;
            this.drawAngle = userDrag.getDrawAngle() + Math.PI;
            this.drawDistance = userDrag.getDistance();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.cm;
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.cm.createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = (i * n3 + j) * 4;
                    int n6 = n + j;
                    int n7 = n2 + i;
                    double d = this.userDrag.getAngleFromStartTo(n6, n7) + Math.PI;
                    double d2 = this.clockwise ? d - this.drawAngle : this.drawAngle - d;
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    double d3 = this.userDrag.getStartDistanceFrom(n6, n7);
                    double d4 = d3 / this.drawDistance;
                    double d5 = (d2 /= Math.PI * 2) + d4;
                    d5 %= 1.0;
                    if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REFLECT) {
                        d5 = d5 < 0.5 ? 2.0 * d5 : 2.0 * (1.0 - d5);
                    } else if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REPEAT) {
                        d5 = d5 < 0.5 ? 2.0 * d5 : 2.0 * (d5 - 0.5);
                    }
                    int n8 = (int)((double)this.startAlpha + d5 * (double)(this.endAlpha - this.startAlpha));
                    int n9 = (int)((double)this.startRed + d5 * (double)(this.endRed - this.startRed));
                    int n10 = (int)((double)this.startGreen + d5 * (double)(this.endGreen - this.startGreen));
                    int n11 = (int)((double)this.startBlue + d5 * (double)(this.endBlue - this.startBlue));
                    nArray[n5] = n9;
                    nArray[n5 + 1] = n10;
                    nArray[n5 + 2] = n11;
                    nArray[n5 + 3] = n8;
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

