/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

public final class GridBagHelper {
    private static final Insets insets = new Insets(2, 2, 2, 2);
    private static GridBagConstraints labelConstraint = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, insets, 0, 0);
    private static GridBagConstraints nextControlConstraint = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 2, insets, 0, 0);
    private static GridBagConstraints nextLastControlConstraint = new GridBagConstraints(0, 0, 0, 1, 0.0, 1.0, 17, 2, insets, 0, 0);

    private GridBagHelper() {
    }

    public static void addLabel(Container container, String string, int n, int n2) {
        JLabel jLabel = new JLabel(string, 4);
        GridBagHelper.addLabel(container, jLabel, n, n2);
    }

    public static void addLabel(Container container, JLabel jLabel, int n, int n2) {
        GridBagHelper.labelConstraint.gridx = n;
        GridBagHelper.labelConstraint.gridy = n2;
        container.add((Component)jLabel, labelConstraint);
    }

    public static void addControl(Container container, Component component) {
        GridBagHelper.nextControlConstraint.gridx = GridBagHelper.labelConstraint.gridx + 1;
        GridBagHelper.nextControlConstraint.gridy = GridBagHelper.labelConstraint.gridy;
        container.add(component, nextControlConstraint);
    }

    public static void addLabelWithControl(Container container, String string, int n, Component component) {
        JLabel jLabel = new JLabel(string, 4);
        GridBagHelper.labelConstraint.gridx = 0;
        GridBagHelper.labelConstraint.gridy = n;
        container.add((Component)jLabel, labelConstraint);
        GridBagHelper.nextControlConstraint.gridx = 1;
        GridBagHelper.nextControlConstraint.gridy = n;
        container.add(component, nextControlConstraint);
    }

    public static void addControlNoFill(Container container, Component component) {
        GridBagHelper.nextControlConstraint.gridx = GridBagHelper.labelConstraint.gridx + 1;
        GridBagHelper.nextControlConstraint.gridy = GridBagHelper.labelConstraint.gridy;
        GridBagHelper.nextControlConstraint.fill = 0;
        container.add(component, nextControlConstraint);
        GridBagHelper.nextControlConstraint.fill = 2;
    }

    public static void addNextControl(Container container, Component component) {
        ++GridBagHelper.nextControlConstraint.gridx;
        container.add(component, nextControlConstraint);
    }

    public static void addLastControl(Container container, Component component) {
        GridBagHelper.nextLastControlConstraint.gridx = GridBagHelper.labelConstraint.gridx + 1;
        GridBagHelper.nextLastControlConstraint.gridy = GridBagHelper.labelConstraint.gridy;
        container.add(component, nextLastControlConstraint);
    }

    public static void addOnlyControlToRow(Container container, Component component, int n) {
        GridBagHelper.nextLastControlConstraint.gridx = 0;
        GridBagHelper.nextLastControlConstraint.gridy = n;
        container.add(component, nextLastControlConstraint);
    }
}

