/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import pixelitor.utils.debug.ColorSpaceNode;
import pixelitor.utils.debug.DebugNode;

public class ColorModelNode
extends DebugNode {
    public ColorModelNode(ColorModel colorModel) {
        this("ColorModel", colorModel);
    }

    public ColorModelNode(String string, ColorModel colorModel) {
        super(string, colorModel);
        this.addClassChild();
        ColorSpace colorSpace = colorModel.getColorSpace();
        this.add(new ColorSpaceNode(colorSpace));
        int n = colorModel.getNumColorComponents();
        this.addIntChild("numColorComponents", n);
        int n2 = colorModel.getNumComponents();
        this.addIntChild("numComponents", n2);
        boolean bl = colorModel.hasAlpha();
        this.addBooleanChild("hasAlpha", bl);
        int n3 = colorModel.getPixelSize();
        this.addIntChild("pixelSize", n3);
        int n4 = colorModel.getTransferType();
        String string2 = ColorModelNode.getTransferTypeDescription(n4);
        this.addStringChild("transferType", string2);
        int n5 = colorModel.getTransparency();
        this.addStringChild("transparency", ColorModelNode.getTransparencyDescription(n5));
        boolean bl2 = ColorModelNode.isRgbColorModel(colorModel);
        this.addBooleanChild("isRGB", bl2);
        boolean bl3 = ColorModelNode.isBgrColorModel(colorModel);
        this.addBooleanChild("isBGR", bl3);
    }

    private static boolean isRgbColorModel(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255 && (directColorModel.getNumComponents() == 3 || directColorModel.getAlphaMask() == -16777216);
        }
        return false;
    }

    private static boolean isBgrColorModel(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return directColorModel.getRedMask() == 255 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 0xFF0000 && (directColorModel.getNumComponents() == 3 || directColorModel.getAlphaMask() == -16777216);
        }
        return false;
    }

    public static String getTransferTypeDescription(int n) {
        switch (n) {
            case 0: {
                return "TYPE_BYTE";
            }
            case 1: {
                return "TYPE_USHORT";
            }
            case 3: {
                return "TYPE_INT";
            }
        }
        return "UNKNOWN";
    }

    private static String getTransparencyDescription(int n) {
        if (n == 1) {
            return "OPAQUE";
        }
        if (n == 2) {
            return "BITMASK";
        }
        if (n == 3) {
            return "TRANSLUCENT";
        }
        return "UNKNOWN";
    }
}

