/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import WaterMarker.RescaleImage;
import WatermarkHelper.WaterMarkHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class PreviewGUI
extends JFrame {
    WaterMarkHelper previewHelper;
    Color shapeColor = null;
    boolean isUpdate = false;
    int previewIndex;
    double maxHeight;
    double maxWidth;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public PreviewGUI(WaterMarkHelper helper, double MaxHeight, double MaxWidth, int index) {
        this.previewHelper = helper;
        this.previewIndex = index;
        this.maxHeight = MaxHeight;
        this.maxWidth = MaxWidth;
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.setTitle(this.previewHelper.getProperty("title.preview.gui"));
        this.setDefaultCloseOperation(0);
        this.setBackground(new Color(51, 51, 51));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Frame frame = (Frame)evt.getSource();
                frame.dispose();
                PreviewGUI.this.previewHelper.setEnable(PreviewGUI.this.previewHelper.getMainFrame());
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jLabel1.setFont(new Font("Palatino Linotype", 0, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Preview Panel");
        this.jLabel2.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel2.setForeground(new Color(255, 102, 51));
        this.jLabel2.setText("[?]");
        this.jLabel2.setToolTipText(this.previewHelper.getProperty("help.preview"));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        ImageIcon imageIcon = new ImageIcon(this.PreviewWaterMarkedImagepublic(this.previewHelper, this.maxHeight, this.maxWidth, this.previewIndex));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(imageIcon);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 770, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 510, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel2);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 772, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(325, 325, 325).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 331, Short.MAX_VALUE).addComponent(this.jLabel2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 512, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 600) / 2, 800, 600);
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage PreviewWaterMarkedImagepublic(WaterMarkHelper helper, double MaxHeight, double MaxWidth, int index) {
        ArrayList watermarker = helper.getWaterMarkerList();
        try {
            BufferedImage source = null;
            File inputImage = (File)helper.getInputFiles().get(index);
            String inputFileName = inputImage.getPath();
            String inputFileExtension = inputFileName.substring(inputFileName.lastIndexOf(".") + 1);
            if (inputFileExtension.equalsIgnoreCase("tiff") || inputFileExtension.equalsIgnoreCase("tif")) {
                RenderedOp images = JAI.create((String)"fileload", (Object)inputImage.getPath());
                source = helper.convertRenderedImage((RenderedImage)images);
            } else if (inputFileExtension.equalsIgnoreCase("jpg") || inputFileExtension.equalsIgnoreCase("jpeg") || inputFileExtension.equalsIgnoreCase("jpe") || inputFileExtension.equalsIgnoreCase("jfif") || inputFileExtension.equalsIgnoreCase("png") || inputFileExtension.equalsIgnoreCase("bmp") || inputFileExtension.equalsIgnoreCase("gif")) {
                source = ImageIO.read(new File(inputImage.getPath()));
            } else {
                URL is = this.getClass().getResource("/image/blank.png");
                try {
                    source = ImageIO.read(is);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            double height = source.getHeight();
            double width = source.getWidth();
            String imageSizeString = helper.imageSize(height, width, MaxHeight, MaxWidth);
            String[] imageSize = imageSizeString.split("##@@##");
            height = Double.parseDouble(imageSize[0]);
            width = Double.parseDouble(imageSize[1]);
            Object interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            double xScale = width / (double)sourceWidth;
            double yScale = height / (double)sourceHeight;
            if (height <= 0.0) {
                xScale = yScale;
                width = (int)Math.rint(xScale * (double)sourceWidth);
            }
            if (height <= 0.0) {
                yScale = xScale;
                width = (int)Math.rint(yScale * (double)sourceHeight);
            }
            GraphicsConfiguration gc = PreviewGUI.getDefaultConfiguration();
            BufferedImage result = gc.createCompatibleImage((int)width, (int)height, source.getColorModel().getTransparency());
            Graphics2D g2d = null;
            try {
                g2d = result.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
                AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
                g2d.drawRenderedImage(source, at);
                JPanel[] watermarkerPreviewPanels = new JPanel[watermarker.size()];
                int panelCount = 0;
                for (ArrayList waterMarkerList : watermarker) {
                    int middleYPosition;
                    int textWidth;
                    int blockWidth;
                    int blockHeight;
                    String[] WatermarkingText;
                    FontMetrics outMetrics;
                    Font font;
                    String positionSelect = waterMarkerList.get(10).toString();
                    int hSpace = Integer.parseInt(waterMarkerList.get(13).toString());
                    int vSpace = Integer.parseInt(waterMarkerList.get(14).toString());
                    int x = 0;
                    int y = 0;
                    float fill = (float)(Double.valueOf(waterMarkerList.get(9).toString()) / 100.0);
                    watermarkerPreviewPanels[panelCount] = new JPanel();
                    watermarkerPreviewPanels[panelCount].setOpaque(false);
                    if (waterMarkerList.get(0).toString().equalsIgnoreCase("TEXT")) {
                        int i;
                        font = (Font)waterMarkerList.get(7);
                        outMetrics = g2d.getFontMetrics(font);
                        g2d.setFont(font);
                        g2d.setColor((Color)waterMarkerList.get(8));
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        WatermarkingText = (String[])waterMarkerList.get(1);
                        blockHeight = 0;
                        blockWidth = 0;
                        if (positionSelect.equalsIgnoreCase("Horizontal Top Left") || positionSelect.equalsIgnoreCase("Horizontal Top Center") || positionSelect.equalsIgnoreCase("Horizontal Top Right") || positionSelect.equalsIgnoreCase("Horizontal Middle Left") || positionSelect.equalsIgnoreCase("Horizontal Middle Center") || positionSelect.equalsIgnoreCase("Horizontal Middle Right") || positionSelect.equalsIgnoreCase("Horizontal Bottom Left") || positionSelect.equalsIgnoreCase("Horizontal Bottom Center") || positionSelect.equalsIgnoreCase("Horizontal Bottom Right") || positionSelect.equalsIgnoreCase("Horizontal Coustome")) {
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                                int textHeight = (int)rect.getHeight();
                                textWidth = (int)rect.getWidth();
                                blockHeight += textHeight;
                                if (blockWidth >= textWidth) continue;
                                blockWidth = textWidth;
                            }
                            Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                            int textHeight0Posn = (int)rect0Posn.getHeight();
                            int topYposition = vSpace - textHeight0Posn;
                            middleYPosition = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                            int bottomYPosition = result.getHeight() - blockHeight - vSpace - textHeight0Posn + outMetrics.getAscent();
                            int coustomYPosition = Integer.parseInt(waterMarkerList.get(12).toString()) - textHeight0Posn;
                            for (i = 0; i < WatermarkingText.length; ++i) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth2 = (int)rect.getWidth();
                                if (positionSelect.equalsIgnoreCase("Horizontal Top Left")) {
                                    x = hSpace;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Top Center")) {
                                    x = result.getWidth() / 2 - textWidth2 / 2;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Top Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Left")) {
                                    x = hSpace;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Center")) {
                                    x = result.getWidth() / 2 - textWidth2 / 2;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Left")) {
                                    x = hSpace;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Center")) {
                                    x = result.getWidth() / 2 - textWidth2 / 2;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Coustome")) {
                                    x = Integer.parseInt(waterMarkerList.get(11).toString());
                                    y = coustomYPosition += textHeight;
                                }
                                g2d.drawString(WatermarkingText[i], x, y);
                            }
                        } else if (positionSelect.equalsIgnoreCase("Vertical Top Left") || positionSelect.equalsIgnoreCase("Vertical Top Center") || positionSelect.equalsIgnoreCase("Vertical Top Right") || positionSelect.equalsIgnoreCase("Vertical Middle Left") || positionSelect.equalsIgnoreCase("Vertical Middle Center") || positionSelect.equalsIgnoreCase("Vertical Middle Right") || positionSelect.equalsIgnoreCase("Vertical Bottom Left") || positionSelect.equalsIgnoreCase("Vertical Bottom Center") || positionSelect.equalsIgnoreCase("Vertical Bottom Right") || positionSelect.equalsIgnoreCase("Vertical Coustome")) {
                            ArrayList<Integer> lineWidthList = new ArrayList<Integer>();
                            ArrayList<Integer> lineHeightList = new ArrayList<Integer>();
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                char[] CurrentLine = WatermarkingText[r].toString().toCharArray();
                                int lineHeight = 0;
                                int lineWidth = 0;
                                for (i = 0; i < CurrentLine.length; ++i) {
                                    String Character = String.valueOf(CurrentLine[i]);
                                    Rectangle2D rect = outMetrics.getStringBounds(Character, g2d);
                                    int charHeight = (int)rect.getHeight();
                                    int charWidth = (int)rect.getWidth();
                                    lineHeight += charHeight;
                                    if (lineWidth >= charWidth) continue;
                                    lineWidth = charWidth;
                                }
                                blockWidth += lineWidth;
                                if (blockHeight < lineHeight) {
                                    blockHeight = lineHeight;
                                }
                                lineWidthList.add(lineWidth);
                                lineHeightList.add(lineHeight);
                            }
                            int TopLeftXPosition = 0;
                            int TopLeftYPosition = 0;
                            if (positionSelect.equalsIgnoreCase("Vertical Top Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Top Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Top Right")) {
                                TopLeftXPosition = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Right")) {
                                TopLeftXPosition = x = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Right")) {
                                TopLeftXPosition = x = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Coustome")) {
                                TopLeftXPosition = Integer.parseInt(waterMarkerList.get(11).toString());
                                TopLeftYPosition = Integer.parseInt(waterMarkerList.get(12).toString());
                            }
                            int currentXPosition = TopLeftXPosition - Integer.parseInt(lineWidthList.get(0).toString());
                            for (int r1 = 0; r1 < WatermarkingText.length; ++r1) {
                                int lineHeight = Integer.parseInt(lineHeightList.get(r1).toString());
                                int lineWidth = Integer.parseInt(lineWidthList.get(r1).toString());
                                currentXPosition += lineWidth;
                                char[] CurrentLine = WatermarkingText[r1].toString().toCharArray();
                                String firstChar = WatermarkingText[r1].toString().substring(0, 1);
                                Rectangle2D rect0Posn = outMetrics.getStringBounds(firstChar, g2d);
                                int charHeight0Posn = (int)rect0Posn.getHeight();
                                int currentYPosition = TopLeftYPosition;
                                int modifiedYposition = currentYPosition + (blockHeight - lineHeight) / 2;
                                for (int i1 = 0; i1 < CurrentLine.length; ++i1) {
                                    String Character = String.valueOf(CurrentLine[i1]);
                                    Rectangle2D rect = outMetrics.getStringBounds(Character, g2d);
                                    int charHeight = (int)rect.getHeight();
                                    int charWidth = (int)rect.getWidth();
                                    int modifiedXPosition = currentXPosition + (lineWidth - charWidth) / 2;
                                    g2d.drawString(Character, modifiedXPosition, modifiedYposition += charHeight);
                                }
                            }
                        } else if (positionSelect.equalsIgnoreCase("Bottom-Top Diognal") || positionSelect.equalsIgnoreCase("Top-Bottom Diognal")) {
                            double resHeight = result.getHeight();
                            double resWidth = result.getWidth();
                            double angle = Math.atan2(resHeight, resWidth);
                            if (positionSelect.equalsIgnoreCase("Bottom-Top Diognal")) {
                                angle *= -1.0;
                            }
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth3 = (int)rect.getWidth();
                                blockHeight += textHeight;
                                if (blockWidth >= textWidth3) continue;
                                blockWidth = textWidth3;
                            }
                            Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                            int textHeight0Posn = (int)rect0Posn.getHeight();
                            int middleYPosition2 = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                            for (int i2 = 0; i2 < WatermarkingText.length; ++i2) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i2], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth4 = (int)rect.getWidth();
                                x = result.getWidth() / 2 - textWidth4 / 2;
                                y = middleYPosition2 += textHeight;
                                AffineTransform affineTransform = new AffineTransform();
                                affineTransform.rotate(angle, result.getWidth() / 2, result.getHeight() / 2);
                                g2d.transform(affineTransform);
                                g2d.drawString(WatermarkingText[i2], x, y);
                                AffineTransform affineTransformRev = new AffineTransform();
                                affineTransformRev.rotate(-angle, result.getWidth() / 2, result.getHeight() / 2);
                                g2d.transform(affineTransformRev);
                            }
                        } else {
                            Integer.parseInt("s");
                        }
                    } else if (waterMarkerList.get(0).toString().equalsIgnoreCase("SHAPE")) {
                        int ShapeHeight = Integer.parseInt(waterMarkerList.get(6).toString());
                        int ShapeWidth = Integer.parseInt(waterMarkerList.get(5).toString());
                        if (positionSelect.equalsIgnoreCase("Top Left")) {
                            x = hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                            x = hSpace;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                            x = hSpace;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Coustome")) {
                            x = Integer.parseInt(waterMarkerList.get(11).toString());
                            y = Integer.parseInt(waterMarkerList.get(12).toString());
                        }
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        g2d.setColor((Color)waterMarkerList.get(8));
                        if (waterMarkerList.get(2).toString().equalsIgnoreCase("RECTRANGLE")) {
                            g2d.fillRect(x, y, ShapeWidth, ShapeHeight);
                        } else if (waterMarkerList.get(2).toString().equalsIgnoreCase("OVEL")) {
                            g2d.fillOval(x, y, ShapeWidth, ShapeHeight);
                        } else {
                            Integer.parseInt("s");
                        }
                    } else if (waterMarkerList.get(0).toString().equalsIgnoreCase("IMAGE")) {
                        File f = (File)waterMarkerList.get(3);
                        RenderedOp image2 = JAI.create((String)"fileload", (Object)f.getPath());
                        BufferedImage waterMarkImage = helper.convertRenderedImage((RenderedImage)image2);
                        double imageScale = Double.parseDouble(waterMarkerList.get(4).toString()) / 100.0;
                        RescaleImage RescaleImage2 = new RescaleImage();
                        BufferedImage im2 = RescaleImage2.RescaleImage(helper, waterMarkImage, (double)waterMarkImage.getHeight() * imageScale, (double)waterMarkImage.getWidth() * imageScale);
                        if (positionSelect.equalsIgnoreCase("Top Left")) {
                            x = hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                            x = hSpace;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                            x = hSpace;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Coustome")) {
                            x = Integer.parseInt(waterMarkerList.get(11).toString());
                            y = Integer.parseInt(waterMarkerList.get(12).toString());
                        }
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        g2d.drawImage((Image)im2, x, y, null);
                    } else if (waterMarkerList.get(0).toString().equalsIgnoreCase("CAPTION")) {
                        font = (Font)waterMarkerList.get(7);
                        outMetrics = g2d.getFontMetrics(font);
                        g2d.setFont(font);
                        g2d.setColor((Color)waterMarkerList.get(8));
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        WatermarkingText = new String[1];
                        blockHeight = 0;
                        blockWidth = 0;
                        WatermarkingText[0] = "Currently Showing Sample Caption";
                        for (int r = 0; r < WatermarkingText.length; ++r) {
                            Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                            int textHeight = (int)rect.getHeight();
                            textWidth = (int)rect.getWidth();
                            blockHeight += textHeight;
                            if (blockWidth >= textWidth) continue;
                            blockWidth = textWidth;
                        }
                        Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                        int textHeight0Posn = (int)rect0Posn.getHeight();
                        int topYposition = vSpace - textHeight0Posn;
                        middleYPosition = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                        int bottomYPosition = result.getHeight() - blockHeight - vSpace - textHeight0Posn + outMetrics.getAscent();
                        for (int i = 0; i < WatermarkingText.length; ++i) {
                            Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i], g2d);
                            int textHeight = (int)rect.getHeight();
                            int textWidth5 = (int)rect.getWidth();
                            if (positionSelect.equalsIgnoreCase("Top Left")) {
                                x = hSpace;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                                x = result.getWidth() / 2 - textWidth5 / 2;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                                x = hSpace;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                                x = result.getWidth() / 2 - textWidth5 / 2;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                                x = hSpace;
                                y = bottomYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                                x = result.getWidth() / 2 - textWidth5 / 2;
                                y = bottomYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = bottomYPosition += textHeight;
                            }
                            g2d.drawString(WatermarkingText[i], x, y);
                        }
                    } else {
                        Integer.parseInt("s");
                    }
                    ++panelCount;
                }
            }
            finally {
                if (g2d != null) {
                    g2d.dispose();
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

