/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CaptionGUI;
import GUI.ExtensionFileFilter;
import GUI.ImageGUI;
import GUI.MultipleImageAddGUI;
import GUI.NumericTextField;
import GUI.PreviewGUI;
import GUI.ShapeGUI;
import GUI.SpringUtilities;
import GUI.TextGUI;
import WaterMarker.RescaleImage;
import WaterMarker.WaterMarkImages;
import WatermarkHelper.ExportXML;
import WatermarkHelper.ImagePreviewPanel;
import WatermarkHelper.ImportXML;
import WatermarkHelper.WaterMarkHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;

public class WaterMarkGUI
extends JFrame {
    WaterMarkHelper helper = new WaterMarkHelper();
    File outputImage = null;
    ArrayList inputFileList = new ArrayList();
    JPanel[] jFileListPanel;
    JLabel[] jFileListLabel;
    JLabel[] jFileListLabelCount;
    JLabel[] jFileListLabelStatus;
    int currentIndex = 0;
    private JLabel ImagePanel;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    public JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JFileChooser jFileChooser1;
    private JFileChooser jFileChooser2;
    private Thread worker;

    public WaterMarkGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.ImagePanel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jButton2 = new JButton();
        this.jTextField2 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextField3 = new NumericTextField();
        this.jTextField4 = new NumericTextField();
        this.jPanel3 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButton3 = new JButton();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel11 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jPanel9 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jPanel10 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jButton11 = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.helper.readPropertyFile();
        this.helper.setMainFrame(this);
        this.helper.setMainPanel(this.jPanel1);
        this.helper.setMainProgressBar(this.jProgressBar1);
        this.helper.setMainStatus(this.jLabel4);
        this.helper.setMainWaterMarksDetails(this.jPanel10);
        this.helper.setInPutImageTextField(this.jTextField1);
        this.helper.setOutPutImageTextField(this.jTextField2);
        this.helper.setOutputFolderName(this.helper.getDate());
        this.helper.setInputFiles(new ArrayList());
        this.helper.setInputFilesCaption(new ArrayList());
        this.worker = new Thread(new WaterMarkImages(this.helper, this.jFileListLabelStatus));
        this.helper.setWorker(this.worker);
        this.helper.setStop(false);
        this.helper.setPause(false);
        this.helper.setLogParam();
        this.helper.setExtensions();
        this.helper.setImageFormats();
        this.setDefaultCloseOperation(3);
        this.setTitle("Hitesh S J Sathawane Watermarker 3.0");
        this.setResizable(false);
        this.setBackground(new Color(51, 51, 51));
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jLabel1.setFont(new Font("Palatino Linotype", 1, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Watermarker");
        this.jLabel2.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel2.setForeground(new Color(255, 102, 0));
        this.jLabel2.setText("[?]");
        this.jLabel2.setToolTipText(this.helper.getProperty("help.Main"));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Select Image & Set Details", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jLabel5.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel5.setForeground(new Color(204, 204, 204));
        this.jLabel5.setText("Select Type");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Singe Image", "Multiple Images", "All Images in Folder", "All Images in Folder-Subfolders"}));
        this.jComboBox1.setToolTipText("Select if to watermark Image or multiple Images or all images in folder");
        this.jLabel6.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel6.setForeground(new Color(204, 204, 204));
        this.jLabel6.setText("Select Images");
        this.jButton1.setText("Brows");
        this.jButton1.setToolTipText("Select Image / Images ");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("Select Images");
        this.jTextField1.setToolTipText("Input Image Path");
        this.jTextField1.setEditable(false);
        this.jTextField1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                WaterMarkGUI.this.jButton1ActionPerformed1(evt);
            }
        });
        this.jLabel7.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel7.setForeground(new Color(204, 204, 204));
        this.jLabel7.setText("Image Format");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"jpg", "pdf"}));
        this.jLabel8.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel8.setForeground(new Color(204, 204, 204));
        this.jLabel8.setText("Output Folder");
        this.jButton2.setText("Brows");
        this.jButton2.setToolTipText("Select Folder to save output Image / Images");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextField2.setText("Output Folder");
        this.jTextField2.setToolTipText("Output Path");
        this.jTextField2.setEditable(false);
        this.jTextField2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                WaterMarkGUI.this.BrowsOutput(evt);
            }
        });
        this.jLabel9.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel9.setForeground(new Color(204, 204, 204));
        this.jLabel9.setText("Max Height");
        this.jLabel10.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel10.setForeground(new Color(204, 204, 204));
        this.jLabel10.setText("Max Width");
        this.jTextField3.setText("600");
        this.jTextField3.setToolTipText("Maximum Height in pixals");
        this.jTextField3.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                WaterMarkGUI.this.MaxHeightCheckNumber(evt);
            }
        });
        this.jTextField4.setText("800");
        this.jTextField4.setToolTipText("Maximum Width in pixals");
        this.jTextField4.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                WaterMarkGUI.this.MaxWidthCheckNumber(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox2, 0, -1, Short.MAX_VALUE).addComponent(this.jTextField3, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 170, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, 79, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, 73, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField4).addComponent(this.jTextField2, -1, 73, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 146, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jButton1).addComponent(this.jLabel5).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jButton2).addComponent(this.jTextField2, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jTextField3, -2, -1, -2)).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBackground(new Color(51, 51, 51));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Image List", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jPanel7.setBackground(new Color(51, 51, 51));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(0, 153, 255)));
        this.jPanel7.setForeground(new Color(51, 51, 51));
        this.ImagePanel.setHorizontalAlignment(0);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 120, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ImagePanel, -1, 100, Short.MAX_VALUE));
        this.jButton3.setText("Preview");
        this.jButton3.setToolTipText("Preview");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.Preview(evt);
            }
        });
        this.jPanel6.setBackground(new Color(51, 51, 51));
        this.jPanel11.setBackground(new Color(51, 51, 51));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 441, Short.MAX_VALUE));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 119, Short.MAX_VALUE));
        this.jScrollPane2.setViewportView(this.jPanel11);
        this.jLabel11.setFont(new Font("Palatino Linotype", 0, 10));
        this.jLabel11.setForeground(new Color(0, 153, 255));
        this.jLabel11.setText("File: ");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 443, Short.MAX_VALUE).addComponent(this.jLabel11)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 121, Short.MAX_VALUE).addGap(7, 7, 7).addComponent(this.jLabel11)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel4.setBackground(new Color(51, 51, 51));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Function Panel", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 153, 255)));
        this.jPanel8.setBackground(new Color(51, 51, 51));
        this.jButton4.setText("Start");
        this.jButton4.setToolTipText("Start Watermarking");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.Start(evt);
            }
        });
        this.jButton5.setText("Reset");
        this.jButton5.setToolTipText("Reset");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.reset(evt);
            }
        });
        this.jButton6.setText("Pause");
        this.jButton6.setToolTipText("Pause/Resume Watermarking");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.Pause(evt);
            }
        });
        this.jButton7.setText("Import");
        this.jButton7.setToolTipText("Import Settings from external file");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.importSettingsAction(evt);
            }
        });
        this.jButton8.setText("Stop");
        this.jButton8.setToolTipText("Stop Watermarking");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.Stop(evt);
            }
        });
        this.jButton9.setText("Export");
        this.jButton9.setToolTipText("Export settings to external folder");
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.ExportSettingsAction(evt);
            }
        });
        this.jButton10.setText("Exit");
        this.jButton10.setToolTipText("Stop the Program and Exit");
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.exit(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton10, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8, -1, -1, Short.MAX_VALUE).addComponent(this.jButton6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, GroupLayout.Alignment.LEADING, -1, 69, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton9, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton7).addComponent(this.jButton6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton9).addComponent(this.jButton8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton10)));
        this.jPanel9.setBackground(new Color(51, 51, 51));
        this.jPanel10.setBackground(new Color(51, 51, 51));
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 416, Short.MAX_VALUE));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.jScrollPane3.setViewportView(this.jPanel10);
        this.jLabel12.setBackground(new Color(204, 204, 204));
        this.jLabel12.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel12.setForeground(new Color(204, 204, 204));
        this.jLabel12.setText("Add Watermarker");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"Text", "Image", "Shape", "Caption"}));
        this.jComboBox3.setToolTipText("Select type of Watermark to be added");
        this.jButton11.setText("Add");
        this.jButton11.setToolTipText("Add Watermarkers");
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaterMarkGUI.this.addWaterMarkers(evt);
            }
        });
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addComponent(this.jLabel12).addGap(35, 35, 35).addComponent(this.jComboBox3, -2, 129, -2).addGap(18, 18, 18).addComponent(this.jButton11, -1, 130, Short.MAX_VALUE)).addComponent(this.jScrollPane3, -1, 399, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jButton11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.jScrollPane3, -2, 100, -2)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel9, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, -2, -1, -2)).addContainerGap()));
        this.jPanel5.setBackground(new Color(51, 51, 51));
        this.jLabel3.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel3.setForeground(new Color(51, 153, 255));
        this.jLabel3.setText("Status Bar:");
        this.jLabel4.setFont(new Font("Palatino Linotype", 0, 10));
        this.jLabel4.setForeground(new Color(51, 153, 255));
        this.jLabel4.setText("");
        this.jProgressBar1.setForeground(new Color(0, 153, 255));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -1, 376, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, -1, -2)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4)).addComponent(this.jProgressBar1, -2, -1, -2));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(245, 245, 245).addComponent(this.jLabel2))).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(1, 1, 1).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(31, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 659) / 2, (screenSize.height - 563) / 2, 659, 563);
    }

    private void MaxHeightCheckNumber(FocusEvent evt) {
        String XVal = this.jTextField3.getText();
        if (!this.helper.checkInteger(XVal)) {
            this.jTextField3.setText("600");
            JOptionPane.showMessageDialog(this.jPanel1, "Setting Maximum Height 600");
        }
    }

    private void MaxWidthCheckNumber(FocusEvent evt) {
        String XVal = this.jTextField4.getText();
        if (!this.helper.checkInteger(XVal)) {
            JOptionPane.showMessageDialog(this.jPanel1, "Setting Maximum Height 800");
            this.jTextField4.setText("800");
        }
    }

    private void jButton1ActionPerformed1(MouseEvent evt) {
        this.browsInputImage();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.browsInputImage();
    }

    public void setFileList() {
        if (!this.inputFileList.isEmpty()) {
            this.jFileListPanel = new JPanel[this.inputFileList.size()];
            this.jFileListLabel = new JLabel[this.inputFileList.size()];
            this.jFileListLabelCount = new JLabel[this.inputFileList.size()];
            this.jFileListLabelStatus = new JLabel[this.inputFileList.size()];
            this.jPanel11.setLayout(new SpringLayout());
            int i = 0;
            RescaleImage previewImage = new RescaleImage();
            Iterator it = this.inputFileList.iterator();
            while (it.hasNext()) {
                String textval = "";
                String[] texts = new String[1];
                this.jFileListPanel[i] = new JPanel();
                this.jFileListPanel[i].setBackground(new Color(51, 51, 51));
                this.jFileListPanel[i].setLayout(new BoxLayout(this.jFileListPanel[i], 0));
                this.jFileListLabel[i] = new JLabel();
                this.jFileListLabelCount[i] = new JLabel();
                this.jFileListLabelStatus[i] = new JLabel();
                BufferedImage source = null;
                URL is = this.getClass().getResource("/image/blank.png");
                try {
                    source = ImageIO.read(is);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                source = previewImage.RescaleImage(this.helper, source, 15.0, 15.0);
                ImageIcon i2i = new ImageIcon(source);
                this.jFileListLabelStatus[i].setIcon(i2i);
                int count = i + 1;
                this.jFileListLabelCount[i].setText("[" + count + "]  ");
                File inputfile = (File)it.next();
                String text = "  " + inputfile.getPath();
                this.jFileListLabel[i].setText(text);
                this.jFileListLabel[i].setBackground(new Color(51, 51, 51));
                this.jFileListLabel[i].setForeground(new Color(255, 153, 0));
                this.jFileListLabelCount[i].setForeground(new Color(255, 153, 0));
                final int index = i;
                this.jFileListLabel[i].addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        WaterMarkGUI.this.SetSelection(evt, index);
                    }
                });
                this.jFileListPanel[i].add(this.jFileListLabelCount[i]);
                this.jFileListPanel[i].add(this.jFileListLabelStatus[i]);
                this.jFileListPanel[i].add(this.jFileListLabel[i]);
                this.jPanel11.add(this.jFileListPanel[i]);
                this.jPanel11.revalidate();
                this.jPanel11.repaint();
                ++i;
            }
            SpringUtilities.makeCompactGrid(this.jPanel11, this.inputFileList.size(), 1, 3, 3, 3, 3);
            this.jFileListPanel[0].setBackground(new Color(255, 255, 153));
            File firstImage = (File)this.inputFileList.get(0);
            BufferedImage image = this.helper.getPreview(firstImage);
            String selectedFilePath = firstImage.getPath();
            if (selectedFilePath.length() > 70) {
                selectedFilePath = selectedFilePath.substring(0, 70) + "...";
            }
            this.jLabel11.setText(selectedFilePath);
            BufferedImage result = previewImage.RescaleImage(this.helper, image, 90.0, 120.0);
            ImageIcon i2i = new ImageIcon(result);
            this.ImagePanel.setIcon(i2i);
            this.jPanel11.repaint();
            this.jPanel11.revalidate();
        }
    }

    private void SetSelection(MouseEvent evt, int index) {
        this.currentIndex = index;
        File firstImage = (File)this.inputFileList.get(index);
        BufferedImage image = this.helper.getPreview(firstImage);
        String selectedFilePath = firstImage.getPath();
        if (selectedFilePath.length() > 70) {
            selectedFilePath = selectedFilePath.substring(0, 70) + "...";
        }
        this.jLabel11.setText(selectedFilePath);
        for (int x = 0; x < this.jFileListPanel.length; ++x) {
            this.jFileListPanel[x].setBackground(new Color(51, 51, 51));
        }
        this.jFileListPanel[index].setBackground(new Color(255, 255, 153));
        RescaleImage previewImage = new RescaleImage();
        BufferedImage result = previewImage.RescaleImage(this.helper, image, 90.0, 120.0);
        ImageIcon i2i = new ImageIcon(result);
        this.ImagePanel.setIcon(i2i);
        this.jPanel11.repaint();
        this.jPanel11.revalidate();
    }

    public void browsInputImage() {
        if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Singe Image")) {
            this.jFileChooser1 = new JFileChooser(".");
            ImagePreviewPanel preview = new ImagePreviewPanel();
            this.jFileChooser1.setAccessory(preview);
            this.jFileChooser1.addPropertyChangeListener(preview);
            ExtensionFileFilter filter1 = new ExtensionFileFilter("Images", this.helper.getImageFormats());
            this.jFileChooser1.setFileFilter(filter1);
            this.jFileChooser1.setMultiSelectionEnabled(false);
            int option = this.jFileChooser1.showOpenDialog(this);
            if (option == 0) {
                String filelist = "Select Image";
                File inputFile = this.jFileChooser1.getSelectedFile();
                this.inputFileList = new ArrayList();
                this.helper.setCompleteImageList(0);
                if (this.helper.checkExtension(inputFile.getName())) {
                    this.inputFileList.add(inputFile);
                    String[] text = new String[1];
                    this.helper.getInputFilesCaption().add(text);
                }
                if (!this.inputFileList.isEmpty()) {
                    this.jProgressBar1.setValue(0);
                    this.helper.setInputFiles(this.inputFileList);
                    filelist = inputFile.getPath();
                    this.jTextField1.setText(filelist);
                    this.jTextField1.setToolTipText(this.jTextField1.getText());
                    this.helper.setInputParentFolderPath(inputFile.getParentFile());
                    this.jPanel11.removeAll();
                    this.setFileList();
                } else {
                    JOptionPane.showMessageDialog(this.jPanel1, "Select Images");
                }
            }
        } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("Multiple Images")) {
            this.helper.setDisable(this);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new MultipleImageAddGUI(WaterMarkGUI.this.helper, WaterMarkGUI.this, WaterMarkGUI.this.jTextField1).setVisible(true);
                }
            });
        } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("All Images in Folder")) {
            this.jFileChooser1 = new JFileChooser();
            this.jFileChooser1.setFileSelectionMode(1);
            int option = this.jFileChooser1.showOpenDialog(this);
            if (option == 0) {
                File inputDirectory = this.jFileChooser1.getSelectedFile();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("Images", this.helper.getImageFormats());
                File[] inputfiles = inputDirectory.listFiles();
                this.inputFileList = new ArrayList();
                this.helper.setCompleteImageList(0);
                for (int i = 0; i < inputfiles.length; ++i) {
                    File file = inputfiles[i];
                    if (!this.helper.checkExtension(file.getName())) continue;
                    this.inputFileList.add(file);
                    String textval = "";
                    String[] text = new String[1];
                    this.helper.getInputFilesCaption().add(text);
                }
                if (!this.inputFileList.isEmpty()) {
                    this.jProgressBar1.setValue(0);
                    this.helper.setInputFiles(this.inputFileList);
                    this.jTextField1.setText(inputDirectory.getPath());
                    this.jTextField1.setToolTipText(this.jTextField1.getText());
                    this.helper.setInputParentFolderPath(inputDirectory);
                    this.jPanel11.removeAll();
                    this.setFileList();
                } else {
                    JOptionPane.showMessageDialog(this.jPanel1, "Folder do not contain any JPEG Image file");
                }
            }
        } else if (this.jComboBox1.getSelectedItem().toString().equalsIgnoreCase("All Images in Folder-Subfolders")) {
            this.jFileChooser1 = new JFileChooser();
            this.jFileChooser1.setFileSelectionMode(1);
            int option = this.jFileChooser1.showOpenDialog(this);
            if (option == 0) {
                File inputDirectory = this.jFileChooser1.getSelectedFile();
                ExtensionFileFilter filter1 = new ExtensionFileFilter("Images", this.helper.getImageFormats());
                this.inputFileList = new ArrayList();
                this.helper.setCompleteImageList(0);
                this.showDir(inputDirectory);
                if (!this.inputFileList.isEmpty()) {
                    this.jProgressBar1.setValue(0);
                    this.helper.setInputFiles(this.inputFileList);
                    this.jTextField1.setText(inputDirectory.getPath());
                    this.jTextField1.setToolTipText(this.jTextField1.getText());
                    this.helper.setInputParentFolderPath(inputDirectory);
                    this.jPanel11.removeAll();
                    this.setFileList();
                } else {
                    JOptionPane.showMessageDialog(this.jPanel1, "Folder do not contain any JPEG Image file");
                }
            }
        }
    }

    private void Preview(ActionEvent evt) {
        try {
            if (!this.inputFileList.isEmpty()) {
                final double MaxHeight = Double.parseDouble(this.jTextField3.getText());
                final double MaxWidth = Double.parseDouble(this.jTextField4.getText());
                final int index = this.currentIndex;
                this.helper.setDisable(this);
                this.helper.setDisable(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new PreviewGUI(WaterMarkGUI.this.helper, MaxHeight, MaxWidth, index).setVisible(true);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showDir(File file) {
        if (this.helper.checkExtension(file.getName())) {
            this.inputFileList.add(file);
            String textval = "";
            String[] text = new String[1];
            this.helper.getInputFilesCaption().add(text);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.showDir(files[i]);
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.browsOutputImage();
    }

    private void BrowsOutput(MouseEvent evt) {
        this.browsOutputImage();
    }

    public void browsOutputImage() {
        this.jFileChooser2 = new JFileChooser();
        this.jFileChooser2.setFileSelectionMode(1);
        int option = this.jFileChooser2.showOpenDialog(this);
        if (option == 0) {
            this.outputImage = this.jFileChooser2.getSelectedFile();
            this.jTextField2.setText(this.outputImage.getPath());
            this.jTextField2.setToolTipText(this.jTextField2.getText());
        }
    }

    private void addWaterMarkers(ActionEvent evt) {
        if (!this.inputFileList.isEmpty()) {
            this.helper.setDisable(this);
            if (this.jComboBox3.getSelectedItem().toString().equalsIgnoreCase("Text")) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new TextGUI(WaterMarkGUI.this.helper).setVisible(true);
                    }
                });
            } else if (this.jComboBox3.getSelectedItem().toString().equalsIgnoreCase("Image")) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new ImageGUI(WaterMarkGUI.this.helper).setVisible(true);
                    }
                });
            } else if (this.jComboBox3.getSelectedItem().toString().equalsIgnoreCase("Caption")) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new CaptionGUI(WaterMarkGUI.this.helper).setVisible(true);
                    }
                });
            } else if (this.jComboBox3.getSelectedItem().toString().equalsIgnoreCase("Shape")) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new ShapeGUI(WaterMarkGUI.this.helper).setVisible(true);
                    }
                });
            }
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, "Choose Image/Images to watermark");
        }
    }

    private void reset(ActionEvent evt) {
        this.reset();
        this.jProgressBar1.setValue(0);
        this.helper.getMainStatus().setText("Reset Successful");
    }

    public void reset() {
        this.helper.readPropertyFile();
        this.helper.setMainFrame(this);
        this.helper.setMainPanel(this.jPanel1);
        this.helper.setMainProgressBar(this.jProgressBar1);
        this.helper.setMainStatus(this.jLabel4);
        this.helper.setMainWaterMarksDetails(this.jPanel10);
        this.helper.setInPutImageTextField(this.jTextField1);
        this.helper.setOutPutImageTextField(this.jTextField2);
        this.helper.setOutputFolderName(this.helper.getDate());
        this.helper.setInputFiles(new ArrayList());
        this.helper.setInputFilesCaption(new ArrayList());
        this.worker = new Thread(new WaterMarkImages(this.helper, this.jFileListLabelStatus));
        this.helper.setWorker(this.worker);
        this.helper.setStop(false);
        this.helper.setPause(false);
        this.helper.setLogParam();
        this.helper.setExtensions();
        this.helper.setImageFormats();
        this.jTextField3.setText("600");
        this.jTextField4.setText("800");
        this.jTextField1.setText("Select Images");
        this.jTextField2.setText("Output Folder");
        this.outputImage = null;
        this.jComboBox1.setSelectedIndex(0);
        this.jComboBox2.setSelectedIndex(0);
        this.jComboBox3.setSelectedIndex(0);
        this.inputFileList = new ArrayList();
        this.helper.setWaterMarkerList(new ArrayList());
        this.jPanel11.removeAll();
        this.jPanel11.repaint();
        this.jPanel11.revalidate();
        this.ImagePanel.setIcon(null);
        this.ImagePanel.setText("");
        this.ImagePanel.repaint();
        this.ImagePanel.revalidate();
        this.jLabel11.setText("");
        this.jComboBox1.setEnabled(true);
        this.helper.setInputFiles(this.inputFileList);
        this.helper.setInputFiles(new ArrayList());
        this.helper.setOutputImageFolderPath(this.outputImage);
        this.helper.setMaxImageHeight(600.0);
        this.helper.setMaxImageWidth(800.0);
        this.helper.setWorker(this.worker);
        this.helper.setStop(false);
        this.helper.setPause(false);
        this.helper.setLosseless(true);
    }

    private void Stop(ActionEvent evt) {
        if (this.helper.getWorker() != null && this.helper.getWorker().isAlive()) {
            this.helper.setStop(true);
            this.helper.setPause(false);
            this.helper.getMainStatus().setText("Watermarking Stopping...");
            this.inputFileList = new ArrayList();
            this.jTextField3.setText("Select Image");
        }
    }

    private void Pause(ActionEvent evt) {
        if (this.helper.getWorker() != null && this.helper.getWorker().isAlive()) {
            this.helper.setPause(true);
            this.helper.getMainStatus().setText("Watermarking Pausing...");
        }
    }

    private void Start(ActionEvent evt) {
        if (!this.inputFileList.isEmpty()) {
            if (this.outputImage != null) {
                if (Integer.parseInt(this.jTextField3.getText()) > 9 || Integer.parseInt(this.jTextField4.getText()) > 9) {
                    this.jLabel4.setText("Adding Watermark in Process...");
                    try {
                        this.helper.setInputFiles(this.inputFileList);
                        this.helper.setOutputImageFolderPath(this.outputImage);
                        this.helper.setMaxImageHeight(Integer.parseInt(this.jTextField3.getText()));
                        this.helper.setMaxImageWidth(Integer.parseInt(this.jTextField4.getText()));
                        this.jProgressBar1.setMaximum(this.inputFileList.size());
                        this.jProgressBar1.setMinimum(0);
                        this.jProgressBar1.setValue(0);
                        this.jProgressBar1.setStringPainted(true);
                        this.helper.createReportFile();
                        WaterMarkImages wmImage = new WaterMarkImages(this.helper, this.jFileListLabelStatus);
                        this.helper.setWorker(new Thread(wmImage));
                        this.helper.setPause(false);
                        this.helper.setStop(false);
                        this.helper.getWorker().start();
                        if (this.jComboBox2.getSelectedIndex() == 0) {
                            this.helper.setLosseless(true);
                        } else if (this.jComboBox2.getSelectedIndex() == 1) {
                            this.helper.setLosseless(false);
                        }
                    }
                    catch (Exception ex) {
                        this.helper.getMainStatus().setText("Problem while watermarking ");
                        JOptionPane.showMessageDialog(this.jPanel1, ex, "Exception Raised", 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.jPanel1, "Height and Width cannot be less than 10 pixals");
                }
            } else {
                JOptionPane.showMessageDialog(this.jPanel1, "Choose output folder");
            }
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, "Choose Image/Images to watermark");
        }
    }

    private void importSettingsAction(ActionEvent evt) {
        if (!this.inputFileList.isEmpty()) {
            File inPutPropertyFile;
            String fileName;
            String fileExtension;
            this.jFileChooser1 = new JFileChooser(".");
            ExtensionFileFilter filter1 = new ExtensionFileFilter("XML", new String[]{"XML"});
            this.jFileChooser1.setFileFilter(filter1);
            this.jFileChooser1.setMultiSelectionEnabled(false);
            int option = this.jFileChooser1.showOpenDialog(this);
            if (option == 0 && (fileExtension = (fileName = (inPutPropertyFile = this.jFileChooser1.getSelectedFile()).getName()).substring(fileName.length() - 4, fileName.length())).equalsIgnoreCase(".xml")) {
                ImportXML imXML = new ImportXML();
                ArrayList watermarkerList = imXML.importXML(this.helper, inPutPropertyFile);
                if (Boolean.parseBoolean(watermarkerList.get(0).toString())) {
                    this.helper.readPropertyFile();
                    this.helper.setMainFrame(this);
                    this.helper.setMainPanel(this.jPanel1);
                    this.helper.setMainProgressBar(this.jProgressBar1);
                    this.helper.setMainStatus(this.jLabel4);
                    this.helper.setMainWaterMarksDetails(this.jPanel10);
                    this.helper.setInPutImageTextField(this.jTextField1);
                    this.helper.setOutPutImageTextField(this.jTextField2);
                    this.helper.setOutputFolderName(this.helper.getDate());
                    this.worker = new Thread(new WaterMarkImages(this.helper, this.jFileListLabelStatus));
                    this.helper.setWorker(this.worker);
                    this.helper.setStop(false);
                    this.helper.setPause(false);
                    this.helper.setLogParam();
                    this.helper.setExtensions();
                    this.helper.setImageFormats();
                    this.jTextField1.setText("Select Folder");
                    this.jTextField2.setText("Output Folder");
                    this.jComboBox2.setSelectedItem(watermarkerList.get(3).toString());
                    this.jTextField3.setText(watermarkerList.get(1).toString());
                    this.jTextField4.setText(watermarkerList.get(2).toString());
                    this.helper.setWaterMarkerList((ArrayList)watermarkerList.get(4));
                    this.helper.setWaterMarkDetails();
                    this.helper.setMaxImageHeight(Integer.parseInt(this.jTextField3.getText()));
                    this.helper.setMaxImageWidth(Integer.parseInt(this.jTextField4.getText()));
                    this.helper.getMainStatus().setText("Import Successful");
                    this.helper.Info("Importing of settings from " + inPutPropertyFile.getPath() + " Successful");
                } else {
                    this.helper.getMainStatus().setText("Import Unsuccessful");
                    JOptionPane.showMessageDialog(this.jPanel1, "Error in Imported file\nImport Unsuccessful");
                    this.reset();
                    this.jProgressBar1.setValue(0);
                    this.helper.Info("Importing of settings from " + inPutPropertyFile.getPath() + " Unsuccessful");
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, "Choose Image/Images to watermark");
        }
    }

    private void ExportSettingsAction(ActionEvent evt) {
        if (this.outputImage != null) {
            ExportXML ex = new ExportXML();
            this.helper.setOutputImageFolderPath(this.outputImage);
            try {
                ex.ExportXML(this.helper, this.outputImage, this.jTextField3.getText(), this.jTextField4.getText(), this.jComboBox2.getSelectedItem().toString());
                this.helper.getMainStatus().setText("Exporting of Settings Successful");
                JOptionPane.showMessageDialog(this.jPanel1, "Exporting of Settings File \n" + this.helper.getOutputImageFolderPath().getPath() + File.separator + this.helper.getOutputFolderName() + File.separator + "Watermark Export file.xml\nSuccessful");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.jPanel1, exception.getMessage());
                this.helper.getMainStatus().setText("Exporting of Settings Unsuccessful");
                this.helper.Info("Export of settings to " + this.helper.getOutputImageFolderPath().getPath() + File.separator + this.helper.getOutputFolderName() + File.separator + "Watermark Export file.xml Successful");
            }
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, "Choose output folder");
        }
    }

    private void exit(ActionEvent evt) {
        if (this.helper.getWorker() != null && this.helper.getWorker().isAlive()) {
            this.helper.getWorker().stop();
        }
        this.helper.warning("Exit");
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new WaterMarkGUI().setVisible(true);
            }
        });
    }
}

