/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.crw;

import it.tidalwave.imageio.io.FileImageInputStream2;
import it.tidalwave.imageio.io.RAWImageInputStreamImpl;
import it.tidalwave.imageio.util.Logger;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class CRWImageInputStream
extends RAWImageInputStreamImpl {
    private static final String CLASS = CRWImageInputStream.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final String[] THM_EXTENSIONS = new String[]{"THM", "Thm", "thm"};
    private ImageInputStream crwInputStream;
    private ImageInputStream thmInputStream;

    public CRWImageInputStream(ImageInputStream delegate) throws IOException {
        super(delegate);
        this.crwInputStream = delegate;
        if (delegate instanceof FileImageInputStream2) {
            String thmPath;
            File file = ((FileImageInputStream2)delegate).getFile();
            File thmFile = null;
            String path = file.getAbsolutePath();
            int i = path.lastIndexOf(46);
            if (i > 0) {
                path = path.substring(0, i + 1);
            }
            for (i = 0; i < THM_EXTENSIONS.length && !(thmFile = new File(thmPath = path + THM_EXTENSIONS[i])).exists(); ++i) {
            }
            if (!thmFile.exists()) {
                logger.warning("File " + thmFile + " does not exist", new Object[0]);
            } else {
                logger.fine("THM file is %s", thmFile);
                this.thmInputStream = new FileImageInputStream(thmFile);
            }
        } else {
            logger.warning("delegate is " + delegate + ", won't be able to manage .THM file", new Object[0]);
        }
    }

    public void switchToCRWStream() {
        this.delegate = this.crwInputStream;
    }

    public boolean switchToTHMStream() {
        if (this.thmInputStream != null) {
            this.delegate = this.thmInputStream;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.thmInputStream != null) {
                this.thmInputStream.close();
            }
        }
    }
}

