/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.dng;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;

public class DNGWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = DNGWhiteBalanceOperation.getLogger(DNGWhiteBalanceOperation.class);

    public DNGWhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(PipelineArtifact artifact) {
        TagRational[] asn;
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        if (primaryIFD.isAsShotNeutralAvailable()) {
            asn = primaryIFD.getAsShotNeutral();
            artifact.multiplyRedCoefficient(asn[0].reciprocal().doubleValue());
            artifact.multiplyGreenCoefficient(asn[1].reciprocal().doubleValue());
            artifact.multiplyBlueCoefficient(asn[2].reciprocal().doubleValue());
        }
        if (primaryIFD.isAnalogBalanceAvailable()) {
            asn = primaryIFD.getAnalogBalance();
            artifact.multiplyRedCoefficient(asn[0].reciprocal().doubleValue());
            artifact.multiplyGreenCoefficient(asn[1].reciprocal().doubleValue());
            artifact.multiplyBlueCoefficient(asn[2].reciprocal().doubleValue());
        }
    }
}

