/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.GrayScaleDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.jdraw.gui.undo.Undoable;
import jdomain.util.Log;

public final class GrayScaleAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private boolean brightenPixel;
    private int percentage;

    protected GrayScaleAction() {
        super("Grayscale...");
        this.setToolTipText("Grayscales the current frame");
    }

    public boolean prepareAction() {
        GrayScaleDialog grayScaleDialog = new GrayScaleDialog();
        grayScaleDialog.open();
        if (grayScaleDialog.getResult() == 1) {
            this.percentage = grayScaleDialog.getPercentage();
            this.brightenPixel = grayScaleDialog.brightenPixels();
            return true;
        }
        return false;
    }

    public void startAction() {
        Image image = FolderPanel.INSTANCE.createOffScreenImage();
        GrayFilter grayFilter = new GrayFilter(this.brightenPixel, this.percentage);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        DrawPixel drawPixel = Undoable.calculateDifference(Tool.getCurrentFrame(), image, 0, 0, Tool.getPictureWidth(), Tool.getPictureHeight());
        if (drawPixel.isValid()) {
            UndoManager.INSTANCE.addUndoable(drawPixel);
            drawPixel.redo();
        }
    }

    public void finishAction() {
        Log.info("Grayscaled.");
    }
}

