/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import jdomain.jdraw.Main;
import jdomain.jdraw.data.ColourSettings;
import jdomain.jdraw.data.DataObject;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.gio.ImageReader;
import jdomain.jdraw.gio.PNGWriter;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;

public final class Picture
extends DataObject {
    private static final long serialVersionUID = 0L;
    public static Rectangle geometry = null;
    private int background = 0;
    private int currentFrame = -1;
    private int foreground = 1;
    private final ArrayList frames = new ArrayList();
    private Palette palette;
    private int pictureBackground = 0;
    private int transparent = -1;
    private int width;
    private int height;

    public Picture(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public static Picture createDefaultPicture() {
        Picture picture = Picture.createPicture(32, 32);
        picture.setPalette(Palette.createDefaultPalette(picture));
        picture.setBackground(0);
        picture.setForeground(64);
        return picture;
    }

    protected void rebuildColourMaps() {
        Palette[] paletteArray = this.getPalettes();
        int n = paletteArray.length;
        Log.debug("Rebuilding colour maps...");
        for (int i = 0; i < n; ++i) {
            paletteArray[i].rebuildColourMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scale(Dimension dimension, int n) {
        Frame frame;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n2 = this.getFrameCount();
        ArrayList<Frame> arrayList = new ArrayList<Frame>(n2);
        for (int i = 0; i < n2; ++i) {
            try {
                frame = this.getFrame(i).copy(this);
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (PNGWriter.writePNG(frame, (OutputStream)byteArrayOutputStream)) {
                    ImageIcon imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
                    GUIUtil.waitForImage(imageIcon);
                    imageIcon = ResourceLoader.scaleImage(imageIcon, dimension, n);
                    Picture picture = ImageReader.readImage(imageIcon);
                    Frame frame2 = picture.getFrame(0);
                    frame2.setPalette(picture.getPalette());
                    frame2.setTransparent(picture.getTransparent());
                    arrayList.add(frame2);
                    frame2.getSettings().setFrom(frame.getSettings());
                } else {
                    Log.error("Scaling failed. Internal error.");
                }
                Util.close(byteArrayOutputStream);
            }
            catch (Exception exception) {
                Log.exception(exception);
            }
            finally {
                Util.close(byteArrayOutputStream);
            }
            continue;
        }
        Picture picture = new Picture(dimension.width, dimension.height);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            frame = (Frame)iterator.next();
            picture.addFrame(frame);
            frame.getSettings().adjust(dimension.width, dimension.height);
        }
        picture.setCurrentFrame(0);
        frame = picture.getFrame(0);
        picture.setTransparent(frame.getTransparentColour());
        picture.setPalette(frame.getPalette());
        Main.setPicture(picture);
    }

    public static Picture createPicture(int n, int n2) {
        Picture picture = new Picture(n, n2);
        picture.setPalette(new Palette(picture));
        picture.addFrame();
        return picture;
    }

    public boolean crop(int n, int n2, int n3, int n4) {
        if (n != 0 || n2 != 0 || n3 != this.getWidth() || n4 != this.getHeight()) {
            Log.debug("cropping to " + n + "," + n2 + "," + n3 + "x" + n4);
            int n5 = this.getFrameCount();
            for (int i = 0; i < n5; ++i) {
                this.getFrame(i).crop(n, n2, n3, n4);
            }
            this.width = n3;
            this.height = n4;
            this.notifyDataListeners(new ChangeEvent(this, 34));
            return true;
        }
        return false;
    }

    public Frame addFrame() {
        return this.addFrame(this.frames.size());
    }

    public void removeAlphaChannel() {
        Picture.surpressGUIEvents(this);
        Palette[] paletteArray = this.getPalettes();
        int n = paletteArray.length;
        for (int i = 0; i < n; ++i) {
            paletteArray[i].removeAlphaValues();
        }
        Picture.allowGUIEvents(this);
    }

    public void addFrame(Frame frame) {
        this.frames.add(frame);
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 30, this.getFrameCount() - 1));
    }

    public Frame addFrame(int n) {
        Frame frame = new Frame(this);
        this.frames.add(n, frame);
        if (this.transparent < this.palette.size()) {
            frame.setPalette(null, this.transparent);
        } else {
            frame.setPalette(null, -1);
        }
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 30, n));
        this.setCurrentFrame(n);
        return frame;
    }

    public int compress() {
        boolean bl;
        Picture.surpressGUIEvents(this);
        int n = this.countColours();
        Palette[] paletteArray = this.getPalettes();
        boolean bl2 = false;
        int n2 = paletteArray.length;
        do {
            bl = false;
            for (int i = 0; i < n2; ++i) {
                Palette palette = paletteArray[i];
                bl = palette.compress(this.findFramesWithPalette(palette)) || bl;
                bl2 = bl || bl2;
            }
        } while (bl);
        if (bl2) {
            Picture.allowGUIEvents(this);
            return n - this.countColours();
        }
        Picture.allowGUIEvents(this);
        return 0;
    }

    private final boolean containsPalette(ArrayList arrayList, Palette palette) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) != palette) continue;
            return true;
        }
        return false;
    }

    public void show() {
        if (Log.DEBUG) {
            Log.debug("Picture: " + this.width + "x" + this.height);
            Log.debug("Colours: " + this.getMaximalPaletteSize());
            Log.debug(new ColourSettings(this).toString());
        }
    }

    private int countColours() {
        Palette[] paletteArray = this.getPalettes();
        int n = paletteArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += paletteArray[i].size();
        }
        return n2;
    }

    protected Frame[] findFramesWithGlobalPalette() {
        return this.findFramesWithPalette(this.palette);
    }

    protected Frame[] findFramesWithPalette(Palette palette) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        int n = this.getFrameCount();
        for (int i = 0; i < n; ++i) {
            Frame frame = this.getFrame(i);
            if (frame.getPalette() != palette) continue;
            arrayList.add(frame);
        }
        Frame[] frameArray = new Frame[arrayList.size()];
        arrayList.toArray(frameArray);
        return frameArray;
    }

    public int getBackground() {
        return this.background;
    }

    public Frame getCurrentFrame() {
        return this.getFrame(this.currentFrame);
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public Palette getCurrentPalette() {
        return this.getCurrentFrame().getPalette();
    }

    public int getForeground() {
        return this.foreground;
    }

    public Frame getFrame(int n) {
        return (Frame)this.frames.get(n);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    protected int getGlobalTransparent() {
        return this.transparent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaximalPaletteSize() {
        int n = 0;
        int n2 = this.getFrameCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getFrame(i).getPalette().size();
            n = Math.max(n, n3);
        }
        return n;
    }

    public Palette getPalette() {
        return this.palette;
    }

    private Palette[] getPalettes() {
        ArrayList<Palette> arrayList = new ArrayList<Palette>();
        int n = this.getFrameCount();
        for (int i = 0; i < n; ++i) {
            Palette palette = this.getFrame(i).getPalette();
            if (this.containsPalette(arrayList, palette)) continue;
            arrayList.add(palette);
        }
        Palette[] paletteArray = new Palette[arrayList.size()];
        arrayList.toArray(paletteArray);
        return paletteArray;
    }

    public int getPictureBackground() {
        int n;
        if (this.currentFrame != -1 && this.pictureBackground >= (n = this.getCurrentFrame().getPalette().size())) {
            return 0;
        }
        return this.pictureBackground;
    }

    public int getTransparent() {
        if (this.getCurrentFrame().getPalette().isGlobalPalette()) {
            return this.transparent;
        }
        return this.getCurrentFrame().getTransparentColour();
    }

    public int getWidth() {
        return this.width;
    }

    public int indexOf(Frame frame) {
        int n = this.getFrameCount();
        for (int i = 0; i < n; ++i) {
            if (this.getFrame(i) != frame) continue;
            return i;
        }
        return -1;
    }

    public int reduceColours(int n) {
        Picture.surpressGUIEvents(this);
        int n2 = this.countColours();
        Palette[] paletteArray = this.getPalettes();
        int n3 = paletteArray.length;
        for (int i = 0; i < n3; ++i) {
            paletteArray[i].reducePalette(n);
        }
        Picture.allowGUIEvents(this);
        return n2 - this.countColours();
    }

    public void removeCurrentFrame() {
        this.removeFrame(this.currentFrame);
    }

    public void removeFrame(int n) {
        Frame frame = (Frame)this.frames.remove(n);
        frame.detach();
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 31, n));
    }

    public void setBackground(int n) {
        if (n != this.background) {
            int n2 = this.background;
            this.background = n;
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 38, n2, this.background));
        }
    }

    public void setCurrentFrame(int n) {
        if (n != this.currentFrame) {
            int n2 = this.currentFrame;
            if (this.currentFrame != -1 && this.currentFrame < this.getFrameCount()) {
                this.getFrame(this.currentFrame).leave();
            }
            this.currentFrame = n;
            this.getFrame(this.currentFrame).enter();
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 32, n2, this.currentFrame));
        }
    }

    public void setForeground(int n) {
        if (n != this.foreground) {
            int n2 = this.foreground;
            this.foreground = n;
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 37, n2, this.foreground));
        }
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
        Frame[] frameArray = this.findFramesWithGlobalPalette();
        int n = frameArray.length;
        for (int i = 0; i < n; ++i) {
            frameArray[i].setPalette(null, this.transparent);
        }
        this.notifyDataListeners(new ChangeEvent(this, 33));
    }

    public void setPictureBackground(int n) {
        if (n != this.pictureBackground) {
            int n2 = this.pictureBackground;
            this.pictureBackground = n;
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 36, n2, n));
        }
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        int n3 = this.getFrameCount();
        for (int i = 0; i < n3; ++i) {
            Frame frame = this.getFrame(i);
            Frame frame2 = new Frame(this);
            frame2.pasteClip(frame, 0, 0);
            frame.setData(frame2.getData());
            frame.getSettings().adjust(n, n2);
        }
        this.notifyDataListeners(new ChangeEvent(this, 34));
    }

    public void setTransparent(int n) {
        if (this.getCurrentFrame().getPalette().isGlobalPalette()) {
            this.transparent = n;
        }
        this.getCurrentFrame().setTransparentColour(n);
    }

    public boolean usesGlobalPalette() {
        int n = this.getFrameCount();
        for (int i = 0; i < n; ++i) {
            Frame frame = this.getFrame(i);
            if (!frame.getPalette().equals(this.palette)) continue;
            return true;
        }
        return false;
    }
}

