/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.ImageReader;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;

public final class PNGWriter {
    private static final int[][] INTERLACED_PATTERN = new int[][]{{1, 6, 4, 6, 2, 6, 4, 6}, {7, 7, 7, 7, 7, 7, 7, 7}, {5, 6, 5, 6, 5, 6, 5, 6}, {7, 7, 7, 7, 7, 7, 7, 7}, {3, 6, 4, 6, 3, 6, 4, 6}, {7, 7, 7, 7, 7, 7, 7, 7}, {5, 6, 5, 6, 5, 6, 5, 6}, {7, 7, 7, 7, 7, 7, 7, 7}};
    private static final int[] Y_OFFSET = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    private static final int MAX_LOOP = 7;
    private final Picture picture;
    private final OutputStream out;
    private final Frame frame;
    private final Palette pal;
    private final CRC32 crc32 = new CRC32();
    private final int transIndex;
    private final int transColourCount;
    private final boolean interlaced;
    private int bitDepth;
    private int colourType;
    private int colourLength;
    final int width;
    final int height;
    private int[] scanline;
    private byte[] rgbScanline;
    private int x = 0;
    private int y = 0;
    private int loop = 1;

    private PNGWriter(Picture picture, OutputStream outputStream, boolean bl) {
        this.picture = picture;
        this.interlaced = bl;
        this.frame = this.picture.getCurrentFrame();
        this.pal = this.picture.getCurrentPalette();
        this.width = this.picture.getWidth();
        this.height = this.picture.getHeight();
        this.transIndex = this.picture.getTransparent();
        this.transColourCount = this.pal.countTransparentColours();
        this.out = outputStream;
    }

    public static boolean writePNG(Picture picture, String string, boolean bl) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            PNGWriter pNGWriter = new PNGWriter(picture, bufferedOutputStream, bl);
            pNGWriter.writePNG();
            return true;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return false;
        }
    }

    public static boolean writePNG(Frame frame, OutputStream outputStream) {
        Picture picture = new Picture(frame.getWidth(), frame.getHeight());
        Palette palette = frame.getPalette();
        picture.setPalette(palette);
        frame.setPalette(null);
        picture.addFrame(frame);
        picture.setCurrentFrame(0);
        picture.setTransparent(frame.getTransparentColour());
        return PNGWriter.writePNG(picture, outputStream);
    }

    public static boolean writePNG(Picture picture, String string) {
        return PNGWriter.writePNG(picture, string, false);
    }

    public static boolean writePNG(Picture picture, OutputStream outputStream, boolean bl) {
        try {
            PNGWriter pNGWriter = new PNGWriter(picture, outputStream, bl);
            pNGWriter.writePNG();
            return true;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return false;
        }
    }

    public static boolean writePNG(Picture picture, OutputStream outputStream) {
        return PNGWriter.writePNG(picture, outputStream, false);
    }

    private void nextY() {
        do {
            ++this.y;
            if (this.y >= this.height) continue;
            int[] nArray = INTERLACED_PATTERN[this.y % 8];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != this.loop) continue;
                return;
            }
        } while (this.y < this.height);
        ++this.loop;
        this.y = Y_OFFSET[this.loop - 1];
    }

    private boolean nextX() {
        int n = this.y % 8;
        int[] nArray = INTERLACED_PATTERN[n];
        while (this.x < this.width) {
            int n2 = this.x % 8;
            int n3 = nArray[n2];
            if (this.loop == n3) {
                return true;
            }
            ++this.x;
        }
        this.x = 0;
        this.nextY();
        return false;
    }

    private int nextInterlacedScanline() {
        if (this.loop <= 7) {
            this.scanline[0] = 0;
            int n = 0;
            while (this.nextX()) {
                this.scanline[++n] = this.frame.getPixel(this.x, this.y);
                ++this.x;
            }
            return n + 1;
        }
        return -1;
    }

    private int nextPlainScanline() {
        if (this.y < this.height) {
            this.scanline[0] = 0;
            for (int i = 0; i < this.width; ++i) {
                this.scanline[i + 1] = this.frame.getPixel(i, this.y);
            }
            ++this.y;
            return this.width + 1;
        }
        return -1;
    }

    private int nextScanline() {
        if (this.interlaced) {
            return this.nextInterlacedScanline();
        }
        return this.nextPlainScanline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePNG() throws Exception {
        try {
            this.writeSignature();
            this.writeHeader();
            this.scanline = new int[this.width + 1];
            if (this.colourType == 3) {
                this.writePalette();
                this.writeIndexedBackground();
                if (this.transColourCount > 0) {
                    this.writeIndexedTransparency();
                }
                this.writeIndexedImageData();
            } else if (this.colourType == 2) {
                this.writeRGBBackground();
                this.writeRGBImageData(false);
            } else {
                this.writeRGBBackground();
                this.writeRGBImageData(true);
            }
            this.writeFooter();
        }
        finally {
            this.out.flush();
            Util.close(this.out);
        }
    }

    private void writeIndexedBackground() throws Exception {
        this.writeLong(1L);
        this.crc32.reset();
        this.writeBytes("bKGD".getBytes());
        this.writeByte(this.picture.getBackground());
        this.writeCRC();
    }

    private void writeRGBBackground() throws Exception {
        this.writeLong(6L);
        this.crc32.reset();
        this.writeBytes("bKGD".getBytes());
        Color color = this.pal.getColour(this.picture.getPictureBackground()).getColour();
        this.writeByte(0);
        this.writeByte(color.getRed());
        this.writeByte(0);
        this.writeByte(color.getGreen());
        this.writeByte(0);
        this.writeByte(color.getBlue());
        this.writeCRC();
    }

    private void writeIndexedTransparency() throws Exception {
        int n = this.pal.getLastTransparentColour();
        this.writeLong(n + 1);
        this.crc32.reset();
        this.writeBytes("tRNS".getBytes());
        int n2 = this.picture.getTransparent();
        for (int i = 0; i <= n; ++i) {
            if (i == n2) {
                this.writeByte(0);
                continue;
            }
            this.writeByte(this.pal.getColour(i).getColour().getAlpha());
        }
        this.writeCRC();
    }

    private void writeFooter() throws Exception {
        this.writeLong(0L);
        this.crc32.reset();
        this.writeBytes("IEND".getBytes());
        this.writeCRC();
    }

    private void writeIndexedImageData() throws Exception {
        byte[] byArray = this.getIndexedImageData();
        this.writeLong(byArray.length);
        this.crc32.reset();
        this.writeBytes("IDAT".getBytes());
        this.writeBytes(byArray);
        this.writeCRC();
    }

    private void writeRGBImageData(boolean bl) throws Exception {
        byte[] byArray = this.getRGBImageData(bl);
        this.writeLong(byArray.length);
        this.crc32.reset();
        this.writeBytes("IDAT".getBytes());
        this.writeBytes(byArray);
        this.writeCRC();
    }

    private byte[] getIndexedImageData() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        Deflater deflater = new Deflater(9);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        int n = 0;
        do {
            if ((n = this.nextScanline()) == -1) continue;
            for (int i = 0; i < n; ++i) {
                deflaterOutputStream.write((byte)this.scanline[i]);
            }
        } while (n != -1);
        deflaterOutputStream.finish();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        deflaterOutputStream.close();
        return byArray;
    }

    private void nextRGBScanline(int n) {
        this.rgbScanline[0] = 0;
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i * this.colourLength;
            int n3 = this.scanline[i + 1];
            Color color = this.pal.getColour(n3).getColour();
            this.rgbScanline[n2 + 1] = (byte)color.getRed();
            this.rgbScanline[n2 + 2] = (byte)color.getGreen();
            this.rgbScanline[n2 + 3] = (byte)color.getBlue();
            if (this.colourLength != 4) continue;
            this.rgbScanline[n2 + 4] = (byte)(n3 == this.transIndex ? 0 : color.getAlpha());
        }
    }

    private byte[] getRGBImageData(boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        Deflater deflater = new Deflater(9);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        this.colourLength = 3;
        if (bl) {
            this.colourLength = 4;
        }
        this.rgbScanline = new byte[this.width * this.colourLength + 1];
        int n = 0;
        do {
            if ((n = this.nextScanline()) == -1) continue;
            this.nextRGBScanline(n);
            int n2 = (n - 1) * this.colourLength + 1;
            deflaterOutputStream.write(this.rgbScanline, 0, n2);
        } while (n != -1);
        deflaterOutputStream.finish();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        deflaterOutputStream.close();
        return byArray;
    }

    private void writeHeader() throws Exception {
        this.writeLong(13L);
        this.crc32.reset();
        this.writeBytes("IHDR".getBytes());
        this.writeLong(this.picture.getWidth());
        this.writeLong(this.picture.getHeight());
        this.bitDepth = 8;
        this.colourType = 3;
        if (this.pal.size() > 256) {
            this.bitDepth = 8;
            this.colourType = this.transColourCount > 0 ? 6 : 2;
        }
        this.writeByte(this.bitDepth);
        this.writeByte(this.colourType);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(this.interlaced ? 1 : 0);
        this.writeCRC();
    }

    private void writePalette() throws Exception {
        int n = this.pal.size();
        this.writeLong(3 * n);
        this.crc32.reset();
        this.writeBytes("PLTE".getBytes());
        for (int i = 0; i < n; ++i) {
            Color color = this.pal.getColour(i).getColour();
            this.writeByte(color.getRed());
            this.writeByte(color.getGreen());
            this.writeByte(color.getBlue());
        }
        this.writeCRC();
    }

    private void writeCRC() throws Exception {
        long l = this.crc32.getValue();
        this.writeLong(l);
    }

    private void writeSignature() throws Exception {
        int[] nArray = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        for (int i = 0; i < nArray.length; ++i) {
            this.out.write(nArray[i]);
        }
    }

    private void writeBytes(byte[] byArray) throws Exception {
        this.out.write(byArray);
        this.crc32.update(byArray);
    }

    private void writeByte(int n) throws Exception {
        this.out.write(n);
        this.crc32.update((byte)n);
    }

    private void writeLong(long l) throws Exception {
        byte by = (byte)(l >> 24);
        byte by2 = (byte)(l >> 16);
        byte by3 = (byte)(l >> 8);
        byte by4 = (byte)l;
        this.writeByte(by);
        this.writeByte(by2);
        this.writeByte(by3);
        this.writeByte(by4);
    }

    public static void main(String[] stringArray) {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Picture picture = ImageReader.readImage("C:/Java/Projects/JDraw/sheep.png");
        Log.addLogListener(simpleLogListener);
        if (picture != null) {
            PNGWriter.writePNG(picture, "test.png");
            Log.debug("OK");
        }
    }
}

