/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.io.File;
import jdomain.jdraw.gui.ICOHandler;
import jdomain.jdraw.gui.JDHandler;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.gui.BrowserFilter;
import jdomain.util.gui.FileBrowser;
import jdomain.util.gui.IconViewer;

public final class DrawBrowser
extends FileBrowser {
    private static final long serialVersionUID = 1L;
    public static final DrawBrowser INSTANCE = new DrawBrowser();
    private static final String[] PALLETTE_EXTENSIONS = new String[]{".pal"};
    private static final String[] ICO_EXTENSIONS = new String[]{".ico"};
    private static final String[] GIF_EXTENSIONS = new String[]{".gif"};
    private static final String[] GIF_INTERLACED_EXTENSIONS = new String[]{".gif"};
    private static final String[] PNG_EXTENSIONS = new String[]{".png"};
    private static final String[] JPEG_EXTENSIONS = new String[]{".jpg", ".jpeg"};
    private static final String[] DRAW_EXTENSIONS = new String[]{".jd"};
    private static final BrowserFilter PAL_FILTER = BrowserFilter.createFilter("Palettes", PALLETTE_EXTENSIONS);
    public static final BrowserFilter ICO_FILTER = BrowserFilter.createFilter("ICO Images", ICO_EXTENSIONS);
    public static final BrowserFilter GIF_FILTER = BrowserFilter.createFilter("GIF Images", GIF_EXTENSIONS);
    public static final BrowserFilter GIF_INTERLACED_FILTER = BrowserFilter.createFilter("GIF Images (Interlaced)", GIF_INTERLACED_EXTENSIONS);
    public static final BrowserFilter PNG_FILTER = BrowserFilter.createFilter("PNG Images", PNG_EXTENSIONS);
    public static final BrowserFilter PNG_INTERLACED_FILTER = BrowserFilter.createFilter("PNG Images (Interlaced)", PNG_EXTENSIONS);
    public static final BrowserFilter JPG_FILTER = BrowserFilter.createFilter("JPEG Images", JPEG_EXTENSIONS);
    public static final BrowserFilter DRAW_FILTER = BrowserFilter.createFilter("JDraw Images", DRAW_EXTENSIONS);
    public static final BrowserFilter ALL_IMAGES_READ_FILTER = BrowserFilter.createFilter("All Images", DRAW_EXTENSIONS);
    private static final BrowserFilter ALL_IMAGES_WRITE_FILTER = BrowserFilter.createFilter("All Images", GIF_EXTENSIONS);
    private static final int UNDEFINED_MODE = 0;
    private static final int SAVING_IMAGE = 1;
    private static final int SAVING_PALETTE = 2;
    private int mode = 0;

    private DrawBrowser() {
        this.setAcceptAllFileFilterUsed(false);
        IconViewer.addImageHandler(new ICOHandler());
        IconViewer.addImageHandler(new JDHandler());
    }

    public final File openImage() {
        BrowserFilter[] browserFilterArray = new BrowserFilter[]{DRAW_FILTER, GIF_FILTER, ICO_FILTER, JPG_FILTER, PNG_FILTER};
        File file = this.open(MainFrame.INSTANCE, "Open Image...", browserFilterArray, ALL_IMAGES_READ_FILTER, true);
        return file;
    }

    public final File openPalette() {
        BrowserFilter[] browserFilterArray = new BrowserFilter[]{PAL_FILTER};
        File file = this.open(MainFrame.INSTANCE, "Open Palette...", browserFilterArray, null, true);
        return file;
    }

    public final File savePalette() {
        this.mode = 2;
        BrowserFilter[] browserFilterArray = new BrowserFilter[]{PAL_FILTER};
        File file = this.open(MainFrame.INSTANCE, "Save Palette...", browserFilterArray, null, true);
        this.mode = 0;
        return file;
    }

    public final boolean saveInterlaced() {
        boolean bl = this.getFileFilter() == GIF_INTERLACED_FILTER || this.getFileFilter() == PNG_INTERLACED_FILTER;
        return bl;
    }

    public final File saveImage() {
        this.mode = 1;
        BrowserFilter[] browserFilterArray = new BrowserFilter[]{DRAW_FILTER, GIF_FILTER, GIF_INTERLACED_FILTER, ICO_FILTER, JPG_FILTER, PNG_FILTER, PNG_INTERLACED_FILTER};
        File file = this.save(MainFrame.INSTANCE, "Save Image...", browserFilterArray, ALL_IMAGES_WRITE_FILTER, true);
        this.mode = 0;
        return file;
    }

    protected boolean hasValidExtension(File file, BrowserFilter browserFilter) {
        switch (this.mode) {
            case 1: {
                if (ALL_IMAGES_WRITE_FILTER != null) {
                    return ALL_IMAGES_WRITE_FILTER.accept(file);
                }
            }
            case 2: {
                return PAL_FILTER.accept(file);
            }
        }
        return super.hasValidExtension(file, browserFilter);
    }

    protected String adjustFilename(String string, BrowserFilter browserFilter) {
        String string2 = super.adjustFilename(string, browserFilter);
        if (string2.length() > 0) {
            string2 = string2 + browserFilter.getFirstExtension();
        }
        return string2;
    }

    static {
        ALL_IMAGES_READ_FILTER.addExtensions(GIF_EXTENSIONS);
        ALL_IMAGES_READ_FILTER.addExtensions(ICO_EXTENSIONS);
        ALL_IMAGES_READ_FILTER.addExtensions(JPEG_EXTENSIONS);
        ALL_IMAGES_READ_FILTER.addExtensions(PNG_EXTENSIONS);
        ALL_IMAGES_WRITE_FILTER.addExtensions(DRAW_EXTENSIONS);
        ALL_IMAGES_WRITE_FILTER.addExtensions(ICO_EXTENSIONS);
        ALL_IMAGES_WRITE_FILTER.addExtensions(JPEG_EXTENSIONS);
        ALL_IMAGES_WRITE_FILTER.addExtensions(PNG_EXTENSIONS);
    }
}

