/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLayeredPane;
import javax.swing.Scrollable;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.gui.ClipPanel;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.GridListener;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;

public class DrawLayers
extends JLayeredPane
implements Scrollable,
GridListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    public static final Integer DRAW_LAYER = new Integer(0);
    public static final Integer CLIP_TOOL_LAYER = new Integer(1);
    public static final Integer INFO_CLIP_LAYER = new Integer(2);
    private final DrawPanel drawPanel = new DrawPanel();
    private int unit = Tool.getGrid();
    private int blocks = 50;
    private boolean forceWidth = false;
    private boolean forceHeight = false;

    public DrawLayers() {
        this.setOpaque(false);
        this.add((Component)this.drawPanel, DRAW_LAYER);
        FolderPanel.addGridListener(this);
        this.drawPanel.addComponentListener(this);
    }

    public void gridChanged(int n, int n2) {
        this.unit = n2;
        this.drawPanel.setPreferredSize(this.drawPanel.getPreferredSize());
    }

    public ClipPanel getClipPanel() {
        Assert.isTrue(this.getComponentCountInLayer(CLIP_TOOL_LAYER) == 1, "gui: clip panel undefined");
        return (ClipPanel)this.getComponentsInLayer(CLIP_TOOL_LAYER)[0];
    }

    protected DrawPanel getDrawPanel() {
        return this.drawPanel;
    }

    public Dimension getPreferredSize() {
        return this.drawPanel.getPreferredSize();
    }

    protected void setDrawClip(Clip clip) {
        this.drawPanel.setClip(clip);
        Dimension dimension = this.drawPanel.getPreferredSize();
        this.drawPanel.setBounds(0, 0, dimension.width, dimension.height);
    }

    public final Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public final int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.unit;
        }
        return this.unit;
    }

    public final int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.blocks * this.unit;
        }
        return this.blocks * this.unit;
    }

    public final boolean getScrollableTracksViewportHeight() {
        return this.forceHeight;
    }

    public final boolean getScrollableTracksViewportWidth() {
        return this.forceWidth;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setPreferredSize(this.drawPanel.getPreferredSize());
        this.revalidate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

