/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class PcxFile {
    BufferedOutputStream bfout;
    int nline;
    int count;
    int last;
    byte[] scanline;
    int bytes_line = 0;
    int n_color_planes = 0;
    int palette = 1;
    int bits_pixel = 8;

    void store(int n) {
        try {
            this.scanline[this.nline++] = (byte)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("s1" + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    void store(int n, int n2) {
        try {
            this.scanline[n * this.bytes_line + (this.nline - 1)] = (byte)n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("s2" + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    void write(int n) throws IOException {
        this.bfout.write(n);
    }

    void writeLine() throws IOException {
        this.count = 1;
        this.last = this.scanline[0];
        int n = 1;
        while (n < this.n_color_planes * this.bytes_line) {
            int n2 = this.scanline[n];
            if (n2 == this.last) {
                ++this.count;
                if (this.count == 63) {
                    this.encode();
                    this.count = 0;
                }
            } else {
                this.encode();
                this.last = n2;
                this.count = 1;
            }
            ++n;
        }
        if (this.count != 0) {
            this.encode();
            this.count = 0;
        }
        this.nline = 0;
    }

    void finish() throws IOException {
        if (this.palette == 2) {
            this.bfout.write(12);
            int n = 0;
            while (n < 256) {
                int n2 = 0;
                while (n2 < 3) {
                    this.bfout.write(n);
                    ++n2;
                }
                ++n;
            }
        }
        this.bfout.close();
    }

    void encode() {
        try {
            if (this.count == 1 && 192 != (0xC0 & this.last)) {
                this.bfout.write(this.last);
            } else {
                this.bfout.write(0xC0 | this.count);
                this.bfout.write(this.last);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("last: " + this.last);
            System.out.println("count: " + this.count);
        }
    }

    void write16(int n) throws IOException {
        this.bfout.write(n & 0xFF);
        this.bfout.write(n >> 8 & 0xFF);
    }

    PcxFile(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            File file = new File(string);
            this.bfout = new BufferedOutputStream(new FileOutputStream(file), 4096);
            this.bfout.write(10);
            this.bfout.write(5);
            this.bfout.write(1);
            if (n == 1) {
                this.bits_pixel = 1;
                this.bytes_line = (n2 + 7) / 8;
            } else {
                this.bits_pixel = 8;
                this.bytes_line = n2;
            }
            if (this.bytes_line % 2 != 0) {
                ++this.bytes_line;
            }
            this.n_color_planes = n == 3 ? 3 : 1;
            this.palette = n == 2 ? 2 : 1;
            this.bfout.write(this.bits_pixel);
            this.write16(0);
            this.write16(0);
            this.write16(n2 - 1);
            this.write16(n3 - 1);
            this.write16(n6);
            this.write16(n5);
            int n7 = 0;
            while (n7 < 49) {
                this.bfout.write(0);
                ++n7;
            }
            this.bfout.write(this.n_color_planes);
            this.write16(this.bytes_line);
            this.write16(this.palette);
            n7 = 0;
            while (n7 < 58) {
                this.bfout.write(0);
                ++n7;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.scanline = new byte[this.n_color_planes * this.bytes_line];
        boolean bl = false;
    }
}

