/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.photometricinterpreters;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public class PhotometricInterpreterPalette
extends PhotometricInterpreter {
    private final int[] fColorMap;

    public PhotometricInterpreterPalette(int fSamplesPerPixel, int[] fBitsPerSample, int Predictor, int width, int height, int[] fColorMap) {
        super(fSamplesPerPixel, fBitsPerSample, Predictor, width, height);
        this.fColorMap = fColorMap;
    }

    public void interpretPixel(BufferedImage bi, int[] samples, int x, int y) throws ImageReadException, IOException {
        int fBitsPerPixel = this.bitsPerSample[0];
        int colormap_scale = 1 << fBitsPerPixel;
        int index = samples[0];
        int red = this.fColorMap[index] >> 8;
        int green = this.fColorMap[index + colormap_scale] >> 8;
        int blue = this.fColorMap[index + 2 * colormap_scale] >> 8;
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        bi.setRGB(x, y, rgb);
    }
}

