/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.camera;

import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.camera.Camera;
import org.gerhardb.jibs.camera.CameraPreferences;
import org.gerhardb.jibs.camera.WorkerCamera;
import org.gerhardb.jibs.util.FileLoopHelper;
import org.gerhardb.lib.swing.JPanelRows;

public class CameraPanel
extends JPanelRows {
    Camera myCamera;
    WorkerCamera myWorker;
    JProgressBar myProgressBar = new JProgressBar();
    JCheckBox myRenameUniqueCheckBox = new JCheckBox(Jibs.getString("CameraPanel.0"));
    JCheckBox myRenameEXIFCheckBox = new JCheckBox(Jibs.getString("CameraPanel.1"));
    JLabel myCurrentAction = new JLabel(Jibs.getString("CameraPanel.2"));
    File myLogFile;
    private static final int DIR_COL_WIDTH = 50;
    JFormattedTextField pictureNumberFld;
    JFormattedTextField logNumberFld;
    JTextField logFld;
    JButton myStartBtn = new JButton(Jibs.getString("CameraPanel.3"));

    public CameraPanel(Camera Camera2) {
        this.myCamera = Camera2;
        this.pictureNumberFld = FileLoopHelper.makeRelabelFld();
        this.logNumberFld = FileLoopHelper.makeRelabelFld();
        this.myRenameEXIFCheckBox.setSelected(CameraPreferences.getExifRenaming());
        if (CameraPreferences.getUniqueRenamingCamera()) {
            this.myRenameUniqueCheckBox.setSelected(true);
            this.pictureNumberFld.setEditable(true);
        } else {
            this.myRenameUniqueCheckBox.setSelected(false);
            this.pictureNumberFld.setEditable(false);
        }
        this.myRenameUniqueCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CameraPanel.this.pictureNumberFld.setEditable(CameraPanel.this.myRenameUniqueCheckBox.isSelected());
            }
        });
        this.pictureNumberFld.setValue(new Integer(CameraPreferences.getRelabelNumber()));
        this.pictureNumberFld.setColumns(10);
        this.logNumberFld.setValue(new Integer(CameraPreferences.getNextLogNumber()));
        this.logNumberFld.setColumns(10);
        this.logFld = new JTextField(CameraPreferences.getLogDirectory());
        this.logFld.setColumns(50);
        this.logFld.setToolTipText(Jibs.getString("CameraPanel.4") + Jibs.getString("CameraPanel.5"));
        JPanelRows renamePanel = new JPanelRows();
        renamePanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("CameraPanel.6"), 1, 2));
        JPanel aRow = renamePanel.topRow();
        aRow.add(this.myRenameEXIFCheckBox);
        aRow.add(new JLabel(Jibs.getString("CameraPanel.7")));
        aRow = renamePanel.nextRow();
        aRow.add(this.myRenameUniqueCheckBox);
        aRow.add(new JLabel(Jibs.getString("CameraPanel.9") + Jibs.getString("colon") + " "));
        aRow.add(this.pictureNumberFld);
        JButton btnLog = new JButton("...");
        btnLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = CameraPanel.this.logFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = CameraPanel.this.lookupDir(Jibs.getString("CameraPanel.12"), dir);
                CameraPanel.this.logFld.setText(dir);
                CameraPreferences.setLogDirectory(dir);
            }
        });
        JPanelRows logPanel = new JPanelRows();
        logPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), Jibs.getString("CameraPanel.13"), 1, 2));
        aRow = logPanel.topRow();
        aRow.add(new JLabel(Jibs.getString("CameraPanel.14") + Jibs.getString("colon") + " "));
        aRow.add(this.logNumberFld);
        aRow = logPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("CameraPanel.15") + Jibs.getString("colon") + " "));
        aRow.add(this.logFld);
        aRow.add(btnLog);
        aRow = this.topRow();
        aRow.add(renamePanel);
        aRow = this.nextRow();
        aRow.add(logPanel);
        aRow = this.nextRow();
        aRow.add(this.layoutAction());
    }

    private JPanel layoutAction() {
        final JButton btnStop = new JButton(Jibs.getString("CameraPanel.16"));
        final JButton btnReport = new JButton(Jibs.getString("report"));
        btnReport.setEnabled(false);
        JPanelRows rowMaker = new JPanelRows();
        JPanel currentRow = rowMaker.topRow();
        currentRow.add(this.myStartBtn);
        currentRow.add(btnStop);
        currentRow.add(btnReport);
        currentRow = rowMaker.nextRow();
        currentRow.add(new JLabel("  " + Jibs.getString("CameraPanel.18") + Jibs.getString("colon") + " "));
        currentRow.add(this.myCurrentAction);
        currentRow = rowMaker.nextRow();
        currentRow.add(this.myProgressBar);
        Dimension dim = this.myProgressBar.getPreferredSize();
        dim.width = 500;
        this.myProgressBar.setPreferredSize(dim);
        this.myStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CameraPanel.this.doWork();
                CameraPanel.this.save();
                btnReport.setEnabled(true);
                btnStop.setEnabled(true);
            }
        });
        btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CameraPanel.this.myWorker.stop();
                btnStop.setEnabled(false);
            }
        });
        btnReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String text = Util.getTextFromFile(CameraPanel.this.myLogFile);
                    Report.showReport(Jibs.getString("CameraPanel.30"), text, false);
                }
                catch (Exception ex) {
                    Report.showReport(Jibs.getString("CameraPanel.20"), ex.getMessage(), false);
                }
            }
        });
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)rowMaker, "North");
        return rtnMe;
    }

    private String lookupDir(String msg, String prior) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(prior));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void doWork() {
        int logNumber = FileLoopHelper.getIntFromField(this.logNumberFld, 0);
        int nextLogNumber = logNumber + 1;
        this.logNumberFld.setValue(new Integer(Integer.toString(nextLogNumber)));
        String logFileName = CameraPreferences.getLogDirectory() + System.getProperty("file.separator") + "jibsLog_" + logNumber + ".txt";
        this.myLogFile = new File(logFileName);
        CameraPreferences.setUniqueRenamingCamera(this.myRenameUniqueCheckBox.isSelected());
        CameraPreferences.setExifRenaming(this.myRenameEXIFCheckBox.isSelected());
        try {
            FileLoopHelper helper = new FileLoopHelper(this.myCamera, "JIBS", this.pictureNumberFld, this.myCurrentAction, this.myProgressBar, this.myLogFile);
            this.myWorker = new WorkerCamera(this.myCamera.myWorkingList.getDirArray(), this.myRenameUniqueCheckBox.isSelected(), this.myRenameEXIFCheckBox.isSelected(), helper);
            Thread t = new Thread(this.myWorker);
            t.start();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("CameraPanel.25"), 0);
            ex.printStackTrace();
        }
    }

    private void save() {
        String log = this.logFld.getText();
        if (log != null && log.length() > 0 && !FileLoopHelper.checkDirectory(log, this.myStartBtn)) {
            JOptionPane.showMessageDialog(this.myStartBtn, Jibs.getString("CameraPanel.26") + Jibs.getString("CameraPanel.27"), Jibs.getString("save.failed"), 2);
            return;
        }
        CameraPreferences.setLogDirectory(this.logFld.getText());
        try {
            CameraPreferences.setRelabelNumber(FileLoopHelper.getIntFromField(this.pictureNumberFld, 0));
            CameraPreferences.setLogNumber(FileLoopHelper.getIntFromField(this.logNumberFld, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myStartBtn, ex.getMessage(), Jibs.getString("save.failed"), 0);
        }
    }
}

