/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.explorer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.gerhardb.jibs.explorer.ExplorerBox;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.util.Conversions;

class BoxPanel
extends JComponent
implements MouseListener {
    static final BasicStroke BASIC_STROKE = new BasicStroke(2.0f);
    static final DecimalFormat FORMAT = new DecimalFormat("#,##0");
    static final int COLUMN_COUNT = 5;
    DirectoryTreeNode myRootNode;
    DirectoryTreeNode myShowingNode;
    ExplorerBox myExplorerBox;
    int[] myColumnBoundaries = new int[5];
    ArrayList[] myColumns = new ArrayList[5];
    boolean iAmShowingRootNode = true;

    public BoxPanel(ExplorerBox box) {
        this.myExplorerBox = box;
        this.addMouseListener(this);
        super.setOpaque(true);
    }

    void setRootNode(DirectoryTreeNode rootNode) {
        this.myShowingNode = this.myRootNode = rootNode;
        this.iAmShowingRootNode = this.myRootNode.getParent() == null;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.myRootNode == null || this.myRootNode.isPopulating()) {
            return;
        }
        int colWidth = this.getWidth() / 5;
        for (int i = 0; i < this.myColumnBoundaries.length; ++i) {
            this.myColumnBoundaries[i] = (i + 1) * colWidth;
            this.myColumns[i] = new ArrayList(20);
        }
        g2.setStroke(BASIC_STROKE);
        if (this.iAmShowingRootNode && this.myExplorerBox.myTotalDiskSpace > 0L && this.myExplorerBox.iShowFreeSpace) {
            DirectoryTreeNode.TreeTotals tt = this.myRootNode.getTreeTotals();
            long freeDiskSpace = this.myExplorerBox.myTotalDiskSpace - tt.aggregateTotalFileSize;
            int height = this.getHeight();
            int nodeHeight = (int)((long)height * tt.aggregateTotalFileSize / this.myExplorerBox.myTotalDiskSpace);
            int freeHeight = height - nodeHeight;
            Rectangle usedRectangle = new Rectangle();
            usedRectangle.setBounds(0, 0, colWidth, nodeHeight);
            NodeYlocation usedLocation = new NodeYlocation(this.myRootNode, tt, 0, nodeHeight);
            this.myColumns[0].add(usedLocation);
            this.drawADirectory(g2, usedLocation, usedRectangle);
            Rectangle freeRectangle = new Rectangle();
            freeRectangle.setBounds(0, nodeHeight, colWidth, freeHeight);
            NodeYlocation freeLocation = new NodeYlocation(null, tt, nodeHeight, height);
            this.myColumns[0].add(freeLocation);
            String freeSpace = Conversions.formattedBinaryBytes(freeDiskSpace);
            this.drawABox(g2, freeRectangle, Color.GRAY, "Free Space", freeSpace);
            usedRectangle.x += usedRectangle.width;
            this.drawChildren(g2, 1, usedLocation, usedRectangle);
        } else {
            Rectangle rect = new Rectangle();
            rect.setBounds(0, 0, colWidth, this.getHeight());
            DirectoryTreeNode.TreeTotals tt = this.myRootNode.getTreeTotals();
            NodeYlocation ny = new NodeYlocation(this.myRootNode, tt, 0, this.getHeight());
            this.myColumns[0].add(ny);
            this.drawADirectory(g2, ny, rect);
            rect.x += rect.width;
            this.drawChildren(g2, 1, ny, rect);
        }
        g.dispose();
    }

    private void drawChildren(Graphics2D g2, int column, NodeYlocation parentNY, Rectangle parentRect) {
        if (parentNY.myNode == null) {
            return;
        }
        float boxHeight = parentRect.height;
        int childY = parentRect.y;
        int kids = parentNY.myNode.getChildCount();
        for (int i = 0; i < kids; ++i) {
            DirectoryTreeNode childNode = (DirectoryTreeNode)parentNY.myNode.getChildAt(i);
            DirectoryTreeNode.TreeTotals childTotals = childNode.getTreeTotals();
            Rectangle childRect = new Rectangle(parentRect);
            childRect.y = childY;
            childRect.height = (int)(boxHeight * (float)childTotals.aggregateTotalFileSize / (float)parentNY.myTT.aggregateTotalFileSize);
            NodeYlocation childNY = new NodeYlocation(childNode, childTotals, childRect.y, childRect.y + childRect.height);
            this.myColumns[column].add(childNY);
            this.drawADirectory(g2, childNY, new Rectangle(childRect));
            int nextColumn = column + 1;
            if (nextColumn < 5) {
                childRect.x += childRect.width;
                this.drawChildren(g2, nextColumn, childNY, childRect);
            }
            childY += childRect.height;
        }
    }

    private void drawADirectory(Graphics2D g2, NodeYlocation ny, Rectangle rect) {
        String line_1 = null;
        String line_2 = null;
        Color color = Color.YELLOW;
        if (ny.myNode.equals(this.myShowingNode)) {
            color = Color.GREEN;
            this.showRootInfo(ny);
        }
        if (ny.myNode != null) {
            line_1 = ny.myNode.getName();
            line_2 = Conversions.formattedBinaryBytes(ny.myTT.aggregateTotalFileSize);
        }
        this.drawABox(g2, rect, color, line_1, line_2);
    }

    private void drawABox(Graphics2D g2, Rectangle rect, Color color, String line_1, String line_2) {
        g2.setColor(color);
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2.setPaint(Color.BLACK);
        g2.draw(rect);
        if (line_1 != null && line_2 != null) {
            Dimension textSize_1 = BoxPanel.setFont(g2, line_1, rect.width);
            Dimension textSize_2 = BoxPanel.setFont(g2, line_2, rect.width);
            float HEIGHT_TEST = 0.9f;
            if ((float)textSize_1.height > (float)rect.height * 0.9f || textSize_1.getWidth() <= 5.0) {
                return;
            }
            if (textSize_1.getWidth() > 5.0 && (float)(textSize_1.height + textSize_2.height) < (float)rect.height * 0.9f) {
                int textX = rect.x + (rect.width - textSize_1.width) / 2;
                int textY = rect.y + (rect.height - textSize_1.height - textSize_2.height) / 2;
                FontMetrics fm = g2.getFontMetrics();
                g2.drawString(line_1, textX, textY += fm.getAscent());
                textX = rect.x + (rect.width - textSize_2.width) / 2;
                g2.drawString(line_2, textX, textY += textSize_2.height);
            } else {
                int textX = rect.x + (rect.width - textSize_1.width) / 2;
                int textY = rect.y + (rect.height - textSize_1.height) / 2;
                FontMetrics fm = g2.getFontMetrics();
                g2.drawString(line_1, textX, textY += fm.getAscent());
            }
        }
    }

    private static Dimension setFont(Graphics g, String msg, int box_width) {
        FontMetrics fm;
        int msg_width;
        int type_size = 12;
        int type_size_min = 4;
        do {
            Font f = new Font("Default", 0, type_size);
            g.setFont(f);
        } while ((msg_width = (fm = g.getFontMetrics()).stringWidth(msg)) >= box_width && (type_size -= 2) >= type_size_min);
        if (type_size < type_size_min) {
            return new Dimension(0, 0);
        }
        return new Dimension(msg_width, fm.getHeight());
    }

    private void showRootInfo(NodeYlocation node) {
        this.myExplorerBox.myDirName.setText(" ");
        this.myExplorerBox.myTotalDiretoryCount.setText("");
        this.myExplorerBox.myTotalAllFileCount.setText("");
        this.myExplorerBox.myTotalAllFileSize.setText("");
        this.myExplorerBox.myTotalImageFileCount.setText("");
        this.myExplorerBox.myTotalImageFileSize.setText("");
        this.myExplorerBox.myDiretoryCount.setText("");
        this.myExplorerBox.myNodeFileCount.setText("");
        this.myExplorerBox.myNodeFileSize.setText("");
        this.myExplorerBox.myNodeImageFileCount.setText("");
        this.myExplorerBox.myNodeImageFileSize.setText("");
        this.myExplorerBox.mySubDiretoryCount.setText("");
        this.myExplorerBox.mySubDirFileCount.setText("");
        this.myExplorerBox.mySubDirFileSize.setText("");
        this.myExplorerBox.mySubDirImageFileCount.setText("");
        this.myExplorerBox.mySubDirImageFileSize.setText("");
        if (node == null || node.myNode == null) {
            this.myShowingNode = null;
        } else {
            this.myShowingNode = node.myNode;
            DirectoryTreeNode.TreeTotals subTreeTotals = this.myShowingNode.getTreeTotals();
            this.myExplorerBox.myDirName.setText(this.myShowingNode.getAbsolutePath());
            this.myExplorerBox.myTotalDiretoryCount.setText(FORMAT.format(subTreeTotals.aggregateDirectoryCount));
            this.myExplorerBox.myTotalAllFileCount.setText(FORMAT.format(subTreeTotals.aggregateTotalFileCount));
            this.myExplorerBox.myTotalAllFileSize.setText(Conversions.formattedBinaryBytes(subTreeTotals.aggregateTotalFileSize));
            this.myExplorerBox.myTotalImageFileCount.setText(FORMAT.format(subTreeTotals.aggregateTargetFileCount));
            this.myExplorerBox.myTotalImageFileSize.setText(Conversions.formattedBinaryBytes(subTreeTotals.aggregateTargetFileSize));
            this.myExplorerBox.myDiretoryCount.setText(FORMAT.format(this.myShowingNode.getDirCountForTree()));
            this.myExplorerBox.myNodeFileCount.setText(FORMAT.format(this.myShowingNode.getTotalFileCount()));
            this.myExplorerBox.myNodeFileSize.setText(Conversions.formattedBinaryBytes(this.myShowingNode.getTotalFileSize()));
            this.myExplorerBox.myNodeImageFileCount.setText(FORMAT.format(this.myShowingNode.getTargetFileCount()));
            this.myExplorerBox.myNodeImageFileSize.setText(Conversions.formattedBinaryBytes(this.myShowingNode.getTargetFileSize()));
            this.myExplorerBox.mySubDiretoryCount.setText(FORMAT.format(subTreeTotals.aggregateDirectoryCount - this.myShowingNode.getDirCountForTree()));
            this.myExplorerBox.mySubDirFileCount.setText(FORMAT.format(subTreeTotals.aggregateTotalFileCount - this.myShowingNode.getTotalFileCount()));
            this.myExplorerBox.mySubDirFileSize.setText(Conversions.formattedBinaryBytes(subTreeTotals.aggregateTotalFileSize - this.myShowingNode.getTotalFileSize()));
            this.myExplorerBox.mySubDirImageFileCount.setText(FORMAT.format(subTreeTotals.aggregateTargetFileCount - this.myShowingNode.getTargetFileCount()));
            this.myExplorerBox.mySubDirImageFileSize.setText(Conversions.formattedBinaryBytes(subTreeTotals.aggregateTargetFileSize - this.myShowingNode.getTargetFileSize()));
        }
    }

    public void mouseClicked(MouseEvent event) {
        int x = event.getX();
        int column = -1;
        for (int i = 0; i < this.myColumnBoundaries.length; ++i) {
            if (x >= this.myColumnBoundaries[i]) continue;
            column = i;
            break;
        }
        int y = event.getY();
        NodeYlocation node = null;
        ArrayList columnList = this.myColumns[column];
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            NodeYlocation ny = (NodeYlocation)columnList.get(i);
            if (ny.myTopY >= y || y >= ny.myBottomY) continue;
            node = ny;
            break;
        }
        boolean showNewRoot = false;
        if (event.getClickCount() == 2) {
            showNewRoot = true;
        } else if ((event.getModifiers() & 8) != 0) {
            showNewRoot = true;
        } else if ((event.getModifiers() & 4) != 0) {
            showNewRoot = true;
        }
        if (node == null || node.myNode == null) {
            return;
        }
        if (showNewRoot) {
            if (node.myNode != this.myRootNode) {
                this.setRootNode(node.myNode);
            } else if (node.myNode.getParent() != null) {
                this.setRootNode((DirectoryTreeNode)node.myNode.getParent());
            } else {
                this.getToolkit().beep();
            }
        }
        this.showRootInfo(node);
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class NodeYlocation {
        DirectoryTreeNode myNode;
        DirectoryTreeNode.TreeTotals myTT;
        int myTopY;
        int myBottomY;

        NodeYlocation(DirectoryTreeNode node, DirectoryTreeNode.TreeTotals tt, int topY, int bottomY) {
            this.myNode = node;
            this.myTT = tt;
            this.myTopY = topY;
            this.myBottomY = bottomY;
        }
    }
}

