/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.producer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import org.gerhardb.jibs.producer.Audio;
import org.gerhardb.jibs.producer.IPictureShow;
import org.gerhardb.jibs.producer.Play;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.sound.SoundPlayer;

public class PlayListPlayer {
    Play[] myPlayList = new Play[0];
    int myCurrentItem = -1;
    ImageFactory myImageFactory;
    SoundPlayer mySoundPlayer = new SoundPlayer();
    IPictureShow myPictureShower;
    boolean iPlay = false;

    public PlayListPlayer(IPictureShow show) {
        this.myPictureShower = show;
        this.myImageFactory = ImageFactory.getImageFactory();
    }

    public void setPlayList(Play[] playList) {
        this.myCurrentItem = -1;
        this.myPlayList = playList == null ? new Play[0] : playList;
    }

    public void next() {
        Date finishedAt;
        long milliSecondsRan;
        int minRunTime;
        ++this.myCurrentItem;
        if (this.myCurrentItem >= this.myPlayList.length) {
            this.iPlay = false;
            return;
        }
        Date startedAt = new Date();
        this.myPictureShower.showPicture(this.getCurrentImage());
        this.myPictureShower.showCaption(this.myPlayList[this.myCurrentItem].getCaption());
        Audio[] audio = this.myPlayList[this.myCurrentItem].getAudio();
        for (int i = 0; i < audio.length; ++i) {
            File file = audio[i].getFile();
            this.mySoundPlayer.play(file);
        }
        if (this.myPlayList[this.myCurrentItem].getMinSeconds() > 0 && (long)(minRunTime = 1000 * this.myPlayList[this.myCurrentItem].getMinSeconds()) > (milliSecondsRan = (finishedAt = new Date()).getTime() - startedAt.getTime())) {
            try {
                Thread.sleep((long)minRunTime - milliSecondsRan);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void auto() {
        this.iPlay = true;
        Thread t = new Thread(new AutoPlay());
        t.start();
    }

    public void stop() {
        this.iPlay = false;
    }

    private BufferedImage getCurrentImage() {
        if (this.myCurrentItem < 0 || this.myCurrentItem >= this.myPlayList.length) {
            return null;
        }
        File imageFile = this.myPlayList[this.myCurrentItem].getImageFile();
        return this.myImageFactory.getImageEZ(imageFile);
    }

    private class AutoPlay
    implements Runnable {
        private AutoPlay() {
        }

        public void run() {
            while (PlayListPlayer.this.iPlay) {
                PlayListPlayer.this.next();
            }
        }
    }
}

