/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.PicInfoScrollPane;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.swing.JPanelRows;

public class PicInfoExif {
    private File myFile;
    private JComponent myPicturePanel;
    private int myShownWidth;
    private int myShownHeight;
    private boolean iShowDisplayInfo = false;
    private JPanelRows myPicInfoRows = new JPanelRows();
    Scroller myScroller;

    public PicInfoExif(File file, JComponent picturePanel, int displayInfoWidth, int displayInfoHeight, boolean showDisplayInfo, Scroller scroller) {
        this.myFile = file;
        this.myPicturePanel = picturePanel;
        this.myShownWidth = displayInfoWidth;
        this.myShownHeight = displayInfoHeight;
        this.iShowDisplayInfo = showDisplayInfo;
        this.myScroller = scroller;
    }

    public JPanel makeBorderPanel() {
        File file = this.myScroller.getCurrentFile();
        JPanel aRow = this.myPicInfoRows.topRow(1);
        try {
            BufferedImage image = ImageFactory.getImageFactory().makeImage(file).getImage();
            BufferedImage sized = ImageChangeUtil.fitAspectDown(image, 100, 100);
            ImageIcon imageIcon = new ImageIcon(sized);
            JLabel picture = new JLabel(imageIcon);
            picture.setSize(100, 100);
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            picture.setBorder(compound);
            aRow.add(picture);
            aRow = this.myPicInfoRows.nextRow(1);
            aRow.add(new JLabel(file.getAbsolutePath()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            aRow.add(new JLabel(Jibs.getString("PicInfoDialog.10") + Jibs.getString("colon") + " " + file.getAbsolutePath()));
        }
        ImageUtilDrew drew = new ImageUtilDrew(file);
        if (drew.parsableFileType()) {
            try {
                this.showExifTag(drew, Jibs.getString("date"), ImageUtilDrew.TAG_DATETIME);
                this.showExifTag(drew, Jibs.getString("PicInfoDialog.14"), ImageUtilDrew.TAG_DATETIME_ORIGINAL);
                this.showExifTag(drew, Jibs.getString("PicInfoDialog.15"), ImageUtilDrew.TAG_DATETIME_DIGITIZED);
                this.showExifTag(drew, Jibs.getString("PicInfoDialog.16"), ImageUtilDrew.TAG_MAKE);
                this.showExifTag(drew, Jibs.getString("PicInfoDialog.17"), ImageUtilDrew.TAG_MODEL);
            }
            catch (Exception ex) {
                aRow = this.myPicInfoRows.nextRow();
                aRow.add(new JLabel(Jibs.getString("PicInfoDialog.18")));
                ex.printStackTrace();
            }
        } else {
            aRow = this.myPicInfoRows.nextRow();
            aRow.add(new JLabel(Jibs.getString("PicInfoDialog.19")));
        }
        PicInfoScrollPane info = new PicInfoScrollPane(this.iShowDisplayInfo);
        info.setPicturePanel(this.myPicturePanel);
        info.update(this.myFile, this.myShownWidth, this.myShownHeight);
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)this.myPicInfoRows, "North");
        rtnMe.add((Component)info, "Center");
        return rtnMe;
    }

    private void showExifTag(ImageUtilDrew drew, String label, int theTag) {
        String theData = drew.getExifString(theTag);
        if (theData != null) {
            JPanel aRow = this.myPicInfoRows.nextRow();
            aRow.add(new JLabel(label + ": " + theData));
        }
    }
}

