/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.contact;

import java.awt.Font;
import java.io.File;
import java.util.Arrays;
import javax.swing.JProgressBar;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.contact.CSO;
import org.gerhardb.jibs.viewer.contact.ContactSheetOptions;
import org.gerhardb.jibs.viewer.contact.DirFiles;
import org.gerhardb.jibs.viewer.contact.DrawAPic;
import org.gerhardb.lib.io.FileNameComparatorInsensative;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.print.MediaFormat;
import org.gerhardb.lib.print.PrintableBase;

class ContactSheet
extends PrintableBase {
    static final String PIC_FIRST_INDEX = "<%!>";
    static final String PIC_LAST_INDEX = "<%@>";
    static final String PIC_COUNT = "<%%>";
    private static final int DEFAULT_X_SPACE_DPI = 5;
    private static final int DEFAULT_Y_SPACE_DPI = 5;
    private CSO myCSO;
    private File[] myImageFiles = new File[0];
    private DirFiles[] myDirFiles;
    private boolean iShowFiles = true;
    private JProgressBar myProgress = new JProgressBar();
    private JProgressBar myPreviewProgress = new JProgressBar();
    private JProgressBar myDirectoryProgress = new JProgressBar();
    private int myColsPerPage = 1;
    private int myRowsPerPage = 1;
    private int myPicsPerPage = 1;
    private int myPicBoxWidth;
    private int myPicBoxHeight;
    private int[] myXPicBoxOffsets;
    private int[] myYPicBoxOffsets;
    private int[] myPageIndexToDirFileIndex;
    private DrawAPic myDrawAPic;
    private int myOverallPicCount;

    public void imprint(ContactSheet that) {
        super.imprint(that);
        that.iShowFiles = this.iShowFiles;
        that.myImageFiles = this.myImageFiles;
        that.myDirFiles = this.myDirFiles;
        that.myOverallPicCount = this.myOverallPicCount;
        that.myPageIndexToDirFileIndex = this.myPageIndexToDirFileIndex;
        that.myColsPerPage = this.myColsPerPage;
        that.myRowsPerPage = this.myRowsPerPage;
        that.myPicsPerPage = this.myPicsPerPage;
        that.myProgress = this.myProgress;
        that.myPreviewProgress = this.myPreviewProgress;
        that.myDirectoryProgress = this.myDirectoryProgress;
    }

    ContactSheet(CSO cso) {
        super(cso);
        this.myCSO = cso;
        this.setFiles(new File[0]);
        this.myProgress.setMinimum(0);
        this.myProgress.setIndeterminate(false);
        this.myProgress.setStringPainted(true);
        this.myProgress.setString("");
        this.myDirectoryProgress.setMinimum(0);
        this.myDirectoryProgress.setIndeterminate(false);
        this.myDirectoryProgress.setStringPainted(true);
        this.myDirectoryProgress.setString("");
        this.myPreviewProgress.setMinimum(0);
        this.myPreviewProgress.setString("");
    }

    public PrintableBase makeCopy() {
        ContactSheet that = new ContactSheet(this.myCSO);
        this.imprint(that);
        return that;
    }

    void setFiles(File[] files) {
        this.iShowFiles = true;
        this.myImageFiles = files == null ? new File[0] : files;
        this.myOverallPicCount = this.myImageFiles.length;
        this.updatePageIndexes();
    }

    void setDirectories(DirFiles[] df) {
        this.iShowFiles = false;
        this.myDirFiles = df;
        this.myOverallPicCount = 0;
        for (int i = 0; i < this.myDirFiles.length; ++i) {
            this.myOverallPicCount = this.myDirFiles[i].files.length;
        }
        this.updatePageIndexes();
    }

    protected String getDirectory(int pageIndex) {
        if (this.myDirFiles == null) {
            return "";
        }
        int dirIndex = this.myPageIndexToDirFileIndex[pageIndex];
        DirFiles dirFile = this.myDirFiles[dirIndex];
        String rtnMe = dirFile.directory.toString();
        return rtnMe;
    }

    public String convert(String text, int pageIndex) {
        int pageIndexCurrentList = pageIndex;
        int currentDirectoryPicCount = this.myOverallPicCount;
        int currentDirectoryNumberOfPages = this.myNumberOfPages;
        File[] currentImageFiles = null;
        if (this.iShowFiles) {
            currentImageFiles = this.myImageFiles;
        } else {
            int dirIndex = this.myPageIndexToDirFileIndex[pageIndex];
            DirFiles dirFile = this.myDirFiles[dirIndex];
            pageIndexCurrentList = pageIndex - dirFile.indexOfLastPage;
            currentDirectoryPicCount = dirFile.files.length;
            currentDirectoryNumberOfPages = this.calcPages(currentDirectoryPicCount);
            currentImageFiles = dirFile.files;
            this.myDirectoryProgress.setValue(pageIndex + 1);
            this.myDirectoryProgress.setString(dirFile.directory.toString());
        }
        int firstPicOnPage = pageIndexCurrentList * this.myPicsPerPage;
        int lastPicOnPage = firstPicOnPage + this.myPicsPerPage;
        if (lastPicOnPage > currentImageFiles.length) {
            lastPicOnPage = currentImageFiles.length;
        }
        text = text.replaceAll("<#>", Integer.toString(pageIndexCurrentList + 1));
        text = text.replaceAll("<##>", Integer.toString(currentDirectoryNumberOfPages));
        text = text.replaceAll(PIC_COUNT, Integer.toString(currentDirectoryPicCount));
        text = text.replaceAll(PIC_FIRST_INDEX, Integer.toString(firstPicOnPage + 1));
        text = text.replaceAll(PIC_LAST_INDEX, Integer.toString(lastPicOnPage));
        return text;
    }

    int getFileCount() {
        return this.myOverallPicCount;
    }

    JProgressBar getProgressBar() {
        return this.myProgress;
    }

    JProgressBar getPreviewProgressBar() {
        return this.myPreviewProgress;
    }

    JProgressBar getDirectoryProgress() {
        return this.myDirectoryProgress;
    }

    void setColRow(int cols, int rows) {
        this.myColsPerPage = cols;
        this.myRowsPerPage = rows;
        if (this.myColsPerPage < 1) {
            this.myColsPerPage = 1;
        }
        if (this.myRowsPerPage < 1) {
            this.myRowsPerPage = 1;
        }
        this.updatePageIndexes();
    }

    void updatePageIndexes() {
        this.myPicsPerPage = this.myColsPerPage * this.myRowsPerPage;
        this.myPreviewProgress.setMaximum(this.myPicsPerPage);
        this.myProgress.setMaximum(this.myPicsPerPage);
        if (this.myDirFiles == null) {
            this.myNumberOfPages = this.calcPages(this.myOverallPicCount);
        } else {
            this.myNumberOfPages = 0;
            for (int i = 0; i < this.myDirFiles.length; ++i) {
                this.myDirFiles[i].indexOfLastPage = this.myNumberOfPages;
                this.myDirFiles[i].pageCount = this.calcPages(this.myDirFiles[i].files.length);
                this.myNumberOfPages += this.myDirFiles[i].pageCount;
            }
            this.myPageIndexToDirFileIndex = new int[this.myNumberOfPages];
            int pageIndex = 0;
            for (int dirIndex = 0; dirIndex < this.myDirFiles.length; ++dirIndex) {
                int pageCount = this.myDirFiles[dirIndex].pageCount;
                for (int x = 0; x < pageCount; ++x) {
                    this.myPageIndexToDirFileIndex[pageIndex] = dirIndex;
                    ++pageIndex;
                }
            }
        }
        this.myDirectoryProgress.setMaximum(this.myNumberOfPages);
        this.myCSO.showPageCount();
    }

    int calcPages(int fileCount) {
        int rtnMe = fileCount / this.myPicsPerPage;
        int remainder = fileCount % this.myPicsPerPage;
        if (remainder != 0) {
            ++rtnMe;
        }
        return rtnMe;
    }

    protected void drawPage(int pageIndex) {
        this.setPicBoxMeasurements(this.getMediaFormat());
        Font picFont = this.getFont(this.myCSO.getPictureFontFamily(), this.myCSO.getPictureFontSize(), this.fontTheta);
        this.myDrawAPic = new DrawAPic(this.myBuffGraphics, picFont, this.myPicBoxWidth, this.myPicBoxHeight, this.myCSO, this);
        int pageIndexCurrentList = pageIndex;
        File[] currentImageFiles = null;
        if (this.iShowFiles) {
            currentImageFiles = this.myImageFiles;
        } else {
            int dirIndex = this.myPageIndexToDirFileIndex[pageIndex];
            DirFiles dirFile = this.myDirFiles[dirIndex];
            currentImageFiles = dirFile.files;
            pageIndexCurrentList = pageIndex - dirFile.indexOfLastPage;
        }
        try {
            Arrays.sort(currentImageFiles, new FileNameComparatorInsensative());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int baseListIndex = pageIndexCurrentList * this.myPicsPerPage;
        for (int picCntPage = 0; picCntPage < this.myPicsPerPage; ++picCntPage) {
            this.myPreviewProgress.setValue(picCntPage + 1);
            this.myProgress.setValue(picCntPage + 1);
            int adjustedPageIndex = pageIndex + 1;
            String progress = Jibs.getString("ContactSheet.0") + " " + adjustedPageIndex + " " + Jibs.getString("of") + " " + this.myNumberOfPages;
            this.myProgress.setString(progress);
            int picCntList = baseListIndex + picCntPage;
            if (picCntList >= currentImageFiles.length) continue;
            File imageFile = currentImageFiles[picCntList];
            this.myDrawAPic.print(imageFile, picCntList, this.myXPicBoxOffsets[picCntPage], this.myYPicBoxOffsets[picCntPage]);
        }
    }

    void setPicBoxMeasurements(MediaFormat mediaFormat) {
        int xSpace = this.scaleDPI(5);
        int ySpace = this.scaleDPI(5);
        int availableWidth = (int)mediaFormat.getDpiPrintableWidth() - (this.myColsPerPage - 1) * xSpace;
        this.myPicBoxWidth = availableWidth / this.myColsPerPage;
        int availableHeight = (int)this.myBottomPictureMargin - (int)this.myTopPictureMargin - (this.myRowsPerPage - 1) * ySpace;
        this.myPicBoxHeight = availableHeight / this.myRowsPerPage;
        this.myXPicBoxOffsets = new int[this.myPicsPerPage];
        this.myYPicBoxOffsets = new int[this.myPicsPerPage];
        int index = 0;
        for (int row = 0; row < this.myRowsPerPage; ++row) {
            int currentRow = (int)this.myTopPictureMargin + row * (this.myPicBoxHeight + ySpace);
            for (int col = 0; col < this.myColsPerPage; ++col) {
                this.myYPicBoxOffsets[index] = currentRow;
                this.myXPicBoxOffsets[index] = (int)this.myLeftMargin + col * (this.myPicBoxWidth + xSpace);
                ++index;
            }
        }
    }

    public static void main(String[] args) {
        try {
            File dir = new File("D:/testpics/delete");
            new ContactSheetOptions(null, dir.listFiles(), 1, new Scroller());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

