/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.comic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import org.gerhardb.jibs.viewer.shows.comic.ComicScreen;
import org.gerhardb.jibs.viewer.shows.comic.MagnifiedPanel;
import org.gerhardb.lib.image.ImageChangeUtil;

public class MagnifiedImage
extends JComponent
implements AdjustmentListener {
    private static int CENTER_WIDTH = 0;
    private BufferedImage myUnsizedImage;
    private BufferedImage mySizedImage;
    private Rectangle myLastClip;
    MagnifiedPanel myMagnifiedPanel;
    JScrollBar myBar;
    int myScrollDownBy = 0;
    int myMaxScrollDown = 0;
    int myUpOrDownKeyIncrement = 10;

    public MagnifiedImage(MagnifiedPanel mp) {
        this.myMagnifiedPanel = mp;
        this.myBar = this.myMagnifiedPanel.myBar;
        super.setOpaque(true);
        super.setBackground(ComicScreen.BACKGROUND_COLOR);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.myScrollDownBy = e.getValue();
        this.repaint();
    }

    protected void setImage(BufferedImage image) {
        this.myUnsizedImage = image;
        this.myScrollDownBy = 0;
        this.myBar.setValue(this.myScrollDownBy);
        this.myLastClip = null;
        this.repaint();
    }

    protected void up() {
        if (this.myScrollDownBy > 0) {
            this.myScrollDownBy -= this.myUpOrDownKeyIncrement;
            if (this.myScrollDownBy < 0) {
                this.myScrollDownBy = 0;
            }
            this.myBar.setValue(this.myScrollDownBy);
            this.repaint();
        }
    }

    protected void down() {
        if (this.myScrollDownBy < this.myMaxScrollDown) {
            this.myScrollDownBy += this.myUpOrDownKeyIncrement;
            if (this.myScrollDownBy > this.myMaxScrollDown) {
                this.myScrollDownBy = this.myMaxScrollDown;
            }
            this.myBar.setValue(this.myScrollDownBy);
            this.repaint();
        }
    }

    protected void allUp() {
        this.myScrollDownBy = 0;
        this.myBar.setValue(this.myScrollDownBy);
        this.repaint();
    }

    protected void allDown() {
        this.myScrollDownBy = this.myMaxScrollDown;
        this.myBar.setValue(this.myScrollDownBy);
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.sizeImage();
        if (this.mySizedImage != null) {
            int pushPictureUpPastTop = 0 - this.myScrollDownBy;
            graphics.drawImage(this.mySizedImage, CENTER_WIDTH, pushPictureUpPastTop, this);
        }
    }

    private void sizeImage() {
        int imgWidth;
        float theta;
        if (this.myUnsizedImage == null) {
            this.mySizedImage = null;
            return;
        }
        Rectangle clip = super.getVisibleRect();
        if (clip.equals(this.myLastClip)) {
            return;
        }
        this.myLastClip = clip;
        int clipWidth = (int)clip.getWidth();
        int clipHeight = (int)clip.getHeight();
        if (clipWidth == 0 && clipHeight == 0) {
            this.mySizedImage = null;
        }
        this.mySizedImage = (theta = ImageChangeUtil.calcThetaWidth(imgWidth = this.myUnsizedImage.getWidth(), clipWidth)) != 0.0f ? ImageChangeUtil.scale(this.myUnsizedImage, theta) : this.myUnsizedImage;
        super.setPreferredSize(new Dimension(this.mySizedImage.getWidth(), this.mySizedImage.getHeight()));
        this.myUpOrDownKeyIncrement = this.mySizedImage.getHeight() / 10;
        this.myMaxScrollDown = this.mySizedImage.getHeight() - clipHeight;
        if (this.myMaxScrollDown > 0) {
            this.myBar.setEnabled(true);
            this.myBar.setMinimum(0);
            this.myBar.setMaximum(this.mySizedImage.getHeight());
            int proposedExtent = this.mySizedImage.getHeight() - this.myMaxScrollDown;
            if (proposedExtent > 0) {
                this.myBar.getModel().setExtent(proposedExtent);
            } else {
                this.myBar.getModel().setExtent(proposedExtent);
            }
        } else {
            this.myMaxScrollDown = 0;
            this.myBar.setEnabled(false);
        }
    }
}

