/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.thumbs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IRevert;
import org.gerhardb.jibs.viewer.ISave;
import org.gerhardb.jibs.viewer.IShow;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.shows.thumbs.Picture;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailCache;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailOptions;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailOptionsDialog;
import org.gerhardb.jibs.viewer.shows.thumbs.ThumbnailSaver;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.swing.GlassPane2;
import org.gerhardb.lib.util.Range;

public class Thumbnails
extends JPanel
implements IShow,
IRevert {
    Color mySelectedColor;
    IFrame myViewerFrame = null;
    FileList myFileList;
    int myPicsPerPage;
    int myRows;
    int myCols;
    int mySelectedPicCell;
    ThumbnailCache myCache;
    private Picture[] myPictures;
    int myShowingScrollerValue;
    private GlassPane2 myGlassPane;
    DragSource myDragSource = new DragSource();
    boolean iAmShowing = false;
    ThumbnailSaver myThumbnailSaver;

    public Thumbnails(IFrame mf, int zeroBasedIndex) {
        super(true);
        this.myViewerFrame = mf;
        this.myFileList = this.myViewerFrame.getFileList();
        this.myGlassPane = new GlassPane2(this.myViewerFrame.getFrame());
        ThumbnailOptions options = new ThumbnailOptions();
        this.setRowCol(options.getRows(), options.getCols(), options.getSelectedPicCell());
        this.myCache = new ThumbnailCache(this.myRows, this.myCols, this.myViewerFrame.getScroller());
        this.myThumbnailSaver = new ThumbnailSaver(this.myViewerFrame, this, this.myCache);
        this.myThumbnailSaver.resetToolbar();
        this.mySelectedColor = this.myFileList.getSelectionBackground();
        super.setFocusable(true);
        this.resetFocus();
        KeyActions adapter = new KeyActions();
        super.addKeyListener(adapter);
        this.myViewerFrame.getScroller().setShowViewKeyListener(adapter);
        super.setBackground(Color.black);
        this.myViewerFrame.getFileList().getFileListSelectionModel().setMouseAlwaysAdds(true);
        this.myViewerFrame.getScroller().setValue(zeroBasedIndex);
        this.iAmShowing = true;
        this.showImage();
    }

    public void paint(Graphics g) {
        this.myViewerFrame.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        super.paint(g);
        this.myViewerFrame.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    public ISave getSaver() {
        return this.myThumbnailSaver;
    }

    public void setRowCol(int rows, int cols, int selectedPicCell) {
        this.myRows = rows;
        this.myCols = cols;
        this.mySelectedPicCell = selectedPicCell - 1;
        if (this.myPictures != null) {
            super.removeAll();
        }
        int hgap = 2;
        int vgap = 2;
        if (this.myRows < 1) {
            this.myRows = 1;
        }
        if (this.myCols < 1) {
            this.myCols = 1;
        }
        this.myPicsPerPage = this.myRows * this.myCols;
        if (selectedPicCell < 2) {
            selectedPicCell = 2;
        } else if (selectedPicCell > this.myPicsPerPage) {
            selectedPicCell = this.myPicsPerPage;
        }
        super.setLayout(new GridLayout(this.myRows, this.myCols, hgap, vgap));
        this.myPictures = new Picture[this.myPicsPerPage];
        for (int i = 0; i < this.myPictures.length; ++i) {
            this.myPictures[i] = new Picture(this, i + 1);
            this.myPictures[i].setCurrentPicture(false);
            super.add(this.myPictures[i]);
            if (i != this.mySelectedPicCell) continue;
            this.myPictures[i].setCurrentPicture(true);
        }
        this.reloadScroller();
    }

    private void invalidatePicPointer() {
        this.myShowingScrollerValue = -1;
    }

    public int getScrollBarIndex(int cellIndex) {
        return this.myViewerFrame.getScroller().getValueZeroBased() + cellIndex - this.mySelectedPicCell;
    }

    void redisplayClearCache() {
        System.out.println("redisplayClearCache()<<<<<<<<<<<<<<<");
        this.myCache.reload();
        this.adjustShowingImageBuffer();
    }

    public void revert() {
        this.myViewerFrame.gotoFullScreen(false);
    }

    public boolean isFullScreen() {
        return false;
    }

    public void showImage() {
        if (!this.iAmShowing) {
            return;
        }
        this.adjustShowingImageBuffer();
        this.repaint();
        this.myViewerFrame.statusCurrentPage();
    }

    public JComponent getImageDisplay() {
        return this;
    }

    public void connect() {
        this.myViewerFrame.getScroller().setEndMessages(false);
        this.myViewerFrame.getScroller().addScrollerListener(this);
        super.addKeyListener(this.myViewerFrame.getScroller().getScrollerKeyListener());
        this.myCache.reload();
        this.showPageFromScroller();
    }

    public void disconnect() {
        this.myViewerFrame.getScroller().removeScrollerListener(this);
        super.removeKeyListener(this.myViewerFrame.getScroller().getScrollerKeyListener());
        if (this.myCache != null) {
            this.myCache.stop();
        }
    }

    public void info(StringBuffer sb) {
        if (this.myCache == null) {
            sb.append(Jibs.getString("Thumbnails.0"));
        } else {
            sb.append(Jibs.getString("Thumbnails.1"));
        }
    }

    public void jumpTo(File file) {
        this.reloadScroller();
        this.myViewerFrame.getScroller().jumpTo(file);
        this.showPageFromScroller();
    }

    public JMenuItem makePreferencesItem() {
        return ThumbnailOptionsDialog.makeThumbnailPreferenceMenu(this.myViewerFrame);
    }

    public void reloadScroller() {
        this.invalidatePicPointer();
        this.myViewerFrame.getScroller().reloadScroller();
    }

    public void reloadScroller(int index) {
        this.invalidatePicPointer();
        this.myViewerFrame.getScroller().reloadScroller(index);
    }

    public void resetFocus() {
        this.myViewerFrame.getScroller().setAutoFocus(this);
    }

    public void setWaitCursor(boolean wait) {
        this.myGlassPane.setWaitCursor(wait);
    }

    public void showPageFromScroller() {
        this.invalidatePicPointer();
        this.showImage();
        if (this.myFileList.isVisible()) {
            this.myFileList.sliderAdjusted();
        }
        this.requestFocus();
    }

    public void startSlideShow() {
        this.myViewerFrame.getScroller().startSlideShow(ViewerPreferences.continuousShow());
    }

    public Range showingIndexes() {
        int index;
        int i;
        int startIndex = -1;
        int stopIndex = -1;
        for (i = 0; i < this.myPictures.length; ++i) {
            index = this.myPictures[i].getScrollerIndex();
            if (index <= -1) continue;
            startIndex = index;
            break;
        }
        for (i = this.myPictures.length - 1; i > -1; --i) {
            index = this.myPictures[i].getScrollerIndex();
            if (index <= 0) continue;
            stopIndex = index;
            break;
        }
        return new Range(startIndex, stopIndex);
    }

    public void swapPictureFocus() {
        if (this.myFileList.hasFocus()) {
            this.myViewerFrame.getScroller().forceFocus();
        } else {
            this.myFileList.grabFocus();
        }
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        switch (ce.getEventType()) {
            case 0: {
                if (this.myViewerFrame.getScroller().getValueIsAdjusting()) break;
                this.invalidatePicPointer();
                this.showImage();
                break;
            }
            case 1: {
                if (this.myViewerFrame.getScroller().getValueIsAdjusting()) break;
                this.showPageFromScroller();
                break;
            }
            case 2: {
                if (this.myViewerFrame.getScroller().getMaximumZeroBased() < 0) {
                    this.invalidatePicPointer();
                    this.repaint();
                }
                this.myCache.remove(ce.getIndexRemoved());
                this.showPageFromScroller();
                break;
            }
            case 3: {
                int i;
                if (this.myViewerFrame.getScroller().getMaximumZeroBased() < 0) {
                    this.invalidatePicPointer();
                    this.repaint();
                }
                this.myCache.reload();
                boolean refreshNeeded = false;
                for (i = 0; i < this.myPictures.length && !(refreshNeeded = this.myPictures[i].isRefreshNeeded()); ++i) {
                }
                if (!refreshNeeded) {
                    return;
                }
                for (i = 0; i < this.myPicsPerPage; ++i) {
                    this.myPictures[i].setImage(null, null, null, 0);
                }
                this.showPageFromScroller();
            }
        }
    }

    private void adjustShowingImageBuffer() {
        if (this.myShowingScrollerValue == this.myViewerFrame.getScroller().getValueZeroBased()) {
            return;
        }
        this.setWaitCursor(true);
        this.myShowingScrollerValue = this.myViewerFrame.getScroller().getValueZeroBased();
        int offset = this.myViewerFrame.getScroller().getValueZeroBased() - this.mySelectedPicCell;
        for (int i = 0; i < this.myPicsPerPage; ++i) {
            int adjustedIndex = i + offset;
            BufferedImage image = null;
            File file = null;
            image = this.myCache.getImage(adjustedIndex);
            file = this.myViewerFrame.getScroller().getFile(adjustedIndex);
            String name = null;
            if (file != null) {
                name = file.getName();
            }
            this.myPictures[i].setImage(image, name, file, adjustedIndex);
        }
        this.setWaitCursor(false);
        if (this.myCache != null) {
            int startingIndexToLoad = this.myViewerFrame.getScroller().getValueZeroBased() - this.mySelectedPicCell;
            this.myCache.update(startingIndexToLoad);
        }
    }

    class Test
    implements Runnable {
        private long round = 10L;
        long start = new Date().getTime();

        Test() {
        }

        public void run() {
            System.out.println("===========================================================");
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(9);
            this.report(1);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(18);
            this.report(2);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(9);
            this.report(3);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(18);
            this.report(4);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(17);
            this.report(5);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(16);
            this.report(6);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(15);
            this.report(7);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(14);
            this.report(8);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(15);
            this.report(9);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(16);
            this.report(10);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(17);
            this.report(11);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(18);
            this.report(12);
            Thumbnails.this.myViewerFrame.getScroller().jumpTo(19);
            this.report(13);
            System.out.println("===========================================================");
        }

        void report(int i) {
            long elapsed = new Date().getTime() - this.start;
            System.out.println(i + ": " + Long.toString(elapsed / this.round));
            try {
                Thread.sleep(1500L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.start = new Date().getTime();
        }
    }

    private class KeyActions
    implements KeyListener {
        private KeyActions() {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 10: {
                    if ((event.getModifiersEx() & 0x80) == 128) {
                        Thumbnails.this.revert();
                    }
                    if ((event.getModifiersEx() & 0x200) == 512) {
                        Thumbnails.this.revert();
                    }
                    event.consume();
                    return;
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 27: {
                    Thumbnails.this.myViewerFrame.getShow().showPageFromScroller();
                    event.consume();
                    return;
                }
                case 113: {
                    Thumbnails.this.myViewerFrame.gotoFullScreen(false);
                    event.consume();
                    return;
                }
                case 34: {
                    int currentlyAt = Thumbnails.this.myViewerFrame.getScroller().getValueZeroBased();
                    int jumpTo = currentlyAt + Thumbnails.this.myPicsPerPage;
                    if (jumpTo > Thumbnails.this.myViewerFrame.getScroller().getMaximumZeroBased()) {
                        jumpTo = Thumbnails.this.myViewerFrame.getScroller().getMaximumZeroBased();
                    }
                    Thumbnails.this.myViewerFrame.getScroller().jumpTo(jumpTo);
                    event.consume();
                    Thumbnails.this.myViewerFrame.getScroller().updateSelectionInterval();
                    break;
                }
                case 33: {
                    int currentlyAt = Thumbnails.this.myViewerFrame.getScroller().getValueZeroBased();
                    int jumpTo = currentlyAt - Thumbnails.this.myPicsPerPage;
                    if (jumpTo < 0) {
                        jumpTo = 0;
                    }
                    Thumbnails.this.myViewerFrame.getScroller().jumpTo(jumpTo);
                    event.consume();
                    Thumbnails.this.myViewerFrame.getScroller().updateSelectionInterval();
                }
            }
        }
    }
}

