/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;

public class DTNWriter {
    DTNReaderWriter myBase;

    DTNWriter(DTNReaderWriter base) {
        this.myBase = base;
    }

    public static String getNameOfDrive(String path) {
        File dir;
        FileSystemView view = FileSystemView.getFileSystemView();
        String name = view.getSystemDisplayName(dir = new File(path));
        if (name == null) {
            return null;
        }
        if ((name = name.trim()) == null || name.length() < 1) {
            return null;
        }
        int index = name.lastIndexOf(" (");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public void store(DirectoryTreeNode rootNode) throws Exception {
        File fileSystemRoot;
        if (rootNode == null || rootNode.getDirectory() == null) {
            return;
        }
        String dir = rootNode.getDirectory().toString();
        File directoryToStoreIn = this.myBase.myFileFromPathManagerStartingJibsFile;
        if (directoryToStoreIn == null) {
            String fileName = dir + "/" + this.myBase.getFileName();
            directoryToStoreIn = new File(fileName);
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(directoryToStoreIn)));
        if (this.myBase.iCountTargetFiles) {
            writer.print("# v2i ");
        } else {
            writer.print("# v2x ");
        }
        writer.println(this.myBase.getFileName());
        writer.print("# Date: ");
        Date now = new Date();
        writer.println(DTNReaderWriter.DATE_FORMAT.format(now));
        writer.print("# Root Path: ");
        File treeRootDir = rootNode.getDirectory();
        writer.println(treeRootDir.getAbsolutePath());
        writer.print("# Root Name: ");
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (fileSystemRoot = treeRootDir; fileSystemRoot != null && !fsv.isFileSystemRoot(fileSystemRoot); fileSystemRoot = fileSystemRoot.getParentFile()) {
        }
        if (fileSystemRoot != null) {
            writer.println(DTNWriter.getNameOfDrive(fileSystemRoot.getAbsolutePath()));
        }
        writer.println("# depth path directories fileCount fileSize imageCount imageSize");
        int skip = dir.length();
        this.storeAllNodes(writer, rootNode, 0, skip);
        writer.flush();
        writer.close();
    }

    private void storeAllNodes(PrintWriter writer, DirectoryTreeNode node, int depth, int skip) {
        this.storeANode(writer, node, depth, skip);
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            DirectoryTreeNode childNode = (DirectoryTreeNode)kids.nextElement();
            this.storeAllNodes(writer, childNode, depth + 1, skip);
        }
    }

    private void storeANode(PrintWriter writer, DirectoryTreeNode node, int depth, int skip) {
        String path = node.getDirectory().getAbsolutePath();
        writer.print(depth);
        writer.print("\t*");
        if (skip < path.length()) {
            writer.print(path.substring(skip));
        } else {
            writer.print(File.separator);
        }
        writer.print("\t");
        writer.print(node.myNodeDirCount);
        writer.print("\t");
        writer.print(node.myNodeAllFileCount);
        writer.print("\t");
        writer.print(node.myNodeAllFileSize);
        writer.print("\t");
        writer.print(node.myNodeTargetFileCount);
        writer.print("\t");
        writer.print(node.myNodeTargetFileSize);
        writer.println("");
    }
}

