/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import org.gerhardb.jibs.explorer.ExplorerBox;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.IScrollDirTree;
import org.gerhardb.lib.dirtree.ITreePopupMenu;
import org.gerhardb.lib.dirtree.IUndo;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.filelist.FileListManager;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.rdp.BasicOptionsManager;
import org.gerhardb.lib.dirtree.rdp.IListShowTree;
import org.gerhardb.lib.dirtree.rdp.ILoad;
import org.gerhardb.lib.dirtree.rdp.MoveManager;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.dirtree.rdp.SortManager;
import org.gerhardb.lib.dirtree.rdp.StatusBarManager;
import org.gerhardb.lib.dirtree.rdp.TreeManager;
import org.gerhardb.lib.dirtree.rdp.TreeManagerSet;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.util.Range;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.Loading;

public class ListShowTreeCoordinator
implements RDPplugins,
IUndo,
IScrollDirTree,
TreeManagerSet,
FileListPlugins {
    public static String JIBS_DIR_NAME = "/JIBS/textpad";
    private Scroller myScroller = new Scroller();
    private ExtendedDirectoryTree myTree;
    private FileList myFileList;
    private Preferences myPrefs;
    IListShowTree myLSTplugins;
    PathManager myPathManager;
    TreeManager myTreeManager;
    RDPmanager myRDPmanager;
    FileListManager myFileListManager;
    StatusBarManager myStatusBarManager;
    SortManager mySortManager = new SortManager(this);
    BasicOptionsManager myBasicOptionsManager = new BasicOptionsManager(this);
    ActiveActions myActions;

    public ListShowTreeCoordinator(IListShowTree lst) {
        this.myLSTplugins = lst;
        this.myPrefs = Preferences.userRoot().node("/" + this.myLSTplugins.getAppIDandTargetType() + "/org/gerhardb/lib/dirtree/rdp/ListShowTreeCoordinator");
    }

    public void init(ITreePopupMenu getter) {
        this.myPathManager = new PathManager(this, this.myLSTplugins.getAppIDandTargetType());
        this.myRDPmanager = new RDPmanager(this, this, this, this.myLSTplugins.getAppIDandTargetType());
        this.myFileListManager = new FileListManager(this, this.myLSTplugins.getFilenameFileFilter());
        this.myTreeManager = new TreeManager(this);
        boolean countHiddenDirectories = false;
        this.myTree = new ExtendedDirectoryTree(this.myLSTplugins.getTopFrame(), this.myLSTplugins.getFilenameFileFilter(), this.myRDPmanager, this.myScroller, getter, countHiddenDirectories);
        this.myTree.setCountTargetFiles(this.myLSTplugins.getCountTargetFiles());
        this.myFileList = new FileList(this, this.myTree);
        this.myFileList.setModel(this.myScroller);
        this.myScroller.setFrame(this.myLSTplugins.getTopFrame());
        this.myScroller.getScrollerKeyListener().setKeypadOps(this.myRDPmanager);
        this.myScroller.sort(this.mySortManager.getSortOrder());
        ScrollerListener listener = this.myLSTplugins.getScrollerListener();
        if (listener != null) {
            this.myScroller.addScrollerListener(listener);
        }
        this.myStatusBarManager = new StatusBarManager(this);
        this.myBasicOptionsManager.init();
        this.myScroller.requestFocus();
    }

    public void addActions(ActiveActions aa) {
        this.myActions = aa;
        this.myRDPmanager.addActions(this.myActions);
        this.myPathManager.init();
    }

    public TreeManager getTreeManager() {
        return this.myTreeManager;
    }

    public FileListManager getFileListManager() {
        return this.myFileListManager;
    }

    public ExtendedDirectoryTree getTree() {
        return this.myTree;
    }

    public StatusBarManager getStatusBarManager() {
        return this.myStatusBarManager;
    }

    public SortManager getSortManager() {
        return this.mySortManager;
    }

    public ActiveActions getActions() {
        return this.myActions;
    }

    public BasicOptionsManager getBasicOptionsManager() {
        return this.myBasicOptionsManager;
    }

    public void storeDirectories() {
        if (this.myBasicOptionsManager.getRememberDirectories()) {
            try {
                this.getTreeManager().store();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getTopFrame(), AppStarter.getString("SortScreen.49") + ex.getMessage(), AppStarter.getString("SortScreen.50"), 0);
                ex.printStackTrace();
            }
        }
        this.flush();
    }

    public void flush() {
        try {
            this.myPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public Scroller getScroller() {
        return this.myScroller;
    }

    public RDPplugins getRDPplugins() {
        return this;
    }

    public MoveManager getMoveManager() {
        return this.myRDPmanager.getMoveManager();
    }

    public Range showingIndexes() {
        int index = this.myScroller.getValueZeroBased();
        return new Range(index, index);
    }

    public RDPmanager getRDPmanager() {
        return this.myRDPmanager;
    }

    public FileList getFileList() {
        return this.myFileList;
    }

    public void setCurrentDirectory(DirectoryTreeNode[] nodes, boolean nonTarget) {
        this.myFileListManager.setTargetDir(nodes, nonTarget);
    }

    public void setCurrentDirectory(DirectoryTreeNode node, boolean nonTarget) {
        this.myFileListManager.setTargetDir(node, nonTarget);
    }

    public void selectFiles(File[] filesToSelect) {
        this.myFileList.selectFiles(filesToSelect);
    }

    public int getResetRecommendation() {
        return this.myFileList.getResetRecommendation();
    }

    public void fileListUpdated() {
    }

    public JFrame getTopFrame() {
        return this.myLSTplugins.getTopFrame();
    }

    public ExtendedDirectoryTree getExtendedDirectoryTree() {
        return this.myTree;
    }

    public PathManager getPathManager() {
        return this.myPathManager;
    }

    public String getDirectoryForParkAndDelete() {
        return AppStarter.getMyDocumentsDir().getAbsoluteFile() + JIBS_DIR_NAME;
    }

    public String getPreference(String lookup, String aDefault) {
        return this.myPrefs.get(lookup, null);
    }

    public Preferences getPreferences() {
        return this.myPrefs;
    }

    public File getCurrentFile() {
        return this.myScroller.getCurrentFile();
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.myLSTplugins.getTopFrame().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.myLSTplugins.getTopFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setCurrentDirectory(String dirName) {
        this.myFileListManager.setTargetDir(dirName);
    }

    public void removeCurrentFile() {
        this.myScroller.removeCurrentPage();
    }

    public void reloadScroller(int scrollBackTo) {
        this.myScroller.reloadScroller(scrollBackTo);
    }

    public void reloadScroller() {
        this.myScroller.reloadScroller();
    }

    public void clearSelection() {
        this.myFileList.clearSelection();
    }

    public void loadParkAndDeleteNodes() {
        this.myRDPmanager.loadParkAndDeleteNodes();
    }

    public void setTreeDirectory(String dirName) {
        this.myTreeManager.setDirectory(dirName);
    }

    public void removePreference(String lookup) {
        this.myPrefs.remove(lookup);
    }

    public void showStats(DirectoryTreeNode node, boolean countImageFilesInNodes) {
        if (node == null) {
            JOptionPane.showMessageDialog(this.myLSTplugins.getTopFrame(), AppStarter.getString("Popups.5"), AppStarter.getString("Popups.6"), 1);
            return;
        }
        DTNReaderWriter dtn = new DTNReaderWriter(this.myLSTplugins.getAppIDandTargetType(), countImageFilesInNodes, PathManager.getStartingJibsFile());
        boolean countHiddenDirectories = false;
        ExplorerBox explorer = new ExplorerBox(false, false, this.myScroller, dtn, countHiddenDirectories, false);
        explorer.setRootNode(node);
    }

    public void updateResetRecommendation() {
        this.myFileList.updateResetRecommendation();
    }

    public boolean isFullScreen() {
        return false;
    }

    public void addUndoable(UndoableEdit edit) {
        this.myRDPmanager.getMoveManager().addUndoable(edit);
    }

    public void redid() {
        this.myScroller.reloadScroller();
    }

    public void undid(File file) {
        this.myScroller.reloadScroller();
        this.myScroller.jumpTo(file);
        this.showPageFromScroller();
    }

    public void showPageFromScroller() {
        this.showFile();
        if (this.myFileList.isVisible()) {
            this.myFileList.sliderAdjusted();
        }
    }

    public void showFile() {
        this.myLSTplugins.showFile(this.myScroller.getCurrentFile());
    }

    public void load(final File loadFile, final Loading loading, final ILoad load, final Thread loadingThread) {
        Runnable runMe = new Runnable(){

            public void run() {
                ListShowTreeCoordinator.this.getTreeManager().showViewTree(loadFile, ListShowTreeCoordinator.this.getTree(), loading);
                ListShowTreeCoordinator.this.getRDPmanager().loadParkAndDeleteNodes();
                try {
                    loadingThread.join();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        load.awtComplete();
                    }
                });
            }
        };
        new Thread(runMe).start();
    }
}

