/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import com.saic.isd.printscreen.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

public class StatusBarManager
implements ScrollerListener {
    ListShowTreeCoordinator myLST;
    JLabel myStatusCount = new JLabel();
    JTextField myStatusFileName = new JTextField();
    StatusBarPopup myStatusBarPopup;
    private static final String AUTO_COPY_FILE_NAME_ENABLED = "autocopyFilename";

    public StatusBarManager(ListShowTreeCoordinator lst) {
        this.myLST = lst;
        this.myStatusFileName.setEditable(false);
        this.myStatusFileName.addMouseListener(new MouseAdpt());
        this.myLST.getScroller().addScrollerListener(this);
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        this.statusCurrentPage();
    }

    public JPanel getStatusPanel() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)this.myStatusCount, "West");
        statusPanel.add((Component)this.myStatusFileName, "Center");
        return statusPanel;
    }

    public AutocopyFilenamePanel getAutocopyFilenamePanel() {
        return new AutocopyFilenamePanel();
    }

    public void statusCurrentPage() {
        try {
            this.myStatusCount.setText(this.myLST.getScroller().getStatusBarCount() + "  ");
            this.myStatusFileName.setText(this.myLST.getScroller().getStatusBarFileName());
            if (this.isAutocopyFilenameEnabled()) {
                Util.copyToClipboard(this.myStatusFileName.getText());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isAutocopyFilenameEnabled() {
        return this.myLST.getPreferences().getBoolean(AUTO_COPY_FILE_NAME_ENABLED, false);
    }

    private void setAutocopyFilenameEnabled(boolean enabled) {
        this.myLST.getPreferences().putBoolean(AUTO_COPY_FILE_NAME_ENABLED, enabled);
    }

    public class AutocopyFilenamePanel
    extends JPanelRows {
        JCheckBox myAutocopyBox = new JCheckBox("Auto-copy current file name to clipboard on each selection");

        AutocopyFilenamePanel() {
            this.myAutocopyBox.setSelected(StatusBarManager.this.isAutocopyFilenameEnabled());
            JPanel aRow = super.topRow();
            aRow.add(this.myAutocopyBox);
        }

        public void save() {
            StatusBarManager.this.setAutocopyFilenameEnabled(this.myAutocopyBox.isSelected());
            if (StatusBarManager.this.isAutocopyFilenameEnabled()) {
                Util.copyToClipboard(StatusBarManager.this.myStatusFileName.getText());
            }
        }
    }

    class StatusBarPopup
    extends JPopupMenu {
        public StatusBarPopup() {
            JPanel center = new JPanel(new FlowLayout(1));
            center.add((Component)new JLabel(AppStarter.getString("FileNamePopUp.0")), 0);
            this.insert(center, 0);
            this.addSeparator();
            JMenuItem copy = this.add(AppStarter.getString("FileNamePopUp.1"));
            JMenuItem autoCopy = null;
            autoCopy = StatusBarManager.this.isAutocopyFilenameEnabled() ? this.add(AppStarter.getString("FileNamePopUp.2")) : this.add(AppStarter.getString("FileNamePopUp.3"));
            copy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Util.copyToClipboard(((StatusBarPopup)StatusBarPopup.this).StatusBarManager.this.myStatusFileName.getText());
                }
            });
            autoCopy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (StatusBarManager.this.isAutocopyFilenameEnabled()) {
                        StatusBarManager.this.setAutocopyFilenameEnabled(false);
                    } else {
                        StatusBarManager.this.setAutocopyFilenameEnabled(true);
                        Util.copyToClipboard(((StatusBarPopup)StatusBarPopup.this).StatusBarManager.this.myStatusFileName.getText());
                    }
                }
            });
        }
    }

    private class MouseAdpt
    extends MouseAdapter {
        private MouseAdpt() {
        }

        public void mouseReleased(MouseEvent e) {
            if (StatusBarManager.this.myStatusBarPopup != null) {
                StatusBarManager.this.myStatusBarPopup.menuSelectionChanged(false);
                StatusBarManager.this.myStatusBarPopup = null;
            } else {
                StatusBarManager.this.myStatusBarPopup = new StatusBarPopup();
                StatusBarManager.this.myStatusBarPopup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

