/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.io.File;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.IOImageImageJ;
import org.gerhardb.lib.image.ImageFactoryPlugin;

class ImageFactoryImageJ
implements ImageFactoryPlugin {
    static String[] clsEndings = new String[]{"jpg", "jpeg", "j2k", "j", "jif", "jiff", "jp2", "jpe", "jpf", "jpx", "tif", "tiff", "dcm", "fits", "pgm", "bmp", "gif"};

    ImageFactoryImageJ() {
    }

    public String[] getEndingsLowercase() {
        return clsEndings;
    }

    public boolean canHandle(File aFile) {
        boolean goodEnding = false;
        String lowerCaseName = aFile.getName().toLowerCase();
        for (int i = 0; i < clsEndings.length; ++i) {
            if (!lowerCaseName.endsWith(clsEndings[i])) continue;
            goodEnding = true;
            break;
        }
        if (goodEnding) {
            try {
                return true;
            }
            catch (Exception ex) {
                System.out.println("ImageFactoryImageJ.canHandle(): " + ex.getMessage());
            }
        }
        return false;
    }

    public IOImage makeImage(File aFile) throws Exception {
        return new IOImageImageJ(aFile);
    }

    public static void main(String[] args) {
        System.out.println("------------------------------------------------------");
        ImageFactoryImageJ factory = new ImageFactoryImageJ();
        String[] endings = factory.getEndingsLowercase();
        for (int i = 0; i < endings.length; ++i) {
            System.out.println(endings[i]);
        }
    }

    public String toString() {
        return "ImageJ";
    }
}

