/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import org.gerhardb.lib.print.MediaFormat;
import org.gerhardb.lib.print.MediaPageable;
import org.gerhardb.lib.print.PageableImage;
import org.gerhardb.lib.print.PrintJobUtils;
import org.gerhardb.lib.swing.GlassPane;
import org.gerhardb.lib.util.startup.AppStarter;

public class PrintUtils {
    public static final int DEFAULT_US_MARGIN = 72;

    public static int scaleDPI(int originalDPI, int targetDPI, int scaleMe) {
        int rtnMe = scaleMe;
        if (originalDPI != targetDPI) {
            rtnMe = targetDPI * scaleMe / originalDPI;
        }
        return rtnMe;
    }

    public static float scaleDPI(int originalDPI, int targetDPI, float scaleMe) {
        return (float)targetDPI * scaleMe / (float)originalDPI;
    }

    public static void printPic(String description, BufferedImage image, Component comp) {
        PageableImage p = new PageableImage(description, image);
        PrintJobUtils.threadedDefaultPrint(p, comp);
    }

    public static void threadedDefaultPrint(final MediaPageable mp, final Component comp) {
        Thread show = new Thread(new Runnable(){

            public void run() {
                PrintUtils.unthreadedPrint(mp, comp);
            }
        });
        show.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unthreadedPrint(MediaPageable mp, Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
        GlassPane eatMe = new GlassPane();
        if (comp instanceof RootPaneContainer) {
            eatMe.setGlassPane((RootPaneContainer)((Object)comp));
        }
        try {
            comp.setCursor(Cursor.getPredefinedCursor(3));
            PrintUtils.print(mp, comp);
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }
        finally {
            comp.setCursor(Cursor.getPredefinedCursor(0));
            eatMe.removeGlassPane();
        }
    }

    public static void print(MediaPageable mp, Component comp) {
        try {
            DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.JPEG;
            PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
            HashPrintRequestAttributeSet requestAttributes = new HashPrintRequestAttributeSet();
            PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, requestAttributes);
            if (printServices == null || printServices.length == 0) {
                System.out.println("no print services");
                return;
            }
            PrintService service = ServiceUI.printDialog(null, 200, 200, printServices, defaultService, flavor, requestAttributes);
            if (service == null) {
                return;
            }
            Class<?>[] classes = service.getSupportedAttributeCategories();
            PrinterResolution resolution = null;
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].getName().equals("javax.print.attribute.standard.PrinterResolution")) continue;
                resolution = (PrinterResolution)service.getDefaultAttributeValue(classes[i]);
            }
            PageFormat pageFormat = mp.getPageFormat(0);
            MediaFormat mediaFormat = new MediaFormat(pageFormat);
            mediaFormat.imprintResolution(resolution);
            PrintRequestAttributeSet printAttributes = PrintUtils.convertToPrintRequestAttributeSet(pageFormat);
            int pageCount = mp.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                Doc doc = mp.getDoc(mediaFormat, i);
                DocPrintJob job = service.createPrintJob();
                job.print(doc, printAttributes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(comp, ex.getMessage(), AppStarter.getString("problem"), 0);
            return;
        }
    }

    public static PrintRequestAttributeSet convertToPrintRequestAttributeSet(PageFormat pf) {
        MediaSizeName media = MediaSize.findMedia((float)pf.getWidth() / 72.0f, (float)pf.getHeight() / 72.0f, 25400);
        MediaPrintableArea area = new MediaPrintableArea((float)pf.getImageableX() / 72.0f, (float)pf.getImageableY() / 72.0f, (float)pf.getImageableWidth() / 72.0f, (float)pf.getImageableHeight() / 72.0f, 25400);
        OrientationRequested orientation = OrientationRequested.PORTRAIT;
        switch (pf.getOrientation()) {
            case 1: {
                orientation = OrientationRequested.PORTRAIT;
                break;
            }
            case 0: {
                orientation = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                orientation = OrientationRequested.REVERSE_LANDSCAPE;
            }
        }
        HashPrintRequestAttributeSet rtnMe = new HashPrintRequestAttributeSet();
        rtnMe.add(media);
        rtnMe.add(area);
        rtnMe.add(orientation);
        return rtnMe;
    }
}

