/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.swing;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.gerhardb.lib.io.IOUtils;

public class JFileChooserExtra
extends JFileChooser {
    private static final String SAVE_HEIGHT = "saveHeight";
    private static final String SAVE_WIDTH = "pickWidth";
    private static final String SAVE_SET = "pickSet";
    Preferences myPrefs;
    JDialog myDialog;

    public JFileChooserExtra() {
    }

    public JFileChooserExtra(File currentDirectory) {
        super(IOUtils.validDirectory(currentDirectory));
    }

    public JFileChooserExtra(File currentDirectory, FileSystemView fsv) {
        super(IOUtils.validDirectory(currentDirectory), fsv);
    }

    public JFileChooserExtra(FileSystemView fsv) {
        super(fsv);
    }

    public JFileChooserExtra(String currentDirectoryPath) {
        super(IOUtils.validDirectory(currentDirectoryPath));
    }

    public JFileChooserExtra(String currentDirectoryPath, FileSystemView fsv) {
        super(IOUtils.validDirectory(currentDirectoryPath), fsv);
    }

    public void setSaveName(String appName, String name) {
        if (name != null && name.length() > 0) {
            this.myPrefs = Preferences.userRoot().node("/" + appName + "/org/gerhardb/lib/swing/JFileChooser/" + name);
        }
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        this.myDialog = super.createDialog(parent);
        if (this.myPrefs == null) {
            return this.myDialog;
        }
        this.myDialog.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent e) {
                JFileChooserExtra.this.saveInfo();
            }
        });
        if (this.myPrefs.getBoolean(SAVE_SET, false)) {
            try {
                Rectangle rect = this.myDialog.getBounds();
                int width = (int)rect.getWidth();
                int height = (int)rect.getHeight();
                width = this.myPrefs.getInt(SAVE_WIDTH, width);
                height = this.myPrefs.getInt(SAVE_HEIGHT, height);
                rect.setSize(width, height);
                this.myDialog.setBounds(rect);
                this.myDialog.setLocationRelativeTo(parent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.myDialog;
    }

    private void saveInfo() {
        try {
            Rectangle rect = this.myDialog.getBounds();
            int width = (int)rect.getWidth();
            int height = (int)rect.getHeight();
            this.myPrefs.putInt(SAVE_WIDTH, width);
            this.myPrefs.putInt(SAVE_HEIGHT, height);
            this.myPrefs.putBoolean(SAVE_SET, true);
        }
        catch (Exception ex) {
            this.myPrefs.putBoolean(SAVE_SET, false);
            ex.printStackTrace();
        }
    }
}

