/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;

public class SwingUtils {
    public static void sizeScreen(Window window, float scale) {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge.isHeadlessInstance()) {
                throw new RuntimeException("Java is reporting that this instance of your GraphicsEnvironment is headless.  A monitor and keyboard are required to run JIBS.");
            }
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            DisplayMode dm = gd.getDisplayMode();
            int width = (int)((float)dm.getWidth() * scale);
            int height = (int)((float)dm.getHeight() * scale);
            window.setSize(new Dimension(width, height));
        }
        catch (RuntimeException ex) {
            window.pack();
        }
    }

    public static void centerOnScreen(Window window) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        Rectangle bounds = window.getBounds();
        if (bounds.width > maxBounds.width) {
            bounds.width = maxBounds.width;
        }
        if (bounds.height > maxBounds.height) {
            bounds.height = maxBounds.height;
        }
        Point center = ge.getCenterPoint();
        int centeredX = (int)(center.getX() - (double)(bounds.width / 2));
        int centeredY = (int)(center.getY() - (double)(bounds.height / 2));
        window.setLocation(centeredX, centeredY);
    }

    public static String ColorToString(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha();
    }

    public static Color StringToColor(String c) {
        try {
            StringTokenizer tokens = new StringTokenizer(c, ",");
            int red = Integer.parseInt(tokens.nextToken());
            int green = Integer.parseInt(tokens.nextToken());
            int blue = Integer.parseInt(tokens.nextToken());
            int alpha = Integer.parseInt(tokens.nextToken());
            return new Color(red, green, blue, alpha);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

