/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util;

import java.text.DecimalFormat;

public class Conversions {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final DecimalFormat FORMAT = new DecimalFormat("0.0");
    public static final long KILOBYTE = 1000L;
    public static final long MEGABYTE = 1000000L;
    public static final long GIGABYTE = 1000000000L;
    public static final long TERABYTE = 1000000000000L;
    public static final long PETABYTE = 1000000000000000L;
    public static final long KIBIBYTE = 1024L;
    public static final long MEBIBYTE = 0x100000L;
    public static final long GIBIBYTE = 0x40000000L;
    public static final long TEBIBYTE = 0x10000000000L;
    public static final long PEBIBYTE = 0x4000000000000L;

    public static String formattedMetricBytes(long bytes) {
        if (bytes >= 1000000000000000L) {
            return FORMAT.format((float)bytes / 1.0E15f) + " PB";
        }
        if (bytes >= 1000000000000L) {
            return FORMAT.format((float)bytes / 1.0E12f) + " TB";
        }
        if (bytes >= 1000000000L) {
            return FORMAT.format((float)bytes / 1.0E9f) + " GB";
        }
        if (bytes >= 1000000L) {
            return FORMAT.format((float)bytes / 1000000.0f) + " MB";
        }
        if (bytes >= 1000L) {
            return FORMAT.format((float)bytes / 1000.0f) + " kB";
        }
        return bytes + " btyes";
    }

    public static String formattedBinaryBytes(long bytes) {
        if (bytes >= 0x4000000000000L) {
            return FORMAT.format((float)bytes / 1.1258999E15f) + " PiB";
        }
        if (bytes >= 0x10000000000L) {
            return FORMAT.format((float)bytes / 1.0995116E12f) + " TiB";
        }
        if (bytes >= 0x40000000L) {
            return FORMAT.format((float)bytes / 1.0737418E9f) + " GiB";
        }
        if (bytes >= 0x100000L) {
            return FORMAT.format((float)bytes / 1048576.0f) + " MiB";
        }
        if (bytes >= 1024L) {
            return FORMAT.format((float)bytes / 1024.0f) + " KiB";
        }
        return bytes + " btyes";
    }

    public static void main(String[] args) {
        System.out.println("KIBIBYTE: " + Conversions.formattedBinaryBytes(1024L) + "   " + 1024L);
        System.out.println("MEBIBYTE: " + Conversions.formattedBinaryBytes(0x100000L) + "   " + 0x100000L);
        System.out.println("GIBIBYTE: " + Conversions.formattedBinaryBytes(0x40000000L) + "   " + 0x40000000L);
        System.out.println("TEBIBYTE: " + Conversions.formattedBinaryBytes(0x10000000000L) + "   " + 0x10000000000L);
        System.out.println("PEBIBYTE: " + Conversions.formattedBinaryBytes(0x4000000000000L) + "   " + 0x4000000000000L);
        System.out.println("???: " + Conversions.formattedBinaryBytes(800L) + "   " + 800);
        System.out.println("???: " + Conversions.formattedBinaryBytes(1000L) + "   " + 1000);
        System.out.println("???: " + Conversions.formattedBinaryBytes(1023L) + "   " + 1023);
        System.out.println("???: " + Conversions.formattedBinaryBytes(1025L) + "   " + 1025);
        System.out.println("???: " + Conversions.formattedBinaryBytes(1900L) + "   " + 1900);
        System.out.println("???: " + Conversions.formattedBinaryBytes(2048L) + "   " + 2048);
        long amt = 933232L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 954204L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0xF00000L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0xFE6666L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0x1000000L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0x1033333L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0x40CCCCCCCL;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0x103333333333L;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
        amt = 0x40CCCCCCCCCCCCL;
        System.out.println("???: " + Conversions.formattedBinaryBytes(amt) + "   " + amt);
    }
}

